function [DSA,CC,PConstDSA,PConstDSAt,PLinDSA,PLinDSAt,AA,dime]=get_subspace_corr_cell(dimSubSpaceEven,Se,Ide,So,Ido,A1,dx,A2,dy,R,MEven,Mse,Mso,Mao)
% see Section 5.4 of Doelz et al, Journal of Scientific Computing (2022) 90:94 https://doi.org/10.1007/s10915-021-01757-9
np=size(dx,2);
nt=size(dx,1);
nso=size(Ido,1);
nse=size(Ide,1);
dimSubSpaceEven=min(dimSubSpaceEven,size(Ide,2)-1);
[Ve,eige]=eigs(@(x)Se*x,size(Se,1),Ide,dimSubSpaceEven,'LA','IsFunctionSymmetric',1,'IsSymmetricDefinite',1);
Vo=Ido\([A1*Ve,A2*Ve]); % range

%     CoMatLo=kron(Vo'*Ido*Vo,Mao+Mso)-kron(Vo'*So*Vo,Mso); % this is more general, but CoMatLo nondiagonal possibly

PConstSphereLO=Ve;
dime=size(Ve,2);
PConstDSAt=@(x)reshape(reshape(x,np,nse)*Ve,np*size(Ve,2),1);
PConstDSA=@(x)reshape(reshape(x,np,size(Ve,2))*Ve',np*nse,1);
MR=cell(size(Ve,2),size(Ve,2));
for i=1:size(Ve,2)
    for j=1:size(Ve,2)
        MR{i,j}=sparse(np,np);
        for k=1:nse
            MR{i,j}=MR{i,j}+Ve(k,i)*(R{k}+MEven{k})*Ve(k,j);
        end
    end
end

% implement A' (M-K)\ A
SSo=Vo'*So*Vo; SSo=0.5*(SSo'+SSo); % enforce symmetry
IIo=Vo'*Ido*Vo;IIo=0.5*(IIo'+IIo); % enforce symmetry
[W,L]=eig(SSo,IIo,'chol'); % small problem
www=W'*IIo*W-eye(size(W,2));
if norm(www(:),'inf')>1e-12,disp('error in get_sub_space_corr_cell: W not orthonormal');end
% require W'*IIo*W=eye
% nW=sqrt(diag(W'*IIo*W));
% W=W*diag(1./nW);

% Observation: CoMatLo from line 10
% kron(I,W')CoMatLo kron(I,W)= kron(I,W') (kron(IIo,Mao+Mso)-kron(SSo,Mso))kron(I,W))
%         = (kron(I,Mao+Mso)-kron(L,Mso))
% Thus inv(CoMatLo) = inv( inv(kron(I,W'))(kron(I,Mao+Mso)-kron(L,Mso)) inv(kron(I,W)) )
% = kron(I,W) inv (kron(I,Mao+Mso)-kron(L,Mso)) kron(I,W')
CC= kron(speye(size(W,2)),Mao+Mso)-kron(diag(sparse(diag(L))),Mso);
CCi=diag(Mao+Mso)-diag(L)'.*diag(Mso);
CCi=diag(sparse(1./CCi(:)));
% test
% CoMatLo=kron(IIo,Mao+Mso)-kron(SSo,Mso); % this is more general, but CoMatLo nondiagonal possibly
% norm(kron(W',speye(size(Mao,2)))*CoMatLo*kron(W,speye(size(Mao,2)))-CC,'inf')/norm(CC,'inf')
% done

PLinSphereLO=Vo*W;
PLinDSAt=@(x)reshape(reshape(x,nt,nso)*PLinSphereLO,nt*size(PLinSphereLO,2),1);
PLinDSA=@(x)reshape(reshape(x,nt,size(PLinSphereLO,2))*PLinSphereLO',nt*nso,1);

AA=kron(PLinSphereLO'*A1*PConstSphereLO,dx)+kron(PLinSphereLO'*A2*PConstSphereLO,dy);
MR=cell2mat(MR);
DSA=AA'*(CCi*AA)+MR-kron(diag(sparse(diag(eige))),Mse);
end