function normal = get_normal(p,e,t)
% normal = get_normal(p,e,t) calculates the unit outward normal vectors
% along the boundary. It is assumed that the triangles are oriented
% counter-clockwise. No orientation for the edges is needed.
% p, e, t is the point, edge and triangle list.
%
% (C) Matthias Schlottbom, 2011.

normal = zeros(2,size(e,2));
edges=sort(e(1:2,:));

[n,ia] = make_normals(p,edges,[t(1,:);t(2,:)]);
normal(:,ia) = n;
[n,ia] = make_normals(p,edges,[t(2,:);t(3,:)]);
normal(:,ia) = n;
[n,ia] = make_normals(p,edges,[t(3,:);t(1,:)]);
normal(:,ia) = n;
end

function [n,ia] = make_normals(p,edges,te)
tes = sort(te(1:2,:));
[c,ia,ib] = intersect(edges',tes','rows'); % find boundary edges
c=c';
p1=p(1:2,c(1,:)); %first point of edge
p2=p(1:2,c(2,:)); %second point of edge
e1=p2-p1; %edges
dt=sqrt(e1(1,:).^2+e1(2,:).^2); % length of edges
n=[e1(2,:)./dt;-e1(1,:)./dt]; % normal vector

%now get the direction correct. here assumptioin: triangle points are
%oriented counter-clockwise
oo=ones(2,size(c,2));
oo(:,(te(1,ib)~=tes(1,ib)) ) = -1; % orientation changed due to sorting
n= oo.*n;
end

