function [p,t,n]=create_octahedron()
% inscribed in unit 2-sphere

% points
p=[ 0, 0, 1, 0, 0; ...
    0, 0, 0, 1,-1; ...
    1,-1, 0, 0, 0];
% triangles
t=[3,4,5,3; ...
   4,3,3,5; ...
   1,2,1,2];
mid=1/3*(p(:,t(1,:))+p(:,t(2,:))+p(:,t(3,:)));
len=sqrt(sum(mid.^2,1));
n=mid./len; % normals to the triangles

%append normal index to triangle
t=[t;1:size(t,2)];
end