function [P,L,U,Q]=compute_lu_cellwise(A,n)
% computes factorization PAQ=LU for a blockdiagonal matrix A with
% n blocks given as a cell array.

P=cell(n,1);
L=cell(n,1);
U=cell(n,1);
Q=cell(n,1);
parfor k=1:n
    [Lt,Ut,Pt,Qt]=lu(A{k});
    U{k}=Ut;
    L{k}=Lt;
    P{k}=Pt;
    Q{k}=Qt;
end
end