function km=assemble_linear_discontinuous_sphere_curved(p,t,a)
% km=assemble_interior(p,t,a)
%
%   assembles mass matrix km = km(a) for pcw linear elements
%   a is the absorption coefficient and can be of size scalar, nodal or element
%   p is the point list of meshpoints
%   t is the triangle list
%
%   (C) Matthias Schlottbom, 2011, 2019, 2021

% The Basisfunctions for the reference Intervall:
nt=size(t,2);   %number of triangles
np=size(p,2);   %number of points

% linear basis functions for the reference simplex
phi=@(x) [1-x(:,1)-x(:,2), x(:,1), x(:,2)]; noBasisFcts=3;

% load integration rules and mapped integration points
[~,volumeForm,ipMapped,w,ip] = get_vol_elem_curved(p,t,13);
lip=length(w); % number of integration points
ipMapped=reshape(ipMapped,3,lip*nt); % integration points per element
% evaluation of basisfunctions in integration points
phiIp = phi(ip'); % dimension: lip x no_basis_fct
row = repmat(1:3*nt,3,1);
col = [kron((1:3:3*nt),[1 1 1]); kron((2:3:3*nt),[1 1 1]);kron((3:3:3*nt),[1 1 1])];

if isa(a,'function_handle')
	aIp = a(ipMapped);
	aIp = reshape(aIp,lip,nt);
elseif length(a) == 1 % constant coefficient
    aIp = a * ones(lip,nt);
elseif length(a) == np % piecewise linear but continuous
    aIp = phiIp * a(t(1:3,:)); %a at integrationpoints
elseif length(a) == nt % piecewise constant
    aIp = repmat(a,lip,1);
end
% build all pairs of basisfunctions evaluated at integration points
wPhiIpTimesPhiIp = kron(repmat(w, 1, noBasisFcts) .* phiIp, ones(1,noBasisFcts)).* repmat(phiIp, 1, noBasisFcts);
val_km = reshape(wPhiIpTimesPhiIp' * (volumeForm.*aIp), 3,3*nt);
km = sparse(row, col, val_km, 3*nt, 3*nt);
end