function km=assemble_interior_sphere(p,t,a)
% [ks,km]=assemble_interior(p,t,c,a)
%
%   assembles mass matrix km = km(a) and stiffness matrix ks = ks(c)
%   c is the diffusion coefficient and can be of size scalar, nodal or element
%   a is the absorption coefficient and can be of size scalar, nodal or element
%   p is the point list of meshpoints
%   t is the triangle list
%
%   (C) Matthias Schlottbom, 2011

% The Basisfunctions for the reference Intervall:
nt=size(t,2);   %number of triangles
np=size(p,2);   %number of points 

% the basis functions
phi=@(x) [1-x(:,1)-x(:,2) ...
          x(:,1) ...
          x(:,2)];
d_phi=[-1 1 0; ...
       -1 0 1 ];
% no_basis = 3; %number of basis functions
precision =3; %demanded precision of integration
[ip,w]=int_rule_tri(precision); %get integration rule, ip is no_ip x dim
no_ip = size(ip,1);
% evaluation of basisfunctions is then phi(ip)
phi_ip = phi(ip);

% transformation matrix to reference element
vol_form=2*get_vol_elem(p,t);

% row and col indices
row = kron(t(1:3,:), [1 1 1]);
col = repmat(reshape(t(1:3,:), 1, 3*nt), 3, 1);

% build mass matrix depending on size of a
if isempty(a)
    km = sparse(np,np);
else
    if length(a) == 1
        a = a * ones(1,nt);
    end
    if length(a) == np
        a_ip = phi_ip * a(t(1:3,:)); %a at integrationpoints
        a_ip = repmat(abs(vol_form),no_ip,1).*a_ip; % a_ip weighted with transformation determinants
        % build all pairs of basisfunctions evaluated at integration points 
        w_phi_ip_times_phi_ip = kron(repmat(w, 1, 3) .* phi_ip, [1 1 1]).* repmat(phi_ip, 1, 3);
        % integrate basisfunctions multiplied with coefficient a
        val_km = reshape(w_phi_ip_times_phi_ip' * a_ip, 3,3*nt);
    elseif length(a) == nt
        int_basis = (repmat(w, 1, 3).* phi_ip)' * phi_ip; % no_basis x no_basis. integrals of basisfunctions on ref element
        val_km = kron(abs(vol_form).* reshape(a, 1, nt), int_basis);
    else 
        fprintf('\n Error. Format of mass coefficient a is not supported.\n');
        return
    end
    km = sparse(row, col, val_km, np, np);
end

% % build stiffness matrix
% if isempty(c)
%     ks=sparse(np,np);
% else
%     if length(c) == 1
%         c = c *ones(1,nt);
%     end
%     if length(c) == np
%         c = sum(c(t(1:3,:)),1)/3; %midpoint
%     end
%     if length(c) ~= nt
%         fprintf('\n Error. Format of diffusion coefficient c is not supported.\n');
%         return
%     end
% 
% 
%     % calculate B^-T grad phi
%     B_inverse = reshape([d2(2,:); -d1(2,:); -d2(1,:); d1(1,:)], 2, 2*nt)./(kron(detB,[1 1; 1 1]));
%     BId_phi = B_inverse'*d_phi;
% 
%     % multiply each gradient with each gradient
%     BB = kron( BId_phi, [1 1 1]) .* repmat(BId_phi, 1, 3); %size: 2 nt x 9
%     % reshape to 2 x 9 nt
%     BB = reshape( BB, [ 2 nt 9 ] );
%     BB = permute( BB, [ 1 3 2 ] );
%     BB = reshape( BB, [ 2 9*nt ] );
%     BB = sum(BB, 1); % performs scalar product of gradients
%     BB = reshape(BB, 3, 3*nt);
%     val_ks = kron(0.5*abs(detB).* reshape(c, 1, nt),ones(3,3)) .* BB; % 0.5 is the integral of ref element
%     ks = sparse(row, col, val_ks, np, np);
% end
end