function [Ke,Ko]=assemble_hg_curved(p,t,g)
% assume that p, t is a triangulation of the half-sphere
% integration is performed on surface triangles

% HG kernel function (cf (2) in [Ren Zhao Zhong, 2019])
kfct=@(mu)(1-g^2)./(1+g^2-2*g*mu).^(3/2)/(4*pi);

nt=size(t,2); %number of triangles
% linear basis functions for the reference simplex
phi=@(x) [1-x(:,1)-x(:,2), x(:,1), x(:,2)]; noBasisFcts=3;

% load integration rules and mapped integration points
[~,volumeForm,ipMapped,w,ip] = get_vol_elem_curved(p,t,13);
lip=length(w); % number of integration points
% evaluation of basisfunctions in integration points
phiIp = phi(ip'); % dimension: lip x no_basis_fct

% in order to access integration points below
ind1=reshape(repmat(1:lip,lip,1),1,lip^2); % 1 1 1 ... 1 2 2 2 .... 2 .... lip lip ... lip
ind2=repmat(1:lip,1,lip); % 1:lip 1:lip ... lip times

% initial integral operators
Ke=zeros(nt,nt); % piecewise constants
Ko=zeros(3,nt,3,nt); % piecewise linears

parfor i=1:nt
    for j=1:nt
        % ssp=inner products of s on Ti with s' on Tj at all combinations integration points on Ti and Tj.
        % [1 1 1 1 2 2 2 2 3 3 3 ... lip lip lip ] .* [1:lip 1:lip ... 1:lip]       
        ssp = sum(ipMapped(:,ind2,i).*ipMapped(:,ind1,j),1); 
        ssp = reshape(ssp,lip,lip);
        k1=kfct(ssp); k2=kfct(-ssp); % evaluate kernel in all combinations of integration points
        Ke(i,j) = (w.*volumeForm(:,i))'*(k1+k2)*(w.*volumeForm(:,j)); % integrate even kernel over Ti x Tj.
        Ko(:,i,:,j)= (repmat(w.*volumeForm(:,i),1,noBasisFcts).*phiIp)'*(k1-k2)*(repmat(w.*volumeForm(:,j),1,noBasisFcts).*phiIp); % integrate odd kernel over Ti x Tj against pcw linear basis.
    end
end
Ko=reshape(Ko,3*nt,3*nt);
end