function [dx,dy]=assemble_dxdy(p,t)
% The Basisfunctions for the reference Intervall:
nt=size(t,2);   %number of triangles
np=size(p,2);   %number of points 

% Psi=@(x) [1-x(1)-x(2);x(1);x(2)];
dPsi=[-1,1,0; ...
      -1,0,1; ...
     ];
% no_basis=3;
  
% precision=2;
% [ip,w]=intrule_tet(precision);

%Integrate all the basis functions and their derivatives over the reference tetrahedron 
%     Psi_eval=zeros(no_basis,length(w));
%     for i=1:length(w)
%         Psi_eval(:,i)=Psi(ip(i,:));
%     end;

p1=p(1:2,t(1,:)); %first node of faces
p2=p(1:2,t(2,:)); %second node of faces
p3=p(1:2,t(3,:)); %third node of faces

% B=[(p2-p1)' (p3-p1)'];
d1=p2-p1;
d2=p3-p1;
detB=(d1(1,:).*d2(2,:))-(d1(2,:).*d2(1,:));

B_inverse=reshape([d2(2,:); -d1(2,:); -d2(1,:); d1(1,:)], 2, 2*nt)./(kron(detB,[1 1; 1 1]));
BIdPsi=B_inverse'*dPsi;

BIdPsi = reshape( BIdPsi, [ 2 nt 3 ] );
BIdPsi = permute( BIdPsi, [ 1 3 2 ] );
BIdPsi = reshape( BIdPsi, [ 2 3*nt ] );

% int_t B^(-T) Grad Psi
detB_rep=reshape(repmat(abs(detB),3,1),1,3*nt);
dx = (BIdPsi(1,:).*detB_rep)/2;
dy = (BIdPsi(2,:).*detB_rep)/2;

row=repmat(1:nt,3,1);
col=t(1:3,:);

dx=sparse(row,col,dx,nt,np);
dy=sparse(row,col,dy,nt,np);
end