function km=assemble_constant_discontinuous_sphere_curved(p,t,a)
%
%   assembles mass matrix km = km(a) of pcw constant fct on the sphere
%   a is the absorption coefficient and can be of size scalar, nodal or element
%   p is the point list of meshpoints
%   t is the triangle list
%
%   (C) Matthias Schlottbom, 2011, 2019, 2021

nt=size(t,2);   %number of triangles
np=size(p,2);   %number of points

% The Basisfunctions for the reference Intervall:
phi=@(x) 1-0*x(:,1); noBasisFcts=1;

% load integration rules and mapped integration points
[~,volumeForm,ipMapped,w,ip] = get_vol_elem_curved(p,t,13);
lip=length(w); % number of integration points
ipMapped=reshape(ipMapped,3,lip*nt); % integration points per element
% evaluation of basisfunctions in integration points
phiIp = phi(ip'); % dimension: lip x no_basis_fct

row = 1:nt;
col = 1:nt;

if isa(a,'function_handle')
	aIp = a(ipMapped);
	aIp = reshape(aIp,lip,nt);
elseif length(a) == 1 % constant coefficient
    aIp = a * ones(lip,nt);
elseif length(a) == np % piecewise linear but continuous
    aIp = phiIp * a(t(1:3,:)); %a at integrationpoints
elseif length(a) == nt % piecewise constant
    aIp = repmat(a,lip,1);
end
wPhiIp = repmat(w, 1, noBasisFcts).* phiIp; %
val_km = wPhiIp'* (volumeForm.*aIp);
km = sparse(row, col, val_km,noBasisFcts*nt, noBasisFcts*nt);
end