function [mass_lin_lin,mass_lin_const,mass_const]=assemble_boundary(p,e,a)
% [mass_lin_lin,mass_lin_const,mass_const]=assemble_boundary(p,e)
%   assembles mass matrices for boundary integrals
%   p are the points of the mesh and e are the edges
%
%   mass_lin       = int_dO c phi_i phi_j dx with phi_i linear functions
%   mass_lin_const = int_dO phi_i chi_j dx with chi_j const functions
%   mass_const     = int_dO chi_i chi_j dx 
%
% (C) Matthias Schlottbom, 2011

ne=size(e,2); %number of elements/edges
np=size(p,2); %number of nodes.

% integrals of the basisfunctions int_ref phi_i*phi_j on ref element
int_lin_lin=[1/3 1/6; ...
             1/6 1/3]; 
% integrals of basisfunction int_ref phi_i on ref element
int_lin=[1/2,1/2];       

% calculate determinants of transformation to ref element
p1 = p(1:2, e(1,:));
p2 = p(1:2, e(2,:));
dt = sqrt((p2(1,:)-p1(1,:)).^2 + (p2(2,:)-p1(2,:)).^2 );

% calculate row and col positions and corresponding values
row = kron(e(1:2,:), [1 1]);
col = repmat(reshape(e(1:2,:), 1, 2*ne), 2, 1);
val = kron(dt.*a, int_lin_lin);
mass_lin_lin = sparse(row, col, val, np, np);

if nargout > 1
    row = repmat(1:ne, 2, 1);
    col = e(1:2, :);
    val = kron(dt.*a, int_lin);
    mass_lin_const = sparse(row, col, val, ne, np);
end

if nargout > 2
    mass_const=sparse(diag(sparse(dt.*a)));
end
end