function x=apply_lu_cellwise(P,L,U,Q,b,m,n)
% solves Ax=b using a PAQ=LU for a blockdiagonal matrix A
% P L U Q are n cell arrays containing mxm matrices
bb=reshape(b,m,n);
x=zeros(m,n);
parfor k=1:n
    x(:,k)=Q{k}*(U{k}\(L{k}\(P{k}*bb(:,k))));
end
x=x(:);