function x = apply_Codd_precond(b, V, G, Ido, Mto, Mtoi, Mso)
	% computes x = (M^- - K_N^-)^{-1} b
	% see Lemma 5 in: Doelz et al, Journal of Scientific Computing (2022) 90:94 https://doi.org/10.1007/s10915-021-01757-9
    B = reshape(b, size(Mto,1), size(Ido,1));
    H = B*V;
    X = Mtoi*(B/Ido-H*V');
    X1=(1./(repmat(diag(Mto),1,size(H,2)) -G(:)'.*diag(Mso))).*H;
    X=X+X1(:,1:size(H,2))*V';
    x=X(:);
end
