function [y,flag,relres,iter] = apply_Codd_inv(z,tol,maxit,Mao,Mso,L2_sphere,Ko,pre)
	% solves for y, solution to (M^- - K^-) y = z using a preconditioned CG method
	% Preconditioner pre is provided. Here, pre = (M^- - K_N^-)^{-1}, see Lemma 5
	% in: Doelz et al, Journal of Scientific Computing (2022) 90:94 https://doi.org/10.1007/s10915-021-01757-9
nt1=size(Mao,2);
nt2=size(L2_sphere,2);
T=@(uo) reshape( (Mao+Mso)*reshape(uo,nt1,nt2)*L2_sphere,nt1*nt2,1)-Ko(uo);
[y,flag,relres,iter]=mypcg(T,z,tol,maxit,pre);
end
