#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Tue Dec 19 14:04:03 2023

Calculate heatwave characteristics for each European region

@author: sutanto
"""

import numpy as np
import netCDF4

#########################################################
# Open heatwave data (past)
# gfdl
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/postdoc_WSG/D3C2_2023/Data/Merve/Heatwaves/hw_summary_gfdl.nc','r')  
lon = file2read.variables['x'][:]
lat = file2read.variables['y'][:]  
pgfdl_numberx = file2read.variables['hweve'][:]  
pgfdl_totdurx = file2read.variables['hwdur'][:]  
pgfdl_frequex = file2read.variables['hwint'][:]  

# Total
pgfdl_numberxx = np.nansum(pgfdl_numberx,3)
pgfdl_number = np.nansum(pgfdl_numberxx,2)
pgfdl_totdurxx = np.nansum(pgfdl_totdurx,3)
pgfdl_totdur = np.nansum(pgfdl_totdurxx,2)
pgfdl_frequexx = np.nanmean(pgfdl_frequex,3)
pgfdl_freque = np.nanmean(pgfdl_frequexx,2)

pgfdl_avedur = pgfdl_totdur/pgfdl_number

# ipsl
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/postdoc_WSG/D3C2_2023/Data/Merve/Heatwaves/hw_summary_ipsl.nc','r')  
pipsl_numberx = file2read.variables['hweve'][:]  
pipsl_totdurx = file2read.variables['hwdur'][:]  
pipsl_frequex = file2read.variables['hwint'][:]  

# Total
pipsl_numberxx = np.nansum(pipsl_numberx,3)
pipsl_number = np.nansum(pipsl_numberxx,2)
pipsl_totdurxx = np.nansum(pipsl_totdurx,3)
pipsl_totdur = np.nansum(pipsl_totdurxx,2)
pipsl_frequexx = np.nanmean(pipsl_frequex,3)
pipsl_freque = np.nanmean(pipsl_frequexx,2)

pipsl_avedur = pipsl_totdur/pipsl_number

# mpi
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/postdoc_WSG/D3C2_2023/Data/Merve/Heatwaves/hw_summary_mpi.nc','r')  
pmpi_numberx = file2read.variables['hweve'][:]  
pmpi_totdurx = file2read.variables['hwdur'][:]  
pmpi_frequex = file2read.variables['hwint'][:]  

# Total
pmpi_numberxx = np.nansum(pmpi_numberx,3)
pmpi_number = np.nansum(pmpi_numberxx,2)
pmpi_totdurxx = np.nansum(pmpi_totdurx,3)
pmpi_totdur = np.nansum(pmpi_totdurxx,2)
pmpi_frequexx = np.nanmean(pmpi_frequex,3)
pmpi_freque = np.nanmean(pmpi_frequexx,2)

pmpi_avedur = pmpi_totdur/pmpi_number

# mri
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/postdoc_WSG/D3C2_2023/Data/Merve/Heatwaves/hw_summary_mri.nc','r')  
pmri_numberx = file2read.variables['hweve'][:]  
pmri_totdurx = file2read.variables['hwdur'][:]  
pmri_frequex = file2read.variables['hwint'][:]  

# Total
pmri_numberxx = np.nansum(pmri_numberx,3)
pmri_number = np.nansum(pmri_numberxx,2)
pmri_totdurxx = np.nansum(pmri_totdurx,3)
pmri_totdur = np.nansum(pmri_totdurxx,2)
pmri_frequexx = np.nanmean(pmri_frequex,3)
pmri_freque = np.nanmean(pmri_frequexx,2)

pmri_avedur = pmri_totdur/pmri_number

# ukesm
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/postdoc_WSG/D3C2_2023/Data/Merve/Heatwaves/hw_summary_ukesm.nc','r')  
pukesm_numberx = file2read.variables['hweve'][:]  
pukesm_totdurx = file2read.variables['hwdur'][:]  
pukesm_frequex = file2read.variables['hwint'][:]  

# Total
pukesm_numberxx = np.nansum(pukesm_numberx,3)
pukesm_number = np.nansum(pukesm_numberxx,2)
pukesm_totdurxx = np.nansum(pukesm_totdurx,3)
pukesm_totdur = np.nansum(pukesm_totdurxx,2)
pukesm_frequexx = np.nanmean(pukesm_frequex,3)
pukesm_freque = np.nanmean(pukesm_frequexx,2)

pukesm_avedur = pukesm_totdur/pukesm_number

#### Ensemble median
ptotdur = np.zeros((len(lon),len(lat),5))
ptotdur[:,:,0] =  pgfdl_totdur
ptotdur[:,:,1] =  pipsl_totdur
ptotdur[:,:,2] =  pmpi_totdur
ptotdur[:,:,3] =  pmri_totdur
ptotdur[:,:,4] =  pukesm_totdur
ptotdurmed = np.median(ptotdur, axis=2)

pavgdur = np.zeros((len(lon),len(lat),5))
pavgdur[:,:,0] =  pgfdl_avedur
pavgdur[:,:,1] =  pipsl_avedur
pavgdur[:,:,2] =  pmpi_avedur
pavgdur[:,:,3] =  pmri_avedur
pavgdur[:,:,4] =  pukesm_avedur
pavgdurmed = np.median(pavgdur, axis=2)

pnumbeve = np.zeros((len(lon),len(lat),5))
pnumbeve[:,:,0] =  pgfdl_number
pnumbeve[:,:,1] =  pipsl_number
pnumbeve[:,:,2] =  pmpi_number
pnumbeve[:,:,3] =  pmri_number
pnumbeve[:,:,4] =  pukesm_number
pnumbevemed = np.median(pnumbeve, axis=2)

pfreque = np.zeros((len(lon),len(lat),5))
pfreque[:,:,0] =  pgfdl_freque
pfreque[:,:,1] =  pipsl_freque
pfreque[:,:,2] =  pmpi_freque
pfreque[:,:,3] =  pmri_freque
pfreque[:,:,4] =  pukesm_freque
pfrequemed = np.median(pfreque, axis=2)

# filtering ocean again
nanloc = np.where(pgfdl_totdur==0)
ptotdurmed[nanloc] = float("nan")
pavgdurmed[nanloc] = float("nan")
pnumbevemed[nanloc] = float("nan")
pfrequemed[nanloc] = float("nan")


#########################################################
# Open heatwave data (ssp126)
# gfdl
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/postdoc_WSG/D3C2_2023/Data/Merve/Heatwaves/hw_summary_gfdl_2.6.nc','r')  
gfdl_number_ssp126x = file2read.variables['hweve'][:]  
gfdl_totdur_ssp126x = file2read.variables['hwdur'][:]  
gfdl_freque_ssp126x = file2read.variables['hwint'][:]  

# Total
gfdl_number_ssp126xx = np.nansum(gfdl_number_ssp126x,3)
gfdl_number_ssp126 = np.nansum(gfdl_number_ssp126xx,2)
gfdl_totdur_ssp126xx = np.nansum(gfdl_totdur_ssp126x,3)
gfdl_totdur_ssp126 = np.nansum(gfdl_totdur_ssp126xx,2)
gfdl_freque_ssp126xx = np.nanmean(gfdl_freque_ssp126x,3)
gfdl_freque_ssp126 = np.nanmean(gfdl_freque_ssp126xx,2)

gfdl_avedur_ssp126 = gfdl_totdur_ssp126/gfdl_number_ssp126


# ipsl
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/postdoc_WSG/D3C2_2023/Data/Merve/Heatwaves/hw_summary_ipsl_2.6.nc','r')  
ipsl_number_ssp126x = file2read.variables['hweve'][:]  
ipsl_totdur_ssp126x = file2read.variables['hwdur'][:]  
ipsl_freque_ssp126x = file2read.variables['hwint'][:]  

# Total
ipsl_number_ssp126xx = np.nansum(ipsl_number_ssp126x,3)
ipsl_number_ssp126 = np.nansum(ipsl_number_ssp126xx,2)
ipsl_totdur_ssp126xx = np.nansum(ipsl_totdur_ssp126x,3)
ipsl_totdur_ssp126 = np.nansum(ipsl_totdur_ssp126xx,2)
ipsl_freque_ssp126xx = np.nanmean(ipsl_freque_ssp126x,3)
ipsl_freque_ssp126 = np.nanmean(ipsl_freque_ssp126xx,2)

ipsl_avedur_ssp126 = ipsl_totdur_ssp126/ipsl_number_ssp126

# mpi
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/postdoc_WSG/D3C2_2023/Data/Merve/Heatwaves/hw_summary_mpi_2.6.nc','r')  
mpi_number_ssp126x = file2read.variables['hweve'][:]  
mpi_totdur_ssp126x = file2read.variables['hwdur'][:]  
mpi_freque_ssp126x = file2read.variables['hwint'][:]  

# Total
mpi_number_ssp126xx = np.nansum(mpi_number_ssp126x,3)
mpi_number_ssp126 = np.nansum(mpi_number_ssp126xx,2)
mpi_totdur_ssp126xx = np.nansum(mpi_totdur_ssp126x,3)
mpi_totdur_ssp126 = np.nansum(mpi_totdur_ssp126xx,2)
mpi_freque_ssp126xx = np.nanmean(mpi_freque_ssp126x,3)
mpi_freque_ssp126 = np.nanmean(mpi_freque_ssp126xx,2)

mpi_avedur_ssp126 = mpi_totdur_ssp126/mpi_number_ssp126

# mri
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/postdoc_WSG/D3C2_2023/Data/Merve/Heatwaves/hw_summary_mri_2.6.nc','r')  
mri_number_ssp126x = file2read.variables['hweve'][:]  
mri_totdur_ssp126x = file2read.variables['hwdur'][:]  
mri_freque_ssp126x = file2read.variables['hwint'][:]  

# Total
mri_number_ssp126xx = np.nansum(mri_number_ssp126x,3)
mri_number_ssp126 = np.nansum(mri_number_ssp126xx,2)
mri_totdur_ssp126xx = np.nansum(mri_totdur_ssp126x,3)
mri_totdur_ssp126 = np.nansum(mri_totdur_ssp126xx,2)
mri_freque_ssp126xx = np.nanmean(mri_freque_ssp126x,3)
mri_freque_ssp126 = np.nanmean(mri_freque_ssp126xx,2)

mri_avedur_ssp126 = mri_totdur_ssp126/mri_number_ssp126

# ukesm
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/postdoc_WSG/D3C2_2023/Data/Merve/Heatwaves/hw_summary_ukesm_2.6.nc','r')  
ukesm_number_ssp126x = file2read.variables['hweve'][:]  
ukesm_totdur_ssp126x = file2read.variables['hwdur'][:]  
ukesm_freque_ssp126x = file2read.variables['hwint'][:]  

# Total
ukesm_number_ssp126xx = np.nansum(ukesm_number_ssp126x,3)
ukesm_number_ssp126 = np.nansum(ukesm_number_ssp126xx,2)
ukesm_totdur_ssp126xx = np.nansum(ukesm_totdur_ssp126x,3)
ukesm_totdur_ssp126 = np.nansum(ukesm_totdur_ssp126xx,2)
ukesm_freque_ssp126xx = np.nanmean(ukesm_freque_ssp126x,3)
ukesm_freque_ssp126 = np.nanmean(ukesm_freque_ssp126xx,2)

ukesm_avedur_ssp126 = ukesm_totdur_ssp126/ukesm_number_ssp126

#### Ensemble median
f1totdur = np.zeros((len(lon),len(lat),5))
f1totdur[:,:,0] =  gfdl_totdur_ssp126
f1totdur[:,:,1] =  ipsl_totdur_ssp126
f1totdur[:,:,2] =  mpi_totdur_ssp126
f1totdur[:,:,3] =  mri_totdur_ssp126
f1totdur[:,:,4] =  ukesm_totdur_ssp126
f1totdurmed = np.median(f1totdur, axis=2)

f1avgdur = np.zeros((len(lon),len(lat),5))
f1avgdur[:,:,0] =  gfdl_avedur_ssp126
f1avgdur[:,:,1] =  ipsl_avedur_ssp126
f1avgdur[:,:,2] =  mpi_avedur_ssp126
f1avgdur[:,:,3] =  mri_avedur_ssp126
f1avgdur[:,:,4] =  ukesm_avedur_ssp126
f1avgdurmed = np.median(f1avgdur, axis=2)

f1numbeve = np.zeros((len(lon),len(lat),5))
f1numbeve[:,:,0] =  gfdl_number_ssp126
f1numbeve[:,:,1] =  ipsl_number_ssp126
f1numbeve[:,:,2] =  mpi_number_ssp126
f1numbeve[:,:,3] =  mri_number_ssp126
f1numbeve[:,:,4] =  ukesm_number_ssp126
f1numbevemed = np.median(f1numbeve, axis=2)

f1freque = np.zeros((len(lon),len(lat),5))
f1freque[:,:,0] =  gfdl_freque_ssp126
f1freque[:,:,1] =  ipsl_freque_ssp126
f1freque[:,:,2] =  mpi_freque_ssp126
f1freque[:,:,3] =  mri_freque_ssp126
f1freque[:,:,4] =  ukesm_freque_ssp126
f1frequemed = np.median(f1freque, axis=2)

# filtering ocean again
f1totdurmed[nanloc] = float("nan")
f1avgdurmed[nanloc] = float("nan")
f1numbevemed[nanloc] = float("nan")
f1frequemed[nanloc] = float("nan")

#########################################################
# Open heatwave data (ssp585)
# gfdl
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/postdoc_WSG/D3C2_2023/Data/Merve/Heatwaves/hw_summary_gfdl_8.5.nc','r')  
gfdl_number_ssp585x = file2read.variables['hweve'][:]  
gfdl_totdur_ssp585x = file2read.variables['hwdur'][:]  
gfdl_freque_ssp585x = file2read.variables['hwint'][:]  

# Total
gfdl_number_ssp585xx = np.nansum(gfdl_number_ssp585x,3)
gfdl_number_ssp585 = np.nansum(gfdl_number_ssp585xx,2)
gfdl_totdur_ssp585xx = np.nansum(gfdl_totdur_ssp585x,3)
gfdl_totdur_ssp585 = np.nansum(gfdl_totdur_ssp585xx,2)
gfdl_freque_ssp585xx = np.nanmean(gfdl_freque_ssp585x,3)
gfdl_freque_ssp585 = np.nanmean(gfdl_freque_ssp585xx,2)

gfdl_avedur_ssp585 = gfdl_totdur_ssp585/gfdl_number_ssp585

# ipsl
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/postdoc_WSG/D3C2_2023/Data/Merve/Heatwaves/hw_summary_ipsl_8.5.nc','r')  
ipsl_number_ssp585x = file2read.variables['hweve'][:]  
ipsl_totdur_ssp585x = file2read.variables['hwdur'][:]  
ipsl_freque_ssp585x = file2read.variables['hwint'][:]  

# Total
ipsl_number_ssp585xx = np.nansum(ipsl_number_ssp585x,3)
ipsl_number_ssp585 = np.nansum(ipsl_number_ssp585xx,2)
ipsl_totdur_ssp585xx = np.nansum(ipsl_totdur_ssp585x,3)
ipsl_totdur_ssp585 = np.nansum(ipsl_totdur_ssp585xx,2)
ipsl_freque_ssp585xx = np.nanmean(ipsl_freque_ssp585x,3)
ipsl_freque_ssp585 = np.nanmean(ipsl_freque_ssp585xx,2)

ipsl_avedur_ssp585 = ipsl_totdur_ssp585/ipsl_number_ssp585

# mpi
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/postdoc_WSG/D3C2_2023/Data/Merve/Heatwaves/hw_summary_mpi_8.5.nc','r')  
mpi_number_ssp585x = file2read.variables['hweve'][:]  
mpi_totdur_ssp585x= file2read.variables['hwdur'][:]  
mpi_freque_ssp585x = file2read.variables['hwint'][:]  

# Total
mpi_number_ssp585xx = np.nansum(mpi_number_ssp585x,3)
mpi_number_ssp585 = np.nansum(mpi_number_ssp585xx,2)
mpi_totdur_ssp585xx = np.nansum(mpi_totdur_ssp585x,3)
mpi_totdur_ssp585 = np.nansum(mpi_totdur_ssp585xx,2)
mpi_freque_ssp585xx = np.nanmean(mpi_freque_ssp585x,3)
mpi_freque_ssp585 = np.nanmean(mpi_freque_ssp585xx,2)

mpi_avedur_ssp585 = mpi_totdur_ssp585/mpi_number_ssp585

# mri
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/postdoc_WSG/D3C2_2023/Data/Merve/Heatwaves/hw_summary_mri_8.5.nc','r')  
mri_number_ssp585x = file2read.variables['hweve'][:]  
mri_totdur_ssp585x = file2read.variables['hwdur'][:]  
mri_freque_ssp585x = file2read.variables['hwint'][:]  

# Total
mri_number_ssp585xx = np.nansum(mri_number_ssp585x,3)
mri_number_ssp585 = np.nansum(mri_number_ssp585xx,2)
mri_totdur_ssp585xx = np.nansum(mri_totdur_ssp585x,3)
mri_totdur_ssp585 = np.nansum(mri_totdur_ssp585xx,2)
mri_freque_ssp585xx = np.nanmean(mri_freque_ssp585x,3)
mri_freque_ssp585 = np.nanmean(mri_freque_ssp585xx,2)

mri_avedur_ssp585 = mri_totdur_ssp585/mri_number_ssp585

# ukesm
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/postdoc_WSG/D3C2_2023/Data/Merve/Heatwaves/hw_summary_ukesm_8.5.nc','r')  
ukesm_number_ssp585x = file2read.variables['hweve'][:]  
ukesm_totdur_ssp585x = file2read.variables['hwdur'][:]  
ukesm_freque_ssp585x = file2read.variables['hwint'][:]  

# Total
ukesm_number_ssp585xx = np.nansum(ukesm_number_ssp585x,3)
ukesm_number_ssp585 = np.nansum(ukesm_number_ssp585xx,2)
ukesm_totdur_ssp585xx = np.nansum(ukesm_totdur_ssp585x,3)
ukesm_totdur_ssp585 = np.nansum(ukesm_totdur_ssp585xx,2)
ukesm_freque_ssp585xx = np.nanmean(ukesm_freque_ssp585x,3)
ukesm_freque_ssp585 = np.nanmean(ukesm_freque_ssp585xx,2)

ukesm_avedur_ssp585 = ukesm_totdur_ssp585/ukesm_number_ssp585

#### Ensemble median
f2totdur = np.zeros((len(lon),len(lat),5))
f2totdur[:,:,0] =  gfdl_totdur_ssp585
f2totdur[:,:,1] =  ipsl_totdur_ssp585
f2totdur[:,:,2] =  mpi_totdur_ssp585
f2totdur[:,:,3] =  mri_totdur_ssp585
f2totdur[:,:,4] =  ukesm_totdur_ssp585
f2totdurmed = np.median(f2totdur, axis=2)

f2avgdur = np.zeros((len(lon),len(lat),5))
f2avgdur[:,:,0] =  gfdl_avedur_ssp585
f2avgdur[:,:,1] =  ipsl_avedur_ssp585
f2avgdur[:,:,2] =  mpi_avedur_ssp585
f2avgdur[:,:,3] =  mri_avedur_ssp585
f2avgdur[:,:,4] =  ukesm_avedur_ssp585
f2avgdurmed = np.median(f2avgdur, axis=2)

f2numbeve = np.zeros((len(lon),len(lat),5))
f2numbeve[:,:,0] =  gfdl_number_ssp585
f2numbeve[:,:,1] =  ipsl_number_ssp585
f2numbeve[:,:,2] =  mpi_number_ssp585
f2numbeve[:,:,3] =  mri_number_ssp585
f2numbeve[:,:,4] =  ukesm_number_ssp585
f2numbevemed = np.median(f2numbeve, axis=2)

f2freque = np.zeros((len(lon),len(lat),5))
f2freque[:,:,0] =  gfdl_freque_ssp585
f2freque[:,:,1] =  ipsl_freque_ssp585
f2freque[:,:,2] =  mpi_freque_ssp585
f2freque[:,:,3] =  mri_freque_ssp585
f2freque[:,:,4] =  ukesm_freque_ssp585
f2frequemed = np.median(f2freque, axis=2)

# filtering ocean again
f2totdurmed[nanloc] = float("nan")
f2avgdurmed[nanloc] = float("nan")
f2numbevemed[nanloc] = float("nan")
f2frequemed[nanloc] = float("nan")

#########################################################
# Future changes (ssp126)
Diff_totdur1 = f1totdurmed - ptotdurmed
Diff_avgdur1 = f1avgdurmed - pavgdurmed
Diff_numbeve1 = f1numbevemed - pnumbevemed
Diff_freque1 = f1frequemed - pfrequemed

# Future changes (ssp585)
Diff_totdur2 = f2totdurmed - ptotdurmed
Diff_avgdur2 = f2avgdurmed - pavgdurmed
Diff_numbeve2 = f2numbevemed - pnumbevemed
Diff_freque2 = f2frequemed - pfrequemed



#########################################################
#########################################################
# Finding nearest value
def find_nearest(array, value):
    array = np.asarray(array)
    idx = (np.abs(array - value)).argmin()
    return array[idx]

# Northern Europe
# Scandinavian and iceland
lona = -25.17
lata = 72.24

lonb = 29.3
latb = 56.75

loc1a = np.where(lon==find_nearest(lon,lona))
loc2a = np.where(lat==find_nearest(lat,lata))

loc1b = np.where(lon==find_nearest(lon,lonb))
loc2b = np.where(lat==find_nearest(lat,latb))
 
NE1num = np.squeeze(pnumbevemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
NE1num126 = np.squeeze(f1numbevemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
NE1num585 = np.squeeze(f2numbevemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

NE1todur = np.squeeze(ptotdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
NE1todur126 = np.squeeze(f1totdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
NE1todur585 = np.squeeze(f2totdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

NE1avdur = np.squeeze(pavgdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
NE1avdur126 = np.squeeze(f1avgdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
NE1avdur585 = np.squeeze(f2avgdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

NE1fre = np.squeeze(pfrequemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
NE1fre126 = np.squeeze(f1frequemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
NE1fre585 = np.squeeze(f2frequemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

# England walles
lona = -25.17
lata = 56.75

lonb = 2.25
latb = 51.29

loc1a = np.where(lon==find_nearest(lon,lona))
loc2a = np.where(lat==find_nearest(lat,lata))

loc1b = np.where(lon==find_nearest(lon,lonb))
loc2b = np.where(lat==find_nearest(lat,latb))
 
NE2num = np.squeeze(pnumbevemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
NE2num126 = np.squeeze(f1numbevemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
NE2num585 = np.squeeze(f2numbevemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

NE2todur = np.squeeze(ptotdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
NE2todur126 = np.squeeze(f1totdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
NE2todur585 = np.squeeze(f2totdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

NE2avdur = np.squeeze(pavgdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
NE2avdur126 = np.squeeze(f1avgdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
NE2avdur585 = np.squeeze(f2avgdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

NE2fre = np.squeeze(pfrequemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
NE2fre126 = np.squeeze(f1frequemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
NE2fre585 = np.squeeze(f2frequemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

NE3num = np.nanmean(NE1num)
NE4num = np.nanmean(NE2num)
NE3num126 = np.nanmean(NE1num126)
NE4num126 = np.nanmean(NE2num126)
NE3num585 = np.nanmean(NE1num585)
NE4num585 = np.nanmean(NE2num585)

NE3todur = np.nanmean(NE1todur)
NE4todur = np.nanmean(NE2todur)
NE3todur126 = np.nanmean(NE1todur126)
NE4todur126 = np.nanmean(NE2todur126)
NE3todur585 = np.nanmean(NE1todur585)
NE4todur585 = np.nanmean(NE2todur585)

NE3avdur = np.nanmean(NE1avdur)
NE4avdur = np.nanmean(NE2avdur)
NE3avdur126 = np.nanmean(NE1avdur126)
NE4avdur126 = np.nanmean(NE2avdur126)
NE3avdur585 = np.nanmean(NE1avdur585)
NE4avdur585 = np.nanmean(NE2avdur585)

NE3fre = np.nanmean(NE1fre)
NE4fre = np.nanmean(NE2fre)
NE3fre126 = np.nanmean(NE1fre126)
NE4fre126 = np.nanmean(NE2fre126)
NE3fre585 = np.nanmean(NE1fre585)
NE4fre585 = np.nanmean(NE2fre585)

NEnum = (NE3num+NE4num)/2
NEnum126 = (NE3num126+NE4num126)/2
NEnum585 = (NE3num585+NE4num585)/2
print('NE Number',NEnum,NEnum126,NEnum585)

NEtodur = (NE3todur+NE4todur)/2
NEtodur126 = (NE3todur126+NE4todur126)/2
NEtodur585 = (NE3todur585+NE4todur585)/2
print('Total duration',NEtodur,NEtodur126,NEtodur585)

NEavdur = (NE3avdur+NE4avdur)/2
NEavdur126 = (NE3avdur126+NE4avdur126)/2
NEavdur585 = (NE3avdur585+NE4avdur585)/2
print('Average duration',NEavdur,NEavdur126,NEavdur585)

NEfre = (NE3fre+NE4fre)/2
NEfre126 = (NE3fre126+NE4fre126)/2
NEfre585 = (NE3fre585+NE4fre585)/2
print('Frequency',NEfre,NEfre126,NEfre585)


#########################################################
# Western Europe
# Benelux to Germany
lona = 2.6
lata = 54.8

lonb = 14.9
latb = 46.6

loc1a = np.where(lon==find_nearest(lon,lona))
loc2a = np.where(lat==find_nearest(lat,lata))

loc1b = np.where(lon==find_nearest(lon,lonb))
loc2b = np.where(lat==find_nearest(lat,latb))
 
WE1num = np.squeeze(pnumbevemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1num126 = np.squeeze(f1numbevemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1num585 = np.squeeze(f2numbevemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE1todur = np.squeeze(ptotdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1todur126 = np.squeeze(f1totdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1todur585 = np.squeeze(f2totdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE1avdur = np.squeeze(pavgdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1avdur126 = np.squeeze(f1avgdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1avdur585 = np.squeeze(f2avgdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE1fre = np.squeeze(pfrequemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1fre126 = np.squeeze(f1frequemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1fre585 = np.squeeze(f2frequemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

# France
lona = -4.7
lata = 46.6

lonb = 7.6
latb = 42.2

loc1a = np.where(lon==find_nearest(lon,lona))
loc2a = np.where(lat==find_nearest(lat,lata))

loc1b = np.where(lon==find_nearest(lon,lonb))
loc2b = np.where(lat==find_nearest(lat,latb))
 
WE2num = np.squeeze(pnumbevemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2num126 = np.squeeze(f1numbevemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2num585 = np.squeeze(f2numbevemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE2todur = np.squeeze(ptotdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2todur126 = np.squeeze(f1totdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2todur585 = np.squeeze(f2totdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE2avdur = np.squeeze(pavgdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2avdur126 = np.squeeze(f1avgdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2avdur585 = np.squeeze(f2avgdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE2fre = np.squeeze(pfrequemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2fre126 = np.squeeze(f1frequemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2fre585 = np.squeeze(f2frequemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE3num = np.nanmean(WE1num)
WE4num = np.nanmean(WE2num)
WE3num126 = np.nanmean(WE1num126)
WE4num126 = np.nanmean(WE2num126)
WE3num585 = np.nanmean(WE1num585)
WE4num585 = np.nanmean(WE2num585)

WE3todur = np.nanmean(WE1todur)
WE4todur = np.nanmean(WE2todur)
WE3todur126 = np.nanmean(WE1todur126)
WE4todur126 = np.nanmean(WE2todur126)
WE3todur585 = np.nanmean(WE1todur585)
WE4todur585 = np.nanmean(WE2todur585)

WE3avdur = np.nanmean(WE1avdur)
WE4avdur = np.nanmean(WE2avdur)
WE3avdur126 = np.nanmean(WE1avdur126)
WE4avdur126 = np.nanmean(WE2avdur126)
WE3avdur585 = np.nanmean(WE1avdur585)
WE4avdur585 = np.nanmean(WE2avdur585)

WE3fre = np.nanmean(WE1fre)
WE4fre = np.nanmean(WE2fre)
WE3fre126 = np.nanmean(WE1fre126)
WE4fre126 = np.nanmean(WE2fre126)
WE3fre585 = np.nanmean(WE1fre585)
WE4fre585 = np.nanmean(WE2fre585)

WEnum = (WE3num+WE4num)/2
WEnum126 = (WE3num126+WE4num126)/2
WEnum585 = (WE3num585+WE4num585)/2
print('WE Number',WEnum,WEnum126,WEnum585)

WEtodur = (WE3todur+WE4todur)/2
WEtodur126 = (WE3todur126+WE4todur126)/2
WEtodur585 = (WE3todur585+WE4todur585)/2
print('Total duration',WEtodur,WEtodur126,WEtodur585)

WEavdur = (WE3avdur+WE4avdur)/2
WEavdur126 = (WE3avdur126+WE4avdur126)/2
WEavdur585 = (WE3avdur585+WE4avdur585)/2
print('Average duration',WEavdur,WEavdur126,WEavdur585)

WEfre = (WE3fre+WE4fre)/2
WEfre126 = (WE3fre126+WE4fre126)/2
WEfre585 = (WE3fre585+WE4fre585)/2
print('Frequency',WEfre,WEfre126,WEfre585)


######################################################### I just change the name in the end
# Eastern Europe 
# Poland to Romania
lona = 14.5
lata = 54.6

lonb = 45
latb = 45.9

loc1a = np.where(lon==find_nearest(lon,lona))
loc2a = np.where(lat==find_nearest(lat,lata))

loc1b = np.where(lon==find_nearest(lon,lonb))
loc2b = np.where(lat==find_nearest(lat,latb))
 
WE1num = np.squeeze(pnumbevemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1num126 = np.squeeze(f1numbevemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1num585 = np.squeeze(f2numbevemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE1todur = np.squeeze(ptotdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1todur126 = np.squeeze(f1totdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1todur585 = np.squeeze(f2totdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE1avdur = np.squeeze(pavgdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1avdur126 = np.squeeze(f1avgdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1avdur585 = np.squeeze(f2avgdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE1fre = np.squeeze(pfrequemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1fre126 = np.squeeze(f1frequemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1fre585 = np.squeeze(f2frequemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

# Bulgaria and russia
lona = 22.9
lata = 45.9

lonb = 45
latb = 41

loc1a = np.where(lon==find_nearest(lon,lona))
loc2a = np.where(lat==find_nearest(lat,lata))

loc1b = np.where(lon==find_nearest(lon,lonb))
loc2b = np.where(lat==find_nearest(lat,latb))
 
WE2num = np.squeeze(pnumbevemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2num126 = np.squeeze(f1numbevemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2num585 = np.squeeze(f2numbevemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE2todur = np.squeeze(ptotdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2todur126 = np.squeeze(f1totdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2todur585 = np.squeeze(f2totdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE2avdur = np.squeeze(pavgdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2avdur126 = np.squeeze(f1avgdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2avdur585 = np.squeeze(f2avgdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE2fre = np.squeeze(pfrequemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2fre126 = np.squeeze(f1frequemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2fre585 = np.squeeze(f2frequemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

# North russia
lona = 29.8
lata = 69.9

lonb = 45
latb = 54.6

loc1a = np.where(lon==find_nearest(lon,lona))
loc2a = np.where(lat==find_nearest(lat,lata))

loc1b = np.where(lon==find_nearest(lon,lonb))
loc2b = np.where(lat==find_nearest(lat,latb))
 
WE3num = np.squeeze(pnumbevemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE3num126 = np.squeeze(f1numbevemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE3num585 = np.squeeze(f2numbevemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE3todur = np.squeeze(ptotdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE3todur126 = np.squeeze(f1totdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE3todur585 = np.squeeze(f2totdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE3avdur = np.squeeze(pavgdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE3avdur126 = np.squeeze(f1avgdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE3avdur585 = np.squeeze(f2avgdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE3fre = np.squeeze(pfrequemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE3fre126 = np.squeeze(f1frequemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE3fre585 = np.squeeze(f2frequemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])


WE4num = np.nanmean(WE1num)
WE5num = np.nanmean(WE2num)
WE6num = np.nanmean(WE3num)
WE4num126 = np.nanmean(WE1num126)
WE5num126 = np.nanmean(WE2num126)
WE6num126 = np.nanmean(WE3num126)
WE4num585 = np.nanmean(WE1num585)
WE5num585 = np.nanmean(WE2num585)
WE6num585 = np.nanmean(WE3num585)

WE4todur = np.nanmean(WE1todur)
WE5todur = np.nanmean(WE2todur)
WE6todur = np.nanmean(WE3todur)
WE4todur126 = np.nanmean(WE1todur126)
WE5todur126 = np.nanmean(WE2todur126)
WE6todur126 = np.nanmean(WE3todur126)
WE4todur585 = np.nanmean(WE1todur585)
WE5todur585 = np.nanmean(WE2todur585)
WE6todur585 = np.nanmean(WE3todur585)

WE4avdur = np.nanmean(WE1avdur)
WE5avdur = np.nanmean(WE2avdur)
WE6avdur = np.nanmean(WE3avdur)
WE4avdur126 = np.nanmean(WE1avdur126)
WE5avdur126 = np.nanmean(WE2avdur126)
WE6avdur126 = np.nanmean(WE3avdur126)
WE4avdur585 = np.nanmean(WE1avdur585)
WE5avdur585 = np.nanmean(WE2avdur585)
WE6avdur585 = np.nanmean(WE3avdur585)

WE4fre = np.nanmean(WE1fre)
WE5fre = np.nanmean(WE2fre)
WE6fre = np.nanmean(WE3fre)
WE4fre126 = np.nanmean(WE1fre126)
WE5fre126 = np.nanmean(WE2fre126)
WE6fre126 = np.nanmean(WE3fre126)
WE4fre585 = np.nanmean(WE1fre585)
WE5fre585 = np.nanmean(WE2fre585)
WE6fre585 = np.nanmean(WE3fre585)

EEnum = (WE4num+WE5num+WE6num)/3
EEnum126 = (WE4num126+WE5num126+WE6num126)/3
EEnum585 = (WE4num585+WE5num585+WE6num585)/3
print('EE Number',EEnum,EEnum126,EEnum585)

EEtodur = (WE4todur+WE5todur+WE6todur)/3
EEtodur126 = (WE4todur126+WE5todur126+WE6todur126)/3
EEtodur585 = (WE4todur585+WE5todur585+WE6todur585)/3
print('Total duration',EEtodur,EEtodur126,EEtodur585)

EEavdur = (WE4avdur+WE5avdur+WE6avdur)/3
EEavdur126 = (WE4avdur126+WE5avdur126+WE6avdur126)/3
EEavdur585 = (WE4avdur585+WE5avdur585+WE6avdur585)/3
print('Average duration',EEavdur,EEavdur126,EEavdur585)

EEfre = (WE4fre+WE5fre+WE6fre)/3
EEfre126 = (WE4fre126+WE5fre126+WE6fre126)/3
EEfre585 = (WE4fre585+WE5fre585+WE6fre585)/3
print('Frequency',EEfre,EEfre126,EEfre585)


######################################################### I just change the name in the end
# Southern Europe
# Spain
lona = -10.3
lata = 43.5

lonb = 3.1
latb = 36.3

loc1a = np.where(lon==find_nearest(lon,lona))
loc2a = np.where(lat==find_nearest(lat,lata))

loc1b = np.where(lon==find_nearest(lon,lonb))
loc2b = np.where(lat==find_nearest(lat,latb))
 
WE1num = np.squeeze(pnumbevemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1num126 = np.squeeze(f1numbevemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1num585 = np.squeeze(f2numbevemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE1todur = np.squeeze(ptotdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1todur126 = np.squeeze(f1totdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1todur585 = np.squeeze(f2totdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE1avdur = np.squeeze(pavgdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1avdur126 = np.squeeze(f1avgdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1avdur585 = np.squeeze(f2avgdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE1fre = np.squeeze(pfrequemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1fre126 = np.squeeze(f1frequemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1fre585 = np.squeeze(f2frequemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

# Italy balkan
lona = 6.9
lata = 45.9

lonb = 22.4
latb = 36.2

loc1a = np.where(lon==find_nearest(lon,lona))
loc2a = np.where(lat==find_nearest(lat,lata))

loc1b = np.where(lon==find_nearest(lon,lonb))
loc2b = np.where(lat==find_nearest(lat,latb))
 
WE2num = np.squeeze(pnumbevemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2num126 = np.squeeze(f1numbevemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2num585 = np.squeeze(f2numbevemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE2todur = np.squeeze(ptotdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2todur126 = np.squeeze(f1totdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2todur585 = np.squeeze(f2totdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE2avdur = np.squeeze(pavgdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2avdur126 = np.squeeze(f1avgdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2avdur585 = np.squeeze(f2avgdurmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE2fre = np.squeeze(pfrequemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2fre126 = np.squeeze(f1frequemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2fre585 = np.squeeze(f2frequemed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE3num = np.nanmean(WE1num)
WE4num = np.nanmean(WE2num)
WE3num126 = np.nanmean(WE1num126)
WE4num126 = np.nanmean(WE2num126)
WE3num585 = np.nanmean(WE1num585)
WE4num585 = np.nanmean(WE2num585)

WE3todur = np.nanmean(WE1todur)
WE4todur = np.nanmean(WE2todur)
WE3todur126 = np.nanmean(WE1todur126)
WE4todur126 = np.nanmean(WE2todur126)
WE3todur585 = np.nanmean(WE1todur585)
WE4todur585 = np.nanmean(WE2todur585)

WE3avdur = np.nanmean(WE1avdur)
WE4avdur = np.nanmean(WE2avdur)
WE3avdur126 = np.nanmean(WE1avdur126)
WE4avdur126 = np.nanmean(WE2avdur126)
WE3avdur585 = np.nanmean(WE1avdur585)
WE4avdur585 = np.nanmean(WE2avdur585)

WE3fre = np.nanmean(WE1fre)
WE4fre = np.nanmean(WE2fre)
WE3fre126 = np.nanmean(WE1fre126)
WE4fre126 = np.nanmean(WE2fre126)
WE3fre585 = np.nanmean(WE1fre585)
WE4fre585 = np.nanmean(WE2fre585)

SEnum = (WE3num+WE4num)/2
SEnum126 = (WE3num126+WE4num126)/2
SEnum585 = (WE3num585+WE4num585)/2
print('SE Number',SEnum,SEnum126,SEnum585)

SEtodur = (WE3todur+WE4todur)/2
SEtodur126 = (WE3todur126+WE4todur126)/2
SEtodur585 = (WE3todur585+WE4todur585)/2
print('Total duration',SEtodur,SEtodur126,SEtodur585)

SEavdur = (WE3avdur+WE4avdur)/2
SEavdur126 = (WE3avdur126+WE4avdur126)/2
SEavdur585 = (WE3avdur585+WE4avdur585)/2
print('Average duration',SEavdur,SEavdur126,SEavdur585)

SEfre = (WE3fre+WE4fre)/2
SEfre126 = (WE3fre126+WE4fre126)/2
SEfre585 = (WE3fre585+WE4fre585)/2
print('Frequency',SEfre,SEfre126,SEfre585)

