#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Tue Dec 19 14:13:27 2023

Calculate CnC characteristics for each European region

@author: sutanto
"""

import numpy as np
import netCDF4


#########################################################
# Open compound data pas event
# gfdl
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/Data/Merve/Compound/CnC_summary_gfdl_past.nc','r')  
lon = file2read.variables['x'][:]
lat = file2read.variables['y'][:]  

gfdl_numCDH = file2read.variables['numCDH'][:]  
gfdl_durCDH = file2read.variables['durCDH'][:]  
gfdl_avdurCDH = file2read.variables['avdurCDH'][:]  
gfdl_freCDH = file2read.variables['freCDH'][:]  

gfdl_numCaDH = file2read.variables['numCaDH'][:]  
gfdl_durCaDH = file2read.variables['durCaDH'][:]  
gfdl_avdurCaDH = file2read.variables['avdurCaDH'][:]  
gfdl_freCaDH = file2read.variables['freCaDH'][:]  

# ipsl
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/Data/Merve/Compound/CnC_summary_ipsl_past.nc','r')  
ipsl_numCDH = file2read.variables['numCDH'][:]  
ipsl_durCDH = file2read.variables['durCDH'][:]  
ipsl_avdurCDH = file2read.variables['avdurCDH'][:]  
ipsl_freCDH = file2read.variables['freCDH'][:]  

ipsl_numCaDH = file2read.variables['numCaDH'][:]  
ipsl_durCaDH = file2read.variables['durCaDH'][:]  
ipsl_avdurCaDH = file2read.variables['avdurCaDH'][:]  
ipsl_freCaDH = file2read.variables['freCaDH'][:]  

# mpi
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/Data/Merve/Compound/CnC_summary_mpi_past.nc','r')  
mpi_numCDH = file2read.variables['numCDH'][:]  
mpi_durCDH = file2read.variables['durCDH'][:]  
mpi_avdurCDH = file2read.variables['avdurCDH'][:]  
mpi_freCDH = file2read.variables['freCDH'][:]  

mpi_numCaDH = file2read.variables['numCaDH'][:]  
mpi_durCaDH = file2read.variables['durCaDH'][:]  
mpi_avdurCaDH = file2read.variables['avdurCaDH'][:]  
mpi_freCaDH = file2read.variables['freCaDH'][:]  

# mri
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/Data/Merve/Compound/CnC_summary_mri_past.nc','r')  
mri_numCDH = file2read.variables['numCDH'][:]  
mri_durCDH = file2read.variables['durCDH'][:]  
mri_avdurCDH = file2read.variables['avdurCDH'][:]  
mri_freCDH = file2read.variables['freCDH'][:]  

mri_numCaDH = file2read.variables['numCaDH'][:]  
mri_durCaDH = file2read.variables['durCaDH'][:]  
mri_avdurCaDH = file2read.variables['avdurCaDH'][:]  
mri_freCaDH = file2read.variables['freCaDH'][:]  

# ukesm
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/Data/Merve/Compound/CnC_summary_ukesm_past.nc','r')  
ukesm_numCDH = file2read.variables['numCDH'][:]  
ukesm_durCDH = file2read.variables['durCDH'][:]  
ukesm_avdurCDH = file2read.variables['avdurCDH'][:]  
ukesm_freCDH = file2read.variables['freCDH'][:]  

ukesm_numCaDH = file2read.variables['numCaDH'][:]  
ukesm_durCaDH = file2read.variables['durCaDH'][:]  
ukesm_avdurCaDH = file2read.variables['avdurCaDH'][:]  
ukesm_freCaDH = file2read.variables['freCaDH'][:]  

#### Ensemble median compound
totdurcdh = np.zeros((len(lon),len(lat),5))
totdurcdh[:,:,0] =  gfdl_durCDH
totdurcdh[:,:,1] =  ipsl_durCDH
totdurcdh[:,:,2] =  mpi_durCDH
totdurcdh[:,:,3] =  mri_durCDH
totdurcdh[:,:,4] =  ukesm_durCDH
totdurcdhmed = np.median(totdurcdh, axis=2)

avgdurcdh = np.zeros((len(lon),len(lat),5))
avgdurcdh[:,:,0] =  gfdl_avdurCDH
avgdurcdh[:,:,1] =  ipsl_avdurCDH
avgdurcdh[:,:,2] =  mpi_avdurCDH
avgdurcdh[:,:,3] =  mri_avdurCDH
avgdurcdh[:,:,4] =  ukesm_avdurCDH
avgdurcdhmed = np.median(avgdurcdh, axis=2)

numbevecdh = np.zeros((len(lon),len(lat),5))
numbevecdh[:,:,0] =  gfdl_numCDH
numbevecdh[:,:,1] =  ipsl_numCDH
numbevecdh[:,:,2] =  mpi_numCDH
numbevecdh[:,:,3] =  mri_numCDH
numbevecdh[:,:,4] =  ukesm_numCDH
numbevecdhmed = np.median(numbevecdh, axis=2)

frequecdh = np.zeros((len(lon),len(lat),5))
frequecdh[:,:,0] =  gfdl_freCDH
frequecdh[:,:,1] =  ipsl_freCDH
frequecdh[:,:,2] =  mpi_freCDH
frequecdh[:,:,3] =  mri_freCDH
frequecdh[:,:,4] =  ukesm_freCDH
frequecdhmed = np.median(frequecdh, axis=2)

#### Ensemble median cascading
totdurcadh = np.zeros((len(lon),len(lat),5))
totdurcadh[:,:,0] =  gfdl_durCaDH
totdurcadh[:,:,1] =  ipsl_durCaDH
totdurcadh[:,:,2] =  mpi_durCaDH
totdurcadh[:,:,3] =  mri_durCaDH
totdurcadh[:,:,4] =  ukesm_durCaDH
totdurcadhmed = np.median(totdurcadh, axis=2)

avgdurcadh = np.zeros((len(lon),len(lat),5))
avgdurcadh[:,:,0] =  gfdl_avdurCaDH
avgdurcadh[:,:,1] =  ipsl_avdurCaDH
avgdurcadh[:,:,2] =  mpi_avdurCaDH
avgdurcadh[:,:,3] =  mri_avdurCaDH
avgdurcadh[:,:,4] =  ukesm_avdurCaDH
avgdurcadhmed = np.median(avgdurcadh, axis=2)

numbevecadh = np.zeros((len(lon),len(lat),5))
numbevecadh[:,:,0] =  gfdl_numCaDH
numbevecadh[:,:,1] =  ipsl_numCaDH
numbevecadh[:,:,2] =  mpi_numCaDH
numbevecadh[:,:,3] =  mri_numCaDH
numbevecadh[:,:,4] =  ukesm_numCaDH
numbevecadhmed = np.median(numbevecadh, axis=2)

frequecadh = np.zeros((len(lon),len(lat),5))
frequecadh[:,:,0] =  gfdl_freCaDH
frequecadh[:,:,1] =  ipsl_freCaDH
frequecadh[:,:,2] =  mpi_freCaDH
frequecadh[:,:,3] =  mri_freCaDH
frequecadh[:,:,4] =  ukesm_freCaDH
frequecadhmed = np.median(frequecadh, axis=2)


#########################################################
# Open compound data future event
# gfdl
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/Data/Merve/Compound/CnC_summary_gfdl_ssp126.nc','r')  
gfdl1_numCDH = file2read.variables['numCDH'][:]  
gfdl1_durCDH = file2read.variables['durCDH'][:]  
gfdl1_avdurCDH = file2read.variables['avdurCDH'][:]  
gfdl1_freCDH = file2read.variables['freCDH'][:]  

gfdl1_numCaDH = file2read.variables['numCaDH'][:]  
gfdl1_durCaDH = file2read.variables['durCaDH'][:]  
gfdl1_avdurCaDH = file2read.variables['avdurCaDH'][:]  
gfdl1_freCaDH = file2read.variables['freCaDH'][:]  

# ipsl
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/Data/Merve/Compound/CnC_summary_ipsl_ssp126.nc','r')  
ipsl1_numCDH = file2read.variables['numCDH'][:]  
ipsl1_durCDH = file2read.variables['durCDH'][:]  
ipsl1_avdurCDH = file2read.variables['avdurCDH'][:]  
ipsl1_freCDH = file2read.variables['freCDH'][:]  

ipsl1_numCaDH = file2read.variables['numCaDH'][:]  
ipsl1_durCaDH = file2read.variables['durCaDH'][:]  
ipsl1_avdurCaDH = file2read.variables['avdurCaDH'][:]  
ipsl1_freCaDH = file2read.variables['freCaDH'][:]  

# mpi
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/Data/Merve/Compound/CnC_summary_mpi_ssp126.nc','r')  
mpi1_numCDH = file2read.variables['numCDH'][:]  
mpi1_durCDH = file2read.variables['durCDH'][:]  
mpi1_avdurCDH = file2read.variables['avdurCDH'][:]  
mpi1_freCDH = file2read.variables['freCDH'][:]  

mpi1_numCaDH = file2read.variables['numCaDH'][:]  
mpi1_durCaDH = file2read.variables['durCaDH'][:]  
mpi1_avdurCaDH = file2read.variables['avdurCaDH'][:]  
mpi1_freCaDH = file2read.variables['freCaDH'][:]  

# mri
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/Data/Merve/Compound/CnC_summary_mri_ssp126.nc','r')  
mri1_numCDH = file2read.variables['numCDH'][:]  
mri1_durCDH = file2read.variables['durCDH'][:]  
mri1_avdurCDH = file2read.variables['avdurCDH'][:]  
mri1_freCDH = file2read.variables['freCDH'][:]  

mri1_numCaDH = file2read.variables['numCaDH'][:]  
mri1_durCaDH = file2read.variables['durCaDH'][:]  
mri1_avdurCaDH = file2read.variables['avdurCaDH'][:]  
mri1_freCaDH = file2read.variables['freCaDH'][:]  

# ukesm
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/Data/Merve/Compound/CnC_summary_ukesm_ssp126.nc','r')  
ukesm1_numCDH = file2read.variables['numCDH'][:]  
ukesm1_durCDH = file2read.variables['durCDH'][:]  
ukesm1_avdurCDH = file2read.variables['avdurCDH'][:]  
ukesm1_freCDH = file2read.variables['freCDH'][:]  

ukesm1_numCaDH = file2read.variables['numCaDH'][:]  
ukesm1_durCaDH = file2read.variables['durCaDH'][:]  
ukesm1_avdurCaDH = file2read.variables['avdurCaDH'][:]  
ukesm1_freCaDH = file2read.variables['freCaDH'][:]  

#### Ensemble median compound
totdurcdh1 = np.zeros((len(lon),len(lat),5))
totdurcdh1[:,:,0] =  gfdl1_durCDH
totdurcdh1[:,:,1] =  ipsl1_durCDH
totdurcdh1[:,:,2] =  mpi1_durCDH
totdurcdh1[:,:,3] =  mri1_durCDH
totdurcdh1[:,:,4] =  ukesm1_durCDH
totdurcdhmed1 = np.median(totdurcdh1, axis=2)

avgdurcdh1 = np.zeros((len(lon),len(lat),5))
avgdurcdh1[:,:,0] =  gfdl1_avdurCDH
avgdurcdh1[:,:,1] =  ipsl1_avdurCDH
avgdurcdh1[:,:,2] =  mpi1_avdurCDH
avgdurcdh1[:,:,3] =  mri1_avdurCDH
avgdurcdh1[:,:,4] =  ukesm1_avdurCDH
avgdurcdhmed1 = np.median(avgdurcdh1, axis=2)

numbevecdh1 = np.zeros((len(lon),len(lat),5))
numbevecdh1[:,:,0] =  gfdl1_numCDH
numbevecdh1[:,:,1] =  ipsl1_numCDH
numbevecdh1[:,:,2] =  mpi1_numCDH
numbevecdh1[:,:,3] =  mri1_numCDH
numbevecdh1[:,:,4] =  ukesm1_numCDH
numbevecdhmed1 = np.median(numbevecdh1, axis=2)

frequecdh1 = np.zeros((len(lon),len(lat),5))
frequecdh1[:,:,0] =  gfdl1_freCDH
frequecdh1[:,:,1] =  ipsl1_freCDH
frequecdh1[:,:,2] =  mpi1_freCDH
frequecdh1[:,:,3] =  mri1_freCDH
frequecdh1[:,:,4] =  ukesm1_freCDH
frequecdhmed1 = np.median(frequecdh1, axis=2)

#### Ensemble median cascading
totdurcadh1 = np.zeros((len(lon),len(lat),5))
totdurcadh1[:,:,0] =  gfdl1_durCaDH
totdurcadh1[:,:,1] =  ipsl1_durCaDH
totdurcadh1[:,:,2] =  mpi1_durCaDH
totdurcadh1[:,:,3] =  mri1_durCaDH
totdurcadh1[:,:,4] =  ukesm1_durCaDH
totdurcadhmed1 = np.median(totdurcadh1, axis=2)

avgdurcadh1 = np.zeros((len(lon),len(lat),5))
avgdurcadh1[:,:,0] =  gfdl1_avdurCaDH
avgdurcadh1[:,:,1] =  ipsl1_avdurCaDH
avgdurcadh1[:,:,2] =  mpi1_avdurCaDH
avgdurcadh1[:,:,3] =  mri1_avdurCaDH
avgdurcadh1[:,:,4] =  ukesm1_avdurCaDH
avgdurcadhmed1 = np.median(avgdurcadh1, axis=2)

numbevecadh1 = np.zeros((len(lon),len(lat),5))
numbevecadh1[:,:,0] =  gfdl1_numCaDH
numbevecadh1[:,:,1] =  ipsl1_numCaDH
numbevecadh1[:,:,2] =  mpi1_numCaDH
numbevecadh1[:,:,3] =  mri1_numCaDH
numbevecadh1[:,:,4] =  ukesm1_numCaDH
numbevecadhmed1 = np.median(numbevecadh1, axis=2)

frequecadh1 = np.zeros((len(lon),len(lat),5))
frequecadh1[:,:,0] =  gfdl1_freCaDH
frequecadh1[:,:,1] =  ipsl1_freCaDH
frequecadh1[:,:,2] =  mpi1_freCaDH
frequecadh1[:,:,3] =  mri1_freCaDH
frequecadh1[:,:,4] =  ukesm1_freCaDH
frequecadhmed1 = np.median(frequecadh1, axis=2)


#########################################################
# Open compound data future event SSP585
# gfdl
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/Data/Merve/Compound/CnC_summary_gfdl_ssp585.nc','r')  
gfdl2_numCDH = file2read.variables['numCDH'][:]  
gfdl2_durCDH = file2read.variables['durCDH'][:]  
gfdl2_avdurCDH = file2read.variables['avdurCDH'][:]  
gfdl2_freCDH = file2read.variables['freCDH'][:]  

gfdl2_numCaDH = file2read.variables['numCaDH'][:]  
gfdl2_durCaDH = file2read.variables['durCaDH'][:]  
gfdl2_avdurCaDH = file2read.variables['avdurCaDH'][:]  
gfdl2_freCaDH = file2read.variables['freCaDH'][:]  

# ipsl
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/Data/Merve/Compound/CnC_summary_ipsl_ssp585.nc','r')  
ipsl2_numCDH = file2read.variables['numCDH'][:]  
ipsl2_durCDH = file2read.variables['durCDH'][:]  
ipsl2_avdurCDH = file2read.variables['avdurCDH'][:]  
ipsl2_freCDH = file2read.variables['freCDH'][:]  

ipsl2_numCaDH = file2read.variables['numCaDH'][:]  
ipsl2_durCaDH = file2read.variables['durCaDH'][:]  
ipsl2_avdurCaDH = file2read.variables['avdurCaDH'][:]  
ipsl2_freCaDH = file2read.variables['freCaDH'][:]  

# mpi
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/Data/Merve/Compound/CnC_summary_mpi_ssp585.nc','r')  
mpi2_numCDH = file2read.variables['numCDH'][:]  
mpi2_durCDH = file2read.variables['durCDH'][:]  
mpi2_avdurCDH = file2read.variables['avdurCDH'][:]  
mpi2_freCDH = file2read.variables['freCDH'][:]  

mpi2_numCaDH = file2read.variables['numCaDH'][:]  
mpi2_durCaDH = file2read.variables['durCaDH'][:]  
mpi2_avdurCaDH = file2read.variables['avdurCaDH'][:]  
mpi2_freCaDH = file2read.variables['freCaDH'][:]  

# mri
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/Data/Merve/Compound/CnC_summary_mri_ssp585.nc','r')  
mri2_numCDH = file2read.variables['numCDH'][:]  
mri2_durCDH = file2read.variables['durCDH'][:]  
mri2_avdurCDH = file2read.variables['avdurCDH'][:]  
mri2_freCDH = file2read.variables['freCDH'][:]  

mri2_numCaDH = file2read.variables['numCaDH'][:]  
mri2_durCaDH = file2read.variables['durCaDH'][:]  
mri2_avdurCaDH = file2read.variables['avdurCaDH'][:]  
mri2_freCaDH = file2read.variables['freCaDH'][:]  

# ukesm
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/Data/Merve/Compound/CnC_summary_ukesm_ssp585.nc','r')  
ukesm2_numCDH = file2read.variables['numCDH'][:]  
ukesm2_durCDH = file2read.variables['durCDH'][:]  
ukesm2_avdurCDH = file2read.variables['avdurCDH'][:]  
ukesm2_freCDH = file2read.variables['freCDH'][:]  

ukesm2_numCaDH = file2read.variables['numCaDH'][:]  
ukesm2_durCaDH = file2read.variables['durCaDH'][:]  
ukesm2_avdurCaDH = file2read.variables['avdurCaDH'][:]  
ukesm2_freCaDH = file2read.variables['freCaDH'][:]  

#### Ensemble median compound
totdurcdh2 = np.zeros((len(lon),len(lat),5))
totdurcdh2[:,:,0] =  gfdl2_durCDH
totdurcdh2[:,:,1] =  ipsl2_durCDH
totdurcdh2[:,:,2] =  mpi2_durCDH
totdurcdh2[:,:,3] =  mri2_durCDH
totdurcdh2[:,:,4] =  ukesm2_durCDH
totdurcdhmed2 = np.median(totdurcdh2, axis=2)

avgdurcdh2 = np.zeros((len(lon),len(lat),5))
avgdurcdh2[:,:,0] =  gfdl2_avdurCDH
avgdurcdh2[:,:,1] =  ipsl2_avdurCDH
avgdurcdh2[:,:,2] =  mpi2_avdurCDH
avgdurcdh2[:,:,3] =  mri2_avdurCDH
avgdurcdh2[:,:,4] =  ukesm2_avdurCDH
avgdurcdhmed2 = np.median(avgdurcdh2, axis=2)

numbevecdh2 = np.zeros((len(lon),len(lat),5))
numbevecdh2[:,:,0] =  gfdl2_numCDH
numbevecdh2[:,:,1] =  ipsl2_numCDH
numbevecdh2[:,:,2] =  mpi2_numCDH
numbevecdh2[:,:,3] =  mri2_numCDH
numbevecdh2[:,:,4] =  ukesm2_numCDH
numbevecdhmed2 = np.median(numbevecdh2, axis=2)

frequecdh2 = np.zeros((len(lon),len(lat),5))
frequecdh2[:,:,0] =  gfdl2_freCDH
frequecdh2[:,:,1] =  ipsl2_freCDH
frequecdh2[:,:,2] =  mpi2_freCDH
frequecdh2[:,:,3] =  mri2_freCDH
frequecdh2[:,:,4] =  ukesm2_freCDH
frequecdhmed2 = np.median(frequecdh2, axis=2)

#### Ensemble median cascading
totdurcadh2 = np.zeros((len(lon),len(lat),5))
totdurcadh2[:,:,0] =  gfdl2_durCaDH
totdurcadh2[:,:,1] =  ipsl2_durCaDH
totdurcadh2[:,:,2] =  mpi2_durCaDH
totdurcadh2[:,:,3] =  mri2_durCaDH
totdurcadh2[:,:,4] =  ukesm2_durCaDH
totdurcadhmed2 = np.median(totdurcadh2, axis=2)

avgdurcadh2 = np.zeros((len(lon),len(lat),5))
avgdurcadh2[:,:,0] =  gfdl2_avdurCaDH
avgdurcadh2[:,:,1] =  ipsl2_avdurCaDH
avgdurcadh2[:,:,2] =  mpi2_avdurCaDH
avgdurcadh2[:,:,3] =  mri2_avdurCaDH
avgdurcadh2[:,:,4] =  ukesm2_avdurCaDH
avgdurcadhmed2 = np.median(avgdurcadh2, axis=2)

numbevecadh2 = np.zeros((len(lon),len(lat),5))
numbevecadh2[:,:,0] =  gfdl2_numCaDH
numbevecadh2[:,:,1] =  ipsl2_numCaDH
numbevecadh2[:,:,2] =  mpi2_numCaDH
numbevecadh2[:,:,3] =  mri2_numCaDH
numbevecadh2[:,:,4] =  ukesm2_numCaDH
numbevecadhmed2 = np.median(numbevecadh2, axis=2)

frequecadh2 = np.zeros((len(lon),len(lat),5))
frequecadh2[:,:,0] =  gfdl2_freCaDH
frequecadh2[:,:,1] =  ipsl2_freCaDH
frequecadh2[:,:,2] =  mpi2_freCaDH
frequecadh2[:,:,3] =  mri2_freCaDH
frequecadh2[:,:,4] =  ukesm2_freCaDH
frequecadhmed2 = np.median(frequecadh2, axis=2)


#########################################################
# Future changes (ssp126)
Diff_totdurcdh1 = totdurcdhmed1 - totdurcdhmed
Diff_avgdurcdh1 = avgdurcdhmed1 - avgdurcdhmed
Diff_numbevecdh1 = numbevecdhmed1 - numbevecdhmed
Diff_frequecdh1 = frequecdhmed1 - frequecdhmed

Diff_totdurcadh1 = totdurcadhmed1 - totdurcadhmed
Diff_avgdurcadh1 = avgdurcadhmed1 - avgdurcadhmed
Diff_numbevecadh1 = numbevecadhmed1 - numbevecadhmed
Diff_frequecadh1 = frequecadhmed1 - frequecadhmed

# Future changes (ssp585)
Diff_totdurcdh2 = totdurcdhmed2 - totdurcdhmed
Diff_avgdurcdh2 = avgdurcdhmed2 - avgdurcdhmed
Diff_numbevecdh2 = numbevecdhmed2 - numbevecdhmed
Diff_frequecdh2 = frequecdhmed2 - frequecdhmed

Diff_totdurcadh2 = totdurcadhmed2 - totdurcadhmed
Diff_avgdurcadh2 = avgdurcadhmed2 - avgdurcadhmed
Diff_numbevecadh2 = numbevecadhmed2 - numbevecadhmed
Diff_frequecadh2 = frequecadhmed2 - frequecadhmed


#########################################################
#########################################################
# Finding nearest value
def find_nearest(array, value):
    array = np.asarray(array)
    idx = (np.abs(array - value)).argmin()
    return array[idx]

# Northern Europe
# Scandinavian and iceland
lona = -25.17
lata = 72.24

lonb = 29.3
latb = 56.75

loc1a = np.where(lon==find_nearest(lon,lona))
loc2a = np.where(lat==find_nearest(lat,lata))

loc1b = np.where(lon==find_nearest(lon,lonb))
loc2b = np.where(lat==find_nearest(lat,latb))
 
NE1num = np.squeeze(numbevecadhmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
NE1num126 = np.squeeze(numbevecadhmed1[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
NE1num585 = np.squeeze(numbevecadhmed2[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

NE1todur = np.squeeze(totdurcadhmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
NE1todur126 = np.squeeze(totdurcadhmed1[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
NE1todur585 = np.squeeze(totdurcadhmed2[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

NE1avdur = np.squeeze(avgdurcadhmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
NE1avdur126 = np.squeeze(avgdurcadhmed1[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
NE1avdur585 = np.squeeze(avgdurcadhmed2[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

NE1fre = np.squeeze(frequecadhmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
NE1fre126 = np.squeeze(frequecadhmed1[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
NE1fre585 = np.squeeze(frequecadhmed2[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

# England walles
lona = -25.17
lata = 56.75

lonb = 2.25
latb = 51.29

loc1a = np.where(lon==find_nearest(lon,lona))
loc2a = np.where(lat==find_nearest(lat,lata))

loc1b = np.where(lon==find_nearest(lon,lonb))
loc2b = np.where(lat==find_nearest(lat,latb))
 
NE2num = np.squeeze(numbevecadhmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
NE2num126 = np.squeeze(numbevecadhmed1[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
NE2num585 = np.squeeze(numbevecadhmed2[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

NE2todur = np.squeeze(totdurcadhmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
NE2todur126 = np.squeeze(totdurcadhmed1[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
NE2todur585 = np.squeeze(totdurcadhmed2[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

NE2avdur = np.squeeze(avgdurcadhmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
NE2avdur126 = np.squeeze(avgdurcadhmed1[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
NE2avdur585 = np.squeeze(avgdurcadhmed2[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

NE2fre = np.squeeze(frequecadhmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
NE2fre126 = np.squeeze(frequecadhmed1[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
NE2fre585 = np.squeeze(frequecadhmed2[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

NE3num = np.nanmean(NE1num)
NE4num = np.nanmean(NE2num)
NE3num126 = np.nanmean(NE1num126)
NE4num126 = np.nanmean(NE2num126)
NE3num585 = np.nanmean(NE1num585)
NE4num585 = np.nanmean(NE2num585)

NE3todur = np.nanmean(NE1todur)
NE4todur = np.nanmean(NE2todur)
NE3todur126 = np.nanmean(NE1todur126)
NE4todur126 = np.nanmean(NE2todur126)
NE3todur585 = np.nanmean(NE1todur585)
NE4todur585 = np.nanmean(NE2todur585)

NE3avdur = np.nanmean(NE1avdur)
NE4avdur = np.nanmean(NE2avdur)
NE3avdur126 = np.nanmean(NE1avdur126)
NE4avdur126 = np.nanmean(NE2avdur126)
NE3avdur585 = np.nanmean(NE1avdur585)
NE4avdur585 = np.nanmean(NE2avdur585)

NE3fre = np.nanmean(NE1fre)
NE4fre = np.nanmean(NE2fre)
NE3fre126 = np.nanmean(NE1fre126)
NE4fre126 = np.nanmean(NE2fre126)
NE3fre585 = np.nanmean(NE1fre585)
NE4fre585 = np.nanmean(NE2fre585)

NEnum = (NE3num+NE4num)/2
NEnum126 = (NE3num126+NE4num126)/2
NEnum585 = (NE3num585+NE4num585)/2
print('NE Number',NEnum,NEnum126,NEnum585)

NEtodur = (NE3todur+NE4todur)/2
NEtodur126 = (NE3todur126+NE4todur126)/2
NEtodur585 = (NE3todur585+NE4todur585)/2
print('Total duration',NEtodur,NEtodur126,NEtodur585)

NEavdur = (NE3avdur+NE4avdur)/2
NEavdur126 = (NE3avdur126+NE4avdur126)/2
NEavdur585 = (NE3avdur585+NE4avdur585)/2
print('Average duration',NEavdur,NEavdur126,NEavdur585)

NEfre = (NE3fre+NE4fre)/2
NEfre126 = (NE3fre126+NE4fre126)/2
NEfre585 = (NE3fre585+NE4fre585)/2
print('Frequency',NEfre,NEfre126,NEfre585)


#########################################################
# Western Europe
# Benelux to Germany
lona = 2.6
lata = 54.8

lonb = 14.9
latb = 46.6

loc1a = np.where(lon==find_nearest(lon,lona))
loc2a = np.where(lat==find_nearest(lat,lata))

loc1b = np.where(lon==find_nearest(lon,lonb))
loc2b = np.where(lat==find_nearest(lat,latb))
 
WE1num = np.squeeze(numbevecadhmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1num126 = np.squeeze(numbevecadhmed1[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1num585 = np.squeeze(numbevecadhmed2[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE1todur = np.squeeze(totdurcadhmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1todur126 = np.squeeze(totdurcadhmed1[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1todur585 = np.squeeze(totdurcadhmed2[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE1avdur = np.squeeze(avgdurcadhmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1avdur126 = np.squeeze(avgdurcadhmed1[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1avdur585 = np.squeeze(avgdurcadhmed2[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE1fre = np.squeeze(frequecadhmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1fre126 = np.squeeze(frequecadhmed1[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1fre585 = np.squeeze(frequecadhmed2[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

# France
lona = -4.7
lata = 46.6

lonb = 7.6
latb = 42.2

loc1a = np.where(lon==find_nearest(lon,lona))
loc2a = np.where(lat==find_nearest(lat,lata))

loc1b = np.where(lon==find_nearest(lon,lonb))
loc2b = np.where(lat==find_nearest(lat,latb))
 
WE2num = np.squeeze(numbevecadhmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2num126 = np.squeeze(numbevecadhmed1[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2num585 = np.squeeze(numbevecadhmed2[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE2todur = np.squeeze(totdurcadhmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2todur126 = np.squeeze(totdurcadhmed1[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2todur585 = np.squeeze(totdurcadhmed2[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE2avdur = np.squeeze(avgdurcadhmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2avdur126 = np.squeeze(avgdurcadhmed1[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2avdur585 = np.squeeze(avgdurcadhmed2[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE2fre = np.squeeze(frequecadhmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2fre126 = np.squeeze(frequecadhmed1[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2fre585 = np.squeeze(frequecadhmed2[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE3num = np.nanmean(WE1num)
WE4num = np.nanmean(WE2num)
WE3num126 = np.nanmean(WE1num126)
WE4num126 = np.nanmean(WE2num126)
WE3num585 = np.nanmean(WE1num585)
WE4num585 = np.nanmean(WE2num585)

WE3todur = np.nanmean(WE1todur)
WE4todur = np.nanmean(WE2todur)
WE3todur126 = np.nanmean(WE1todur126)
WE4todur126 = np.nanmean(WE2todur126)
WE3todur585 = np.nanmean(WE1todur585)
WE4todur585 = np.nanmean(WE2todur585)

WE3avdur = np.nanmean(WE1avdur)
WE4avdur = np.nanmean(WE2avdur)
WE3avdur126 = np.nanmean(WE1avdur126)
WE4avdur126 = np.nanmean(WE2avdur126)
WE3avdur585 = np.nanmean(WE1avdur585)
WE4avdur585 = np.nanmean(WE2avdur585)

WE3fre = np.nanmean(WE1fre)
WE4fre = np.nanmean(WE2fre)
WE3fre126 = np.nanmean(WE1fre126)
WE4fre126 = np.nanmean(WE2fre126)
WE3fre585 = np.nanmean(WE1fre585)
WE4fre585 = np.nanmean(WE2fre585)

WEnum = (WE3num+WE4num)/2
WEnum126 = (WE3num126+WE4num126)/2
WEnum585 = (WE3num585+WE4num585)/2
print('WE Number',WEnum,WEnum126,WEnum585)

WEtodur = (WE3todur+WE4todur)/2
WEtodur126 = (WE3todur126+WE4todur126)/2
WEtodur585 = (WE3todur585+WE4todur585)/2
print('Total duration',WEtodur,WEtodur126,WEtodur585)

WEavdur = (WE3avdur+WE4avdur)/2
WEavdur126 = (WE3avdur126+WE4avdur126)/2
WEavdur585 = (WE3avdur585+WE4avdur585)/2
print('Average duration',WEavdur,WEavdur126,WEavdur585)

WEfre = (WE3fre+WE4fre)/2
WEfre126 = (WE3fre126+WE4fre126)/2
WEfre585 = (WE3fre585+WE4fre585)/2
print('Frequency',WEfre,WEfre126,WEfre585)


######################################################### I just change the name in the end
# Eastern Europe 
# Poland to Romania
lona = 14.5
lata = 54.6

lonb = 45
latb = 45.9

loc1a = np.where(lon==find_nearest(lon,lona))
loc2a = np.where(lat==find_nearest(lat,lata))

loc1b = np.where(lon==find_nearest(lon,lonb))
loc2b = np.where(lat==find_nearest(lat,latb))
 
WE1num = np.squeeze(numbevecadhmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1num126 = np.squeeze(numbevecadhmed1[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1num585 = np.squeeze(numbevecadhmed2[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE1todur = np.squeeze(totdurcadhmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1todur126 = np.squeeze(totdurcadhmed1[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1todur585 = np.squeeze(totdurcadhmed2[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE1avdur = np.squeeze(avgdurcadhmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1avdur126 = np.squeeze(avgdurcadhmed1[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1avdur585 = np.squeeze(avgdurcadhmed2[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE1fre = np.squeeze(frequecadhmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1fre126 = np.squeeze(frequecadhmed1[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1fre585 = np.squeeze(frequecadhmed2[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

# Bulgaria and russia
lona = 22.9
lata = 45.9

lonb = 45
latb = 41

loc1a = np.where(lon==find_nearest(lon,lona))
loc2a = np.where(lat==find_nearest(lat,lata))

loc1b = np.where(lon==find_nearest(lon,lonb))
loc2b = np.where(lat==find_nearest(lat,latb))
 
WE2num = np.squeeze(numbevecadhmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2num126 = np.squeeze(numbevecadhmed1[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2num585 = np.squeeze(numbevecadhmed2[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE2todur = np.squeeze(totdurcadhmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2todur126 = np.squeeze(totdurcadhmed1[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2todur585 = np.squeeze(totdurcadhmed2[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE2avdur = np.squeeze(avgdurcadhmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2avdur126 = np.squeeze(avgdurcadhmed1[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2avdur585 = np.squeeze(avgdurcadhmed2[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE2fre = np.squeeze(frequecadhmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2fre126 = np.squeeze(frequecadhmed1[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2fre585 = np.squeeze(frequecadhmed2[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

# North russia
lona = 29.8
lata = 69.9

lonb = 45
latb = 54.6

loc1a = np.where(lon==find_nearest(lon,lona))
loc2a = np.where(lat==find_nearest(lat,lata))

loc1b = np.where(lon==find_nearest(lon,lonb))
loc2b = np.where(lat==find_nearest(lat,latb))
 
WE3num = np.squeeze(numbevecadhmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE3num126 = np.squeeze(numbevecadhmed1[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE3num585 = np.squeeze(numbevecadhmed2[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE3todur = np.squeeze(totdurcadhmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE3todur126 = np.squeeze(totdurcadhmed1[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE3todur585 = np.squeeze(totdurcadhmed2[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE3avdur = np.squeeze(avgdurcadhmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE3avdur126 = np.squeeze(avgdurcadhmed1[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE3avdur585 = np.squeeze(avgdurcadhmed2[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE3fre = np.squeeze(frequecadhmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE3fre126 = np.squeeze(frequecadhmed1[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE3fre585 = np.squeeze(frequecadhmed2[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])


WE4num = np.nanmean(WE1num)
WE5num = np.nanmean(WE2num)
WE6num = np.nanmean(WE3num)
WE4num126 = np.nanmean(WE1num126)
WE5num126 = np.nanmean(WE2num126)
WE6num126 = np.nanmean(WE3num126)
WE4num585 = np.nanmean(WE1num585)
WE5num585 = np.nanmean(WE2num585)
WE6num585 = np.nanmean(WE3num585)

WE4todur = np.nanmean(WE1todur)
WE5todur = np.nanmean(WE2todur)
WE6todur = np.nanmean(WE3todur)
WE4todur126 = np.nanmean(WE1todur126)
WE5todur126 = np.nanmean(WE2todur126)
WE6todur126 = np.nanmean(WE3todur126)
WE4todur585 = np.nanmean(WE1todur585)
WE5todur585 = np.nanmean(WE2todur585)
WE6todur585 = np.nanmean(WE3todur585)

WE4avdur = np.nanmean(WE1avdur)
WE5avdur = np.nanmean(WE2avdur)
WE6avdur = np.nanmean(WE3avdur)
WE4avdur126 = np.nanmean(WE1avdur126)
WE5avdur126 = np.nanmean(WE2avdur126)
WE6avdur126 = np.nanmean(WE3avdur126)
WE4avdur585 = np.nanmean(WE1avdur585)
WE5avdur585 = np.nanmean(WE2avdur585)
WE6avdur585 = np.nanmean(WE3avdur585)

WE4fre = np.nanmean(WE1fre)
WE5fre = np.nanmean(WE2fre)
WE6fre = np.nanmean(WE3fre)
WE4fre126 = np.nanmean(WE1fre126)
WE5fre126 = np.nanmean(WE2fre126)
WE6fre126 = np.nanmean(WE3fre126)
WE4fre585 = np.nanmean(WE1fre585)
WE5fre585 = np.nanmean(WE2fre585)
WE6fre585 = np.nanmean(WE3fre585)

EEnum = (WE4num+WE5num+WE6num)/3
EEnum126 = (WE4num126+WE5num126+WE6num126)/3
EEnum585 = (WE4num585+WE5num585+WE6num585)/3
print('EE Number',EEnum,EEnum126,EEnum585)

EEtodur = (WE4todur+WE5todur+WE6todur)/3
EEtodur126 = (WE4todur126+WE5todur126+WE6todur126)/3
EEtodur585 = (WE4todur585+WE5todur585+WE6todur585)/3
print('Total duration',EEtodur,EEtodur126,EEtodur585)

EEavdur = (WE4avdur+WE5avdur+WE6avdur)/3
EEavdur126 = (WE4avdur126+WE5avdur126+WE6avdur126)/3
EEavdur585 = (WE4avdur585+WE5avdur585+WE6avdur585)/3
print('Average duration',EEavdur,EEavdur126,EEavdur585)

EEfre = (WE4fre+WE5fre+WE6fre)/3
EEfre126 = (WE4fre126+WE5fre126+WE6fre126)/3
EEfre585 = (WE4fre585+WE5fre585+WE6fre585)/3
print('Frequency',EEfre,EEfre126,EEfre585)


######################################################### I just change the name in the end
# Southern Europe
# Spain
lona = -10.3
lata = 43.5

lonb = 3.1
latb = 36.3

loc1a = np.where(lon==find_nearest(lon,lona))
loc2a = np.where(lat==find_nearest(lat,lata))

loc1b = np.where(lon==find_nearest(lon,lonb))
loc2b = np.where(lat==find_nearest(lat,latb))
 
WE1num = np.squeeze(numbevecadhmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1num126 = np.squeeze(numbevecadhmed1[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1num585 = np.squeeze(numbevecadhmed2[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE1todur = np.squeeze(totdurcadhmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1todur126 = np.squeeze(totdurcadhmed1[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1todur585 = np.squeeze(totdurcadhmed2[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE1avdur = np.squeeze(avgdurcadhmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1avdur126 = np.squeeze(avgdurcadhmed1[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1avdur585 = np.squeeze(avgdurcadhmed2[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE1fre = np.squeeze(frequecadhmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1fre126 = np.squeeze(frequecadhmed1[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE1fre585 = np.squeeze(frequecadhmed2[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

# Italy balkan
lona = 6.9
lata = 45.9

lonb = 22.4
latb = 36.2

loc1a = np.where(lon==find_nearest(lon,lona))
loc2a = np.where(lat==find_nearest(lat,lata))

loc1b = np.where(lon==find_nearest(lon,lonb))
loc2b = np.where(lat==find_nearest(lat,latb))
 
WE2num = np.squeeze(numbevecadhmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2num126 = np.squeeze(numbevecadhmed1[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2num585 = np.squeeze(numbevecadhmed2[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE2todur = np.squeeze(totdurcadhmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2todur126 = np.squeeze(totdurcadhmed1[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2todur585 = np.squeeze(totdurcadhmed2[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE2avdur = np.squeeze(avgdurcadhmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2avdur126 = np.squeeze(avgdurcadhmed1[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2avdur585 = np.squeeze(avgdurcadhmed2[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE2fre = np.squeeze(frequecadhmed[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2fre126 = np.squeeze(frequecadhmed1[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])
WE2fre585 = np.squeeze(frequecadhmed2[loc1a[0][0]:loc1b[0][0],loc2a[0][0]:loc2b[0][0]])

WE3num = np.nanmean(WE1num)
WE4num = np.nanmean(WE2num)
WE3num126 = np.nanmean(WE1num126)
WE4num126 = np.nanmean(WE2num126)
WE3num585 = np.nanmean(WE1num585)
WE4num585 = np.nanmean(WE2num585)

WE3todur = np.nanmean(WE1todur)
WE4todur = np.nanmean(WE2todur)
WE3todur126 = np.nanmean(WE1todur126)
WE4todur126 = np.nanmean(WE2todur126)
WE3todur585 = np.nanmean(WE1todur585)
WE4todur585 = np.nanmean(WE2todur585)

WE3avdur = np.nanmean(WE1avdur)
WE4avdur = np.nanmean(WE2avdur)
WE3avdur126 = np.nanmean(WE1avdur126)
WE4avdur126 = np.nanmean(WE2avdur126)
WE3avdur585 = np.nanmean(WE1avdur585)
WE4avdur585 = np.nanmean(WE2avdur585)

WE3fre = np.nanmean(WE1fre)
WE4fre = np.nanmean(WE2fre)
WE3fre126 = np.nanmean(WE1fre126)
WE4fre126 = np.nanmean(WE2fre126)
WE3fre585 = np.nanmean(WE1fre585)
WE4fre585 = np.nanmean(WE2fre585)

SEnum = (WE3num+WE4num)/2
SEnum126 = (WE3num126+WE4num126)/2
SEnum585 = (WE3num585+WE4num585)/2
print('SE Number',SEnum,SEnum126,SEnum585)

SEtodur = (WE3todur+WE4todur)/2
SEtodur126 = (WE3todur126+WE4todur126)/2
SEtodur585 = (WE3todur585+WE4todur585)/2
print('Total duration',SEtodur,SEtodur126,SEtodur585)

SEavdur = (WE3avdur+WE4avdur)/2
SEavdur126 = (WE3avdur126+WE4avdur126)/2
SEavdur585 = (WE3avdur585+WE4avdur585)/2
print('Average duration',SEavdur,SEavdur126,SEavdur585)

SEfre = (WE3fre+WE4fre)/2
SEfre126 = (WE3fre126+WE4fre126)/2
SEfre585 = (WE3fre585+WE4fre585)/2
print('Frequency',SEfre,SEfre126,SEfre585)



