#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Wed Nov 22 16:38:10 2023

Plotting drought as single event
Also for all hotspot plots

@author: sutanto
"""

#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Wed Nov 22 14:52:06 2023

Plotting the results for drought and heatwave characteristics

@author: sutanto
"""

import numpy as np
import netCDF4
#from mpl_toolkits.basemap import Basemap
import cartopy.crs as ccrs
import cartopy.feature as cfeature
from matplotlib import pyplot as plt
#from matplotlib import colors
from matplotlib.colors import BoundaryNorm
from matplotlib.ticker import FormatStrFormatter

#########################################################
# Open drought data (past)
# gfdl
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/postdoc_WSG/D3C2_2023/Data/Merve/Drought_char/Sony_droughtchar_past_gfdl-esm4.nc','r')  
lon = file2read.variables['x'][:]
lat = file2read.variables['y'][:]  
pgfdl_number = file2read.variables['numDrought'][:]  
pgfdl_totdur = file2read.variables['todurDrought'][:]  
pgfdl_avedur = file2read.variables['avdurDrought'][:]  
pgfdl_freque = file2read.variables['freDrought'][:]  


# ipsl
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/postdoc_WSG/D3C2_2023/Data/Merve/Drought_char/Sony_droughtchar_past_ipsl-cm6a-lr.nc','r')  
pipsl_number = file2read.variables['numDrought'][:]  
pipsl_totdur = file2read.variables['todurDrought'][:]  
pipsl_avedur = file2read.variables['avdurDrought'][:]  
pipsl_freque = file2read.variables['freDrought'][:]  


# mpi
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/postdoc_WSG/D3C2_2023/Data/Merve/Drought_char/Sony_droughtchar_past_mpi-esm1-2-hr.nc','r')  
pmpi_number = file2read.variables['numDrought'][:]  
pmpi_totdur = file2read.variables['todurDrought'][:]  
pmpi_avedur = file2read.variables['avdurDrought'][:]  
pmpi_freque = file2read.variables['freDrought'][:]  


# mri
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/postdoc_WSG/D3C2_2023/Data/Merve/Drought_char/Sony_droughtchar_past_mri-esm2-0.nc','r')  
pmri_number = file2read.variables['numDrought'][:]  
pmri_totdur = file2read.variables['todurDrought'][:]  
pmri_avedur = file2read.variables['avdurDrought'][:]  
pmri_freque = file2read.variables['freDrought'][:]  


# ukesm
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/postdoc_WSG/D3C2_2023/Data/Merve/Drought_char/Sony_droughtchar_past_ukesm1-0-ll.nc','r')  
pukesm_number = file2read.variables['numDrought'][:]  
pukesm_totdur = file2read.variables['todurDrought'][:]  
pukesm_avedur = file2read.variables['avdurDrought'][:]  
pukesm_freque = file2read.variables['freDrought'][:]  


#### Ensemble median
ptotdur = np.zeros((len(lon),len(lat),5))
ptotdur[:,:,0] =  pgfdl_totdur
ptotdur[:,:,1] =  pipsl_totdur
ptotdur[:,:,2] =  pmpi_totdur
ptotdur[:,:,3] =  pmri_totdur
ptotdur[:,:,4] =  pukesm_totdur
ptotdurmed = np.median(ptotdur, axis=2)

pavgdur = np.zeros((len(lon),len(lat),5))
pavgdur[:,:,0] =  pgfdl_avedur
pavgdur[:,:,1] =  pipsl_avedur
pavgdur[:,:,2] =  pmpi_avedur
pavgdur[:,:,3] =  pmri_avedur
pavgdur[:,:,4] =  pukesm_avedur
pavgdurmed = np.median(pavgdur, axis=2)

pnumbeve = np.zeros((len(lon),len(lat),5))
pnumbeve[:,:,0] =  pgfdl_number
pnumbeve[:,:,1] =  pipsl_number
pnumbeve[:,:,2] =  pmpi_number
pnumbeve[:,:,3] =  pmri_number
pnumbeve[:,:,4] =  pukesm_number
pnumbevemed = np.median(pnumbeve, axis=2)

pfreque = np.zeros((len(lon),len(lat),5))
pfreque[:,:,0] =  pgfdl_freque
pfreque[:,:,1] =  pipsl_freque
pfreque[:,:,2] =  pmpi_freque
pfreque[:,:,3] =  pmri_freque
pfreque[:,:,4] =  pukesm_freque
pfrequemed = np.median(pfreque, axis=2)


#########################################################
# Open drought data (ssp126)
# gfdl
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/postdoc_WSG/D3C2_2023/Data/Merve/Drought_char/Sony_droughtchar_ssp126_gfdl-esm4.nc','r')  
lon = file2read.variables['x'][:]
lat = file2read.variables['y'][:]  
gfdl_number_ssp126 = file2read.variables['numDrought'][:]  
gfdl_totdur_ssp126 = file2read.variables['todurDrought'][:]  
gfdl_avedur_ssp126 = file2read.variables['avdurDrought'][:]  
gfdl_freque_ssp126 = file2read.variables['freDrought'][:]  


# ipsl
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/postdoc_WSG/D3C2_2023/Data/Merve/Drought_char/Sony_droughtchar_ssp126_ipsl-cm6a-lr.nc','r')  
ipsl_number_ssp126 = file2read.variables['numDrought'][:]  
ipsl_totdur_ssp126 = file2read.variables['todurDrought'][:]  
ipsl_avedur_ssp126 = file2read.variables['avdurDrought'][:]  
ipsl_freque_ssp126 = file2read.variables['freDrought'][:]  


# mpi
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/postdoc_WSG/D3C2_2023/Data/Merve/Drought_char/Sony_droughtchar_ssp126_mpi-esm1-2-hr.nc','r')  
mpi_number_ssp126 = file2read.variables['numDrought'][:]  
mpi_totdur_ssp126 = file2read.variables['todurDrought'][:]  
mpi_avedur_ssp126 = file2read.variables['avdurDrought'][:]  
mpi_freque_ssp126 = file2read.variables['freDrought'][:]  


# mri
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/postdoc_WSG/D3C2_2023/Data/Merve/Drought_char/Sony_droughtchar_ssp126_mri-esm2-0.nc','r')  
mri_number_ssp126 = file2read.variables['numDrought'][:]  
mri_totdur_ssp126 = file2read.variables['todurDrought'][:]  
mri_avedur_ssp126 = file2read.variables['avdurDrought'][:]  
mri_freque_ssp126 = file2read.variables['freDrought'][:]  


# ukesm
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/postdoc_WSG/D3C2_2023/Data/Merve/Drought_char/Sony_droughtchar_ssp126_ukesm1-0-ll.nc','r')  
ukesm_number_ssp126 = file2read.variables['numDrought'][:]  
ukesm_totdur_ssp126 = file2read.variables['todurDrought'][:]  
ukesm_avedur_ssp126 = file2read.variables['avdurDrought'][:]  
ukesm_freque_ssp126 = file2read.variables['freDrought'][:]  


#### Ensemble median
f1totdur = np.zeros((len(lon),len(lat),5))
f1totdur[:,:,0] =  gfdl_totdur_ssp126
f1totdur[:,:,1] =  ipsl_totdur_ssp126
f1totdur[:,:,2] =  mpi_totdur_ssp126
f1totdur[:,:,3] =  mri_totdur_ssp126
f1totdur[:,:,4] =  ukesm_totdur_ssp126
f1totdurmed = np.median(f1totdur, axis=2)

f1avgdur = np.zeros((len(lon),len(lat),5))
f1avgdur[:,:,0] =  gfdl_avedur_ssp126
f1avgdur[:,:,1] =  ipsl_avedur_ssp126
f1avgdur[:,:,2] =  mpi_avedur_ssp126
f1avgdur[:,:,3] =  mri_avedur_ssp126
f1avgdur[:,:,4] =  ukesm_avedur_ssp126
f1avgdurmed = np.median(f1avgdur, axis=2)

f1numbeve = np.zeros((len(lon),len(lat),5))
f1numbeve[:,:,0] =  gfdl_number_ssp126
f1numbeve[:,:,1] =  ipsl_number_ssp126
f1numbeve[:,:,2] =  mpi_number_ssp126
f1numbeve[:,:,3] =  mri_number_ssp126
f1numbeve[:,:,4] =  ukesm_number_ssp126
f1numbevemed = np.median(f1numbeve, axis=2)

f1freque = np.zeros((len(lon),len(lat),5))
f1freque[:,:,0] =  gfdl_freque_ssp126
f1freque[:,:,1] =  ipsl_freque_ssp126
f1freque[:,:,2] =  mpi_freque_ssp126
f1freque[:,:,3] =  mri_freque_ssp126
f1freque[:,:,4] =  ukesm_freque_ssp126
f1frequemed = np.median(f1freque, axis=2)


#########################################################
# Open drought data (ssp585)
# gfdl
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/postdoc_WSG/D3C2_2023/Data/Merve/Drought_char/Sony_droughtchar_ssp585_gfdl-esm4.nc','r')  
lon = file2read.variables['x'][:]
lat = file2read.variables['y'][:]  
gfdl_number_ssp585 = file2read.variables['numDrought'][:]  
gfdl_totdur_ssp585 = file2read.variables['todurDrought'][:]  
gfdl_avedur_ssp585 = file2read.variables['avdurDrought'][:]  
gfdl_freque_ssp585 = file2read.variables['freDrought'][:]  


# ipsl
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/postdoc_WSG/D3C2_2023/Data/Merve/Drought_char/Sony_droughtchar_ssp585_ipsl-cm6a-lr.nc','r')  
ipsl_number_ssp585 = file2read.variables['numDrought'][:]  
ipsl_totdur_ssp585 = file2read.variables['todurDrought'][:]  
ipsl_avedur_ssp585 = file2read.variables['avdurDrought'][:]  
ipsl_freque_ssp585 = file2read.variables['freDrought'][:]  


# mpi
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/postdoc_WSG/D3C2_2023/Data/Merve/Drought_char/Sony_droughtchar_ssp585_mpi-esm1-2-hr.nc','r')  
mpi_number_ssp585 = file2read.variables['numDrought'][:]  
mpi_totdur_ssp585= file2read.variables['todurDrought'][:]  
mpi_avedur_ssp585 = file2read.variables['avdurDrought'][:]  
mpi_freque_ssp585 = file2read.variables['freDrought'][:]  


# mri
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/postdoc_WSG/D3C2_2023/Data/Merve/Drought_char/Sony_droughtchar_ssp585_mri-esm2-0.nc','r')  
mri_number_ssp585 = file2read.variables['numDrought'][:]  
mri_totdur_ssp585 = file2read.variables['todurDrought'][:]  
mri_avedur_ssp585 = file2read.variables['avdurDrought'][:]  
mri_freque_ssp585 = file2read.variables['freDrought'][:]  


# ukesm
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/postdoc_WSG/D3C2_2023/Data/Merve/Drought_char/Sony_droughtchar_ssp585_ukesm1-0-ll.nc','r')  
ukesm_number_ssp585 = file2read.variables['numDrought'][:]  
ukesm_totdur_ssp585 = file2read.variables['todurDrought'][:]  
ukesm_avedur_ssp585 = file2read.variables['avdurDrought'][:]  
ukesm_freque_ssp585 = file2read.variables['freDrought'][:]  


#### Ensemble median
f2totdur = np.zeros((len(lon),len(lat),5))
f2totdur[:,:,0] =  gfdl_totdur_ssp585
f2totdur[:,:,1] =  ipsl_totdur_ssp585
f2totdur[:,:,2] =  mpi_totdur_ssp585
f2totdur[:,:,3] =  mri_totdur_ssp585
f2totdur[:,:,4] =  ukesm_totdur_ssp585
f2totdurmed = np.median(f2totdur, axis=2)

f2avgdur = np.zeros((len(lon),len(lat),5))
f2avgdur[:,:,0] =  gfdl_avedur_ssp585
f2avgdur[:,:,1] =  ipsl_avedur_ssp585
f2avgdur[:,:,2] =  mpi_avedur_ssp585
f2avgdur[:,:,3] =  mri_avedur_ssp585
f2avgdur[:,:,4] =  ukesm_avedur_ssp585
f2avgdurmed = np.median(f2avgdur, axis=2)

f2numbeve = np.zeros((len(lon),len(lat),5))
f2numbeve[:,:,0] =  gfdl_number_ssp585
f2numbeve[:,:,1] =  ipsl_number_ssp585
f2numbeve[:,:,2] =  mpi_number_ssp585
f2numbeve[:,:,3] =  mri_number_ssp585
f2numbeve[:,:,4] =  ukesm_number_ssp585
f2numbevemed = np.median(f2numbeve, axis=2)

f2freque = np.zeros((len(lon),len(lat),5))
f2freque[:,:,0] =  gfdl_freque_ssp585
f2freque[:,:,1] =  ipsl_freque_ssp585
f2freque[:,:,2] =  mpi_freque_ssp585
f2freque[:,:,3] =  mri_freque_ssp585
f2freque[:,:,4] =  ukesm_freque_ssp585
f2frequemed = np.median(f2freque, axis=2)


#########################################################
# Future changes (ssp126)
Diff_totdur1 = f1totdurmed - ptotdurmed
Diff_avgdur1 = f1avgdurmed - pavgdurmed
Diff_numbeve1 = f1numbevemed - pnumbevemed
Diff_freque1 = f1frequemed - pfrequemed

# Future changes (ssp585)
Diff_totdur2 = f2totdurmed - ptotdurmed
Diff_avgdur2 = f2avgdurmed - pavgdurmed
Diff_numbeve2 = f2numbevemed - pnumbevemed
Diff_freque2 = f2frequemed - pfrequemed




"""
Plotting
"""

# Plotting basemap
#m = Basemap(resolution='i')
# Because our lon and lat variables are 1D,
late, lone = np.meshgrid(lat, lon)


# Create a figure and a GeoAxes with a PlateCarree projection
fig, ax = plt.subplots(figsize=(10, 6), subplot_kw={'projection': ccrs.PlateCarree()})

# add features (coastlines, borders, etc.)
ax.coastlines(resolution='50m')   # 110m, 50m, 10m
ax.add_feature(cfeature.BORDERS, linestyle=':')
gl = ax.gridlines(draw_labels=True)
gl.top_labels = False
gl.right_labels = False
gl.xlabel_style = {'size': 12}
gl.ylabel_style = {'size': 12}

# Add Grid Ticks (optional custom ticks)
lat_ticks = np.arange(np.amin(lat), np.amax(lat), 10.)
lon_ticks = np.arange(np.amin(lon), np.amax(lon), 10.)

# Define the colormap and boundaries (even intervals)
boundaries = np.linspace(60, 160, num=6)  # Equal intervals from -0.5 to 2
norm = BoundaryNorm(boundaries, ncolors=256)

# Define diverging color normalization
#divnorm = TwoSlopeNorm(vmin=-0.5, vcenter=0., vmax=2)

# Plot the data using pcolormesh
mesh = ax.pcolormesh(lone, late, f2numbevemed,cmap='coolwarm', norm=norm,transform=ccrs.PlateCarree())

# Add a colorbar
cbar = plt.colorbar(mesh, ax=ax, shrink=0.4, pad=0.05)
cbar.set_label("Number of event",size=12)
#cbar.set_ticks(np.linspace(-0.5, 2, num=7))
cbar.set_ticks(boundaries)
cbar.ax.yaxis.set_major_formatter(FormatStrFormatter('%.0f'))  # Format ticks to 1 decimal place

# Show the plot
plt.title('',fontsize= 10) 
plt.tight_layout()

# Limiting the plot
plt.xlim(-23,45)
plt.ylim(35,75)

#plt.savefig('/Users/Sutanto/Documents/postdoc_WSG/D3C2_2023/Data/Results/Changes_Average_Duration_Median_ssp585_Drought.jpg', dpi=300)
plt.savefig('/Users/Sutanto/Documents/postdoc_WSG/D3C2_2023/Data/Results/Number_Median_ssp585_Drought_HS2.jpg', dpi=300)
plt.show()

