#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Wed Nov 22 14:52:06 2023

Plotting compound and cascading DH characteristics
Also for all hotspot plots

@author: sutanto
"""

import numpy as np
import netCDF4
#from mpl_toolkits.basemap import Basemap
import cartopy.crs as ccrs
import cartopy.feature as cfeature
from matplotlib import pyplot as plt
#from matplotlib import colors
from matplotlib.colors import BoundaryNorm
from matplotlib.ticker import FormatStrFormatter

#########################################################
# Open compound data pas event
# gfdl
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/Data/Merve/Compound/CnC_summary_gfdl_past.nc','r')  
lon = file2read.variables['x'][:]
lat = file2read.variables['y'][:]  

gfdl_numCDH = file2read.variables['numCDH'][:]  
gfdl_durCDH = file2read.variables['durCDH'][:]  
gfdl_avdurCDH = file2read.variables['avdurCDH'][:]  
gfdl_freCDH = file2read.variables['freCDH'][:]  

gfdl_numCaDH = file2read.variables['numCaDH'][:]  
gfdl_durCaDH = file2read.variables['durCaDH'][:]  
gfdl_avdurCaDH = file2read.variables['avdurCaDH'][:]  
gfdl_freCaDH = file2read.variables['freCaDH'][:]  

# ipsl
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/Data/Merve/Compound/CnC_summary_ipsl_past.nc','r')  
ipsl_numCDH = file2read.variables['numCDH'][:]  
ipsl_durCDH = file2read.variables['durCDH'][:]  
ipsl_avdurCDH = file2read.variables['avdurCDH'][:]  
ipsl_freCDH = file2read.variables['freCDH'][:]  

ipsl_numCaDH = file2read.variables['numCaDH'][:]  
ipsl_durCaDH = file2read.variables['durCaDH'][:]  
ipsl_avdurCaDH = file2read.variables['avdurCaDH'][:]  
ipsl_freCaDH = file2read.variables['freCaDH'][:]  

# mpi
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/Data/Merve/Compound/CnC_summary_mpi_past.nc','r')  
mpi_numCDH = file2read.variables['numCDH'][:]  
mpi_durCDH = file2read.variables['durCDH'][:]  
mpi_avdurCDH = file2read.variables['avdurCDH'][:]  
mpi_freCDH = file2read.variables['freCDH'][:]  

mpi_numCaDH = file2read.variables['numCaDH'][:]  
mpi_durCaDH = file2read.variables['durCaDH'][:]  
mpi_avdurCaDH = file2read.variables['avdurCaDH'][:]  
mpi_freCaDH = file2read.variables['freCaDH'][:]  

# mri
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/Data/Merve/Compound/CnC_summary_mri_past.nc','r')  
mri_numCDH = file2read.variables['numCDH'][:]  
mri_durCDH = file2read.variables['durCDH'][:]  
mri_avdurCDH = file2read.variables['avdurCDH'][:]  
mri_freCDH = file2read.variables['freCDH'][:]  

mri_numCaDH = file2read.variables['numCaDH'][:]  
mri_durCaDH = file2read.variables['durCaDH'][:]  
mri_avdurCaDH = file2read.variables['avdurCaDH'][:]  
mri_freCaDH = file2read.variables['freCaDH'][:]  

# ukesm
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/Data/Merve/Compound/CnC_summary_ukesm_past.nc','r')  
ukesm_numCDH = file2read.variables['numCDH'][:]  
ukesm_durCDH = file2read.variables['durCDH'][:]  
ukesm_avdurCDH = file2read.variables['avdurCDH'][:]  
ukesm_freCDH = file2read.variables['freCDH'][:]  

ukesm_numCaDH = file2read.variables['numCaDH'][:]  
ukesm_durCaDH = file2read.variables['durCaDH'][:]  
ukesm_avdurCaDH = file2read.variables['avdurCaDH'][:]  
ukesm_freCaDH = file2read.variables['freCaDH'][:]  

#### Ensemble median compound
totdurcdh = np.zeros((len(lon),len(lat),5))
totdurcdh[:,:,0] =  gfdl_durCDH
totdurcdh[:,:,1] =  ipsl_durCDH
totdurcdh[:,:,2] =  mpi_durCDH
totdurcdh[:,:,3] =  mri_durCDH
totdurcdh[:,:,4] =  ukesm_durCDH
totdurcdhmed = np.median(totdurcdh, axis=2)

avgdurcdh = np.zeros((len(lon),len(lat),5))
avgdurcdh[:,:,0] =  gfdl_avdurCDH
avgdurcdh[:,:,1] =  ipsl_avdurCDH
avgdurcdh[:,:,2] =  mpi_avdurCDH
avgdurcdh[:,:,3] =  mri_avdurCDH
avgdurcdh[:,:,4] =  ukesm_avdurCDH
avgdurcdhmed = np.median(avgdurcdh, axis=2)

numbevecdh = np.zeros((len(lon),len(lat),5))
numbevecdh[:,:,0] =  gfdl_numCDH
numbevecdh[:,:,1] =  ipsl_numCDH
numbevecdh[:,:,2] =  mpi_numCDH
numbevecdh[:,:,3] =  mri_numCDH
numbevecdh[:,:,4] =  ukesm_numCDH
numbevecdhmed = np.median(numbevecdh, axis=2)

frequecdh = np.zeros((len(lon),len(lat),5))
frequecdh[:,:,0] =  gfdl_freCDH
frequecdh[:,:,1] =  ipsl_freCDH
frequecdh[:,:,2] =  mpi_freCDH
frequecdh[:,:,3] =  mri_freCDH
frequecdh[:,:,4] =  ukesm_freCDH
frequecdhmed = np.median(frequecdh, axis=2)

#### Ensemble median cascading
totdurcadh = np.zeros((len(lon),len(lat),5))
totdurcadh[:,:,0] =  gfdl_durCaDH
totdurcadh[:,:,1] =  ipsl_durCaDH
totdurcadh[:,:,2] =  mpi_durCaDH
totdurcadh[:,:,3] =  mri_durCaDH
totdurcadh[:,:,4] =  ukesm_durCaDH
totdurcadhmed = np.median(totdurcadh, axis=2)

avgdurcadh = np.zeros((len(lon),len(lat),5))
avgdurcadh[:,:,0] =  gfdl_avdurCaDH
avgdurcadh[:,:,1] =  ipsl_avdurCaDH
avgdurcadh[:,:,2] =  mpi_avdurCaDH
avgdurcadh[:,:,3] =  mri_avdurCaDH
avgdurcadh[:,:,4] =  ukesm_avdurCaDH
avgdurcadhmed = np.median(avgdurcadh, axis=2)

numbevecadh = np.zeros((len(lon),len(lat),5))
numbevecadh[:,:,0] =  gfdl_numCaDH
numbevecadh[:,:,1] =  ipsl_numCaDH
numbevecadh[:,:,2] =  mpi_numCaDH
numbevecadh[:,:,3] =  mri_numCaDH
numbevecadh[:,:,4] =  ukesm_numCaDH
numbevecadhmed = np.median(numbevecadh, axis=2)

frequecadh = np.zeros((len(lon),len(lat),5))
frequecadh[:,:,0] =  gfdl_freCaDH
frequecadh[:,:,1] =  ipsl_freCaDH
frequecadh[:,:,2] =  mpi_freCaDH
frequecadh[:,:,3] =  mri_freCaDH
frequecadh[:,:,4] =  ukesm_freCaDH
frequecadhmed = np.median(frequecadh, axis=2)


#########################################################
# Open compound data future event
# gfdl
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/Data/Merve/Compound/CnC_summary_gfdl_ssp126.nc','r')  
gfdl1_numCDH = file2read.variables['numCDH'][:]  
gfdl1_durCDH = file2read.variables['durCDH'][:]  
gfdl1_avdurCDH = file2read.variables['avdurCDH'][:]  
gfdl1_freCDH = file2read.variables['freCDH'][:]  

gfdl1_numCaDH = file2read.variables['numCaDH'][:]  
gfdl1_durCaDH = file2read.variables['durCaDH'][:]  
gfdl1_avdurCaDH = file2read.variables['avdurCaDH'][:]  
gfdl1_freCaDH = file2read.variables['freCaDH'][:]  

# ipsl
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/Data/Merve/Compound/CnC_summary_ipsl_ssp126.nc','r')  
ipsl1_numCDH = file2read.variables['numCDH'][:]  
ipsl1_durCDH = file2read.variables['durCDH'][:]  
ipsl1_avdurCDH = file2read.variables['avdurCDH'][:]  
ipsl1_freCDH = file2read.variables['freCDH'][:]  

ipsl1_numCaDH = file2read.variables['numCaDH'][:]  
ipsl1_durCaDH = file2read.variables['durCaDH'][:]  
ipsl1_avdurCaDH = file2read.variables['avdurCaDH'][:]  
ipsl1_freCaDH = file2read.variables['freCaDH'][:]  

# mpi
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/Data/Merve/Compound/CnC_summary_mpi_ssp126.nc','r')  
mpi1_numCDH = file2read.variables['numCDH'][:]  
mpi1_durCDH = file2read.variables['durCDH'][:]  
mpi1_avdurCDH = file2read.variables['avdurCDH'][:]  
mpi1_freCDH = file2read.variables['freCDH'][:]  

mpi1_numCaDH = file2read.variables['numCaDH'][:]  
mpi1_durCaDH = file2read.variables['durCaDH'][:]  
mpi1_avdurCaDH = file2read.variables['avdurCaDH'][:]  
mpi1_freCaDH = file2read.variables['freCaDH'][:]  

# mri
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/Data/Merve/Compound/CnC_summary_mri_ssp126.nc','r')  
mri1_numCDH = file2read.variables['numCDH'][:]  
mri1_durCDH = file2read.variables['durCDH'][:]  
mri1_avdurCDH = file2read.variables['avdurCDH'][:]  
mri1_freCDH = file2read.variables['freCDH'][:]  

mri1_numCaDH = file2read.variables['numCaDH'][:]  
mri1_durCaDH = file2read.variables['durCaDH'][:]  
mri1_avdurCaDH = file2read.variables['avdurCaDH'][:]  
mri1_freCaDH = file2read.variables['freCaDH'][:]  

# ukesm
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/Data/Merve/Compound/CnC_summary_ukesm_ssp126.nc','r')  
ukesm1_numCDH = file2read.variables['numCDH'][:]  
ukesm1_durCDH = file2read.variables['durCDH'][:]  
ukesm1_avdurCDH = file2read.variables['avdurCDH'][:]  
ukesm1_freCDH = file2read.variables['freCDH'][:]  

ukesm1_numCaDH = file2read.variables['numCaDH'][:]  
ukesm1_durCaDH = file2read.variables['durCaDH'][:]  
ukesm1_avdurCaDH = file2read.variables['avdurCaDH'][:]  
ukesm1_freCaDH = file2read.variables['freCaDH'][:]  

#### Ensemble median compound
totdurcdh1 = np.zeros((len(lon),len(lat),5))
totdurcdh1[:,:,0] =  gfdl1_durCDH
totdurcdh1[:,:,1] =  ipsl1_durCDH
totdurcdh1[:,:,2] =  mpi1_durCDH
totdurcdh1[:,:,3] =  mri1_durCDH
totdurcdh1[:,:,4] =  ukesm1_durCDH
totdurcdhmed1 = np.median(totdurcdh1, axis=2)

avgdurcdh1 = np.zeros((len(lon),len(lat),5))
avgdurcdh1[:,:,0] =  gfdl1_avdurCDH
avgdurcdh1[:,:,1] =  ipsl1_avdurCDH
avgdurcdh1[:,:,2] =  mpi1_avdurCDH
avgdurcdh1[:,:,3] =  mri1_avdurCDH
avgdurcdh1[:,:,4] =  ukesm1_avdurCDH
avgdurcdhmed1 = np.median(avgdurcdh1, axis=2)

numbevecdh1 = np.zeros((len(lon),len(lat),5))
numbevecdh1[:,:,0] =  gfdl1_numCDH
numbevecdh1[:,:,1] =  ipsl1_numCDH
numbevecdh1[:,:,2] =  mpi1_numCDH
numbevecdh1[:,:,3] =  mri1_numCDH
numbevecdh1[:,:,4] =  ukesm1_numCDH
numbevecdhmed1 = np.median(numbevecdh1, axis=2)

frequecdh1 = np.zeros((len(lon),len(lat),5))
frequecdh1[:,:,0] =  gfdl1_freCDH
frequecdh1[:,:,1] =  ipsl1_freCDH
frequecdh1[:,:,2] =  mpi1_freCDH
frequecdh1[:,:,3] =  mri1_freCDH
frequecdh1[:,:,4] =  ukesm1_freCDH
frequecdhmed1 = np.median(frequecdh1, axis=2)

#### Ensemble median cascading
totdurcadh1 = np.zeros((len(lon),len(lat),5))
totdurcadh1[:,:,0] =  gfdl1_durCaDH
totdurcadh1[:,:,1] =  ipsl1_durCaDH
totdurcadh1[:,:,2] =  mpi1_durCaDH
totdurcadh1[:,:,3] =  mri1_durCaDH
totdurcadh1[:,:,4] =  ukesm1_durCaDH
totdurcadhmed1 = np.median(totdurcadh1, axis=2)

avgdurcadh1 = np.zeros((len(lon),len(lat),5))
avgdurcadh1[:,:,0] =  gfdl1_avdurCaDH
avgdurcadh1[:,:,1] =  ipsl1_avdurCaDH
avgdurcadh1[:,:,2] =  mpi1_avdurCaDH
avgdurcadh1[:,:,3] =  mri1_avdurCaDH
avgdurcadh1[:,:,4] =  ukesm1_avdurCaDH
avgdurcadhmed1 = np.median(avgdurcadh1, axis=2)

numbevecadh1 = np.zeros((len(lon),len(lat),5))
numbevecadh1[:,:,0] =  gfdl1_numCaDH
numbevecadh1[:,:,1] =  ipsl1_numCaDH
numbevecadh1[:,:,2] =  mpi1_numCaDH
numbevecadh1[:,:,3] =  mri1_numCaDH
numbevecadh1[:,:,4] =  ukesm1_numCaDH
numbevecadhmed1 = np.median(numbevecadh1, axis=2)

frequecadh1 = np.zeros((len(lon),len(lat),5))
frequecadh1[:,:,0] =  gfdl1_freCaDH
frequecadh1[:,:,1] =  ipsl1_freCaDH
frequecadh1[:,:,2] =  mpi1_freCaDH
frequecadh1[:,:,3] =  mri1_freCaDH
frequecadh1[:,:,4] =  ukesm1_freCaDH
frequecadhmed1 = np.median(frequecadh1, axis=2)


#########################################################
# Open compound data future event SSP585
# gfdl
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/Data/Merve/Compound/CnC_summary_gfdl_ssp585.nc','r')  
gfdl2_numCDH = file2read.variables['numCDH'][:]  
gfdl2_durCDH = file2read.variables['durCDH'][:]  
gfdl2_avdurCDH = file2read.variables['avdurCDH'][:]  
gfdl2_freCDH = file2read.variables['freCDH'][:]  

gfdl2_numCaDH = file2read.variables['numCaDH'][:]  
gfdl2_durCaDH = file2read.variables['durCaDH'][:]  
gfdl2_avdurCaDH = file2read.variables['avdurCaDH'][:]  
gfdl2_freCaDH = file2read.variables['freCaDH'][:]  

# ipsl
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/Data/Merve/Compound/CnC_summary_ipsl_ssp585.nc','r')  
ipsl2_numCDH = file2read.variables['numCDH'][:]  
ipsl2_durCDH = file2read.variables['durCDH'][:]  
ipsl2_avdurCDH = file2read.variables['avdurCDH'][:]  
ipsl2_freCDH = file2read.variables['freCDH'][:]  

ipsl2_numCaDH = file2read.variables['numCaDH'][:]  
ipsl2_durCaDH = file2read.variables['durCaDH'][:]  
ipsl2_avdurCaDH = file2read.variables['avdurCaDH'][:]  
ipsl2_freCaDH = file2read.variables['freCaDH'][:]  

# mpi
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/Data/Merve/Compound/CnC_summary_mpi_ssp585.nc','r')  
mpi2_numCDH = file2read.variables['numCDH'][:]  
mpi2_durCDH = file2read.variables['durCDH'][:]  
mpi2_avdurCDH = file2read.variables['avdurCDH'][:]  
mpi2_freCDH = file2read.variables['freCDH'][:]  

mpi2_numCaDH = file2read.variables['numCaDH'][:]  
mpi2_durCaDH = file2read.variables['durCaDH'][:]  
mpi2_avdurCaDH = file2read.variables['avdurCaDH'][:]  
mpi2_freCaDH = file2read.variables['freCaDH'][:]  

# mri
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/Data/Merve/Compound/CnC_summary_mri_ssp585.nc','r')  
mri2_numCDH = file2read.variables['numCDH'][:]  
mri2_durCDH = file2read.variables['durCDH'][:]  
mri2_avdurCDH = file2read.variables['avdurCDH'][:]  
mri2_freCDH = file2read.variables['freCDH'][:]  

mri2_numCaDH = file2read.variables['numCaDH'][:]  
mri2_durCaDH = file2read.variables['durCaDH'][:]  
mri2_avdurCaDH = file2read.variables['avdurCaDH'][:]  
mri2_freCaDH = file2read.variables['freCaDH'][:]  

# ukesm
file2read = netCDF4.Dataset('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/Data/Merve/Compound/CnC_summary_ukesm_ssp585.nc','r')  
ukesm2_numCDH = file2read.variables['numCDH'][:]  
ukesm2_durCDH = file2read.variables['durCDH'][:]  
ukesm2_avdurCDH = file2read.variables['avdurCDH'][:]  
ukesm2_freCDH = file2read.variables['freCDH'][:]  

ukesm2_numCaDH = file2read.variables['numCaDH'][:]  
ukesm2_durCaDH = file2read.variables['durCaDH'][:]  
ukesm2_avdurCaDH = file2read.variables['avdurCaDH'][:]  
ukesm2_freCaDH = file2read.variables['freCaDH'][:]  

#### Ensemble median compound
totdurcdh2 = np.zeros((len(lon),len(lat),5))
totdurcdh2[:,:,0] =  gfdl2_durCDH
totdurcdh2[:,:,1] =  ipsl2_durCDH
totdurcdh2[:,:,2] =  mpi2_durCDH
totdurcdh2[:,:,3] =  mri2_durCDH
totdurcdh2[:,:,4] =  ukesm2_durCDH
totdurcdhmed2 = np.median(totdurcdh2, axis=2)

avgdurcdh2 = np.zeros((len(lon),len(lat),5))
avgdurcdh2[:,:,0] =  gfdl2_avdurCDH
avgdurcdh2[:,:,1] =  ipsl2_avdurCDH
avgdurcdh2[:,:,2] =  mpi2_avdurCDH
avgdurcdh2[:,:,3] =  mri2_avdurCDH
avgdurcdh2[:,:,4] =  ukesm2_avdurCDH
avgdurcdhmed2 = np.median(avgdurcdh2, axis=2)

numbevecdh2 = np.zeros((len(lon),len(lat),5))
numbevecdh2[:,:,0] =  gfdl2_numCDH
numbevecdh2[:,:,1] =  ipsl2_numCDH
numbevecdh2[:,:,2] =  mpi2_numCDH
numbevecdh2[:,:,3] =  mri2_numCDH
numbevecdh2[:,:,4] =  ukesm2_numCDH
numbevecdhmed2 = np.median(numbevecdh2, axis=2)

frequecdh2 = np.zeros((len(lon),len(lat),5))
frequecdh2[:,:,0] =  gfdl2_freCDH
frequecdh2[:,:,1] =  ipsl2_freCDH
frequecdh2[:,:,2] =  mpi2_freCDH
frequecdh2[:,:,3] =  mri2_freCDH
frequecdh2[:,:,4] =  ukesm2_freCDH
frequecdhmed2 = np.median(frequecdh2, axis=2)

#### Ensemble median cascading
totdurcadh2 = np.zeros((len(lon),len(lat),5))
totdurcadh2[:,:,0] =  gfdl2_durCaDH
totdurcadh2[:,:,1] =  ipsl2_durCaDH
totdurcadh2[:,:,2] =  mpi2_durCaDH
totdurcadh2[:,:,3] =  mri2_durCaDH
totdurcadh2[:,:,4] =  ukesm2_durCaDH
totdurcadhmed2 = np.median(totdurcadh2, axis=2)

avgdurcadh2 = np.zeros((len(lon),len(lat),5))
avgdurcadh2[:,:,0] =  gfdl2_avdurCaDH
avgdurcadh2[:,:,1] =  ipsl2_avdurCaDH
avgdurcadh2[:,:,2] =  mpi2_avdurCaDH
avgdurcadh2[:,:,3] =  mri2_avdurCaDH
avgdurcadh2[:,:,4] =  ukesm2_avdurCaDH
avgdurcadhmed2 = np.median(avgdurcadh2, axis=2)

numbevecadh2 = np.zeros((len(lon),len(lat),5))
numbevecadh2[:,:,0] =  gfdl2_numCaDH
numbevecadh2[:,:,1] =  ipsl2_numCaDH
numbevecadh2[:,:,2] =  mpi2_numCaDH
numbevecadh2[:,:,3] =  mri2_numCaDH
numbevecadh2[:,:,4] =  ukesm2_numCaDH
numbevecadhmed2 = np.median(numbevecadh2, axis=2)

frequecadh2 = np.zeros((len(lon),len(lat),5))
frequecadh2[:,:,0] =  gfdl2_freCaDH
frequecadh2[:,:,1] =  ipsl2_freCaDH
frequecadh2[:,:,2] =  mpi2_freCaDH
frequecadh2[:,:,3] =  mri2_freCaDH
frequecadh2[:,:,4] =  ukesm2_freCaDH
frequecadhmed2 = np.median(frequecadh2, axis=2)


#########################################################
# Future changes (ssp126)
Diff_totdurcdh1 = totdurcdhmed1 - totdurcdhmed
Diff_avgdurcdh1 = avgdurcdhmed1 - avgdurcdhmed
Diff_numbevecdh1 = numbevecdhmed1 - numbevecdhmed
Diff_frequecdh1 = frequecdhmed1 - frequecdhmed

Diff_totdurcadh1 = totdurcadhmed1 - totdurcadhmed
Diff_avgdurcadh1 = avgdurcadhmed1 - avgdurcadhmed
Diff_numbevecadh1 = numbevecadhmed1 - numbevecadhmed
Diff_frequecadh1 = frequecadhmed1 - frequecadhmed

# Future changes (ssp585)
Diff_totdurcdh2 = totdurcdhmed2 - totdurcdhmed
Diff_avgdurcdh2 = avgdurcdhmed2 - avgdurcdhmed
Diff_numbevecdh2 = numbevecdhmed2 - numbevecdhmed
Diff_frequecdh2 = frequecdhmed2 - frequecdhmed

Diff_totdurcadh2 = totdurcadhmed2 - totdurcadhmed
Diff_avgdurcadh2 = avgdurcadhmed2 - avgdurcadhmed
Diff_numbevecadh2 = numbevecadhmed2 - numbevecadhmed
Diff_frequecadh2 = frequecadhmed2 - frequecadhmed




"""
Plotting
"""

# Because our lon and lat variables are 1D,
late, lone = np.meshgrid(lat, lon)


# Create a figure and a GeoAxes with a PlateCarree projection
fig, ax = plt.subplots(figsize=(10, 6), subplot_kw={'projection': ccrs.PlateCarree()})

# add features (coastlines, borders, etc.)
ax.coastlines(resolution='50m')   # 110m, 50m, 10m
ax.add_feature(cfeature.BORDERS, linestyle=':')
gl = ax.gridlines(draw_labels=True)
gl.top_labels = False
gl.right_labels = False
gl.xlabel_style = {'size': 12}
gl.ylabel_style = {'size': 12}

# Add Grid Ticks (optional custom ticks)
lat_ticks = np.arange(np.amin(lat), np.amax(lat), 10.)
lon_ticks = np.arange(np.amin(lon), np.amax(lon), 10.)

# Define the colormap and boundaries (even intervals)
boundaries = np.linspace(30, 45, num=6)  # Equal intervals from -0.5 to 2
norm = BoundaryNorm(boundaries, ncolors=256)

# Plot the data using pcolormesh
mesh = ax.pcolormesh(lone, late, numbevecadhmed2,cmap='coolwarm', norm=norm,transform=ccrs.PlateCarree())

# Add a colorbar
cbar = plt.colorbar(mesh, ax=ax, shrink=0.4, pad=0.05)
cbar.set_label("Number of event",size=12)
cbar.set_ticks(boundaries)
cbar.ax.yaxis.set_major_formatter(FormatStrFormatter('%.0f'))  # Format ticks to 1 decimal place

# Show the plot
plt.title('',fontsize= 10) 
plt.tight_layout()

# Limiting the plot
plt.xlim(-23,45)
plt.ylim(35,75)

plt.savefig('/Users/Sutanto/Documents/postdoc_WSG/D3C2_2023/Data/Results/Number_Median_ssp585_CaDH_HS2.jpg', dpi=300)
plt.show()
