#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Tue Jan  9 15:49:09 2024

Plotting prediction results

@author: sutanto
"""

import numpy as np
from matplotlib import pyplot as plt # import libraries

#################################################
# Models past=1953-2014
# impact sector
sector = 'Non_Economic'    # Economic, Ecosystem, Non_Economic

result = np.loadtxt('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/ML/Drought/Historical/s_dt_past_from_ERA5_'+sector+'.csv', skiprows=1, 
                    delimiter=',') 

year = result[:,0]
month = result[:,1]
model_impact = result[:,2]

# Removing 1 month impact
model_impact_nzer = np.zeros((len(model_impact)))

pp = np.where(model_impact != 0)
ppdif = np.diff(pp)    
ppdif = np.append([1],ppdif[0,:])  # add number to have the same location after diff application
loc1 = np.where(ppdif != 1) # location in pp
ppp = np.array(pp)   # make array for pp=[1,xx]    
qqq = np.array(loc1)
qqq = np.append([0],qqq[0,:])
count = 0 # to count event

for k in range(len(qqq)-1):   # need to put -1 because we append qqq    
   loc2 = ppp[0,qqq[k]:qqq[k+1]]
   data = model_impact[loc2]   
   if (np.sum(data)>1):
       model_impact_nzer[loc2] = model_impact[loc2]
       count = count+1


number_dr_impact = count    
totdur_dr_impact = np.sum(model_impact_nzer)
avgdur_dr_impact = totdur_dr_impact/number_dr_impact
freq_dr_impact = totdur_dr_impact/62

    
# total impact predicted every year
yearr = np.arange(1953,2015,1)
dr_impact = np.zeros((len(yearr)))

for j in range(len(yearr)):   
    pp = np.where(year==yearr[j])
    ppp = np.sum(model_impact_nzer[pp])
    dr_impact[j] = ppp

# Duration only when impact occurred
xxx = np.where(dr_impact != 0)     
dur_his = dr_impact[xxx]


#################################################
# Models Future=2039-2100
times = 'Future_26'   # Future_26, Future_85
rcp = '26'    # 26, 85

model = 'gfdl'
resultf = np.loadtxt('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/ML/Drought/'+times+'/'+sector+'/s_dt_'+model+'_'+rcp+'.csv', skiprows=1, 
                    delimiter=',') 
fyear = resultf[:,0]
fmonth = resultf[:,1]
fmodel_impact = np.zeros((len(resultf[:,0]),5))
fmodel_impact[:,0] = resultf[:,2]

model = 'ipsl'
resultf = np.loadtxt('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/ML/Drought/'+times+'/'+sector+'/s_dt_'+model+'_'+rcp+'.csv', skiprows=1, 
                    delimiter=',') 
fmodel_impact[:,1] = resultf[:,2]

model = 'mpi'
resultf = np.loadtxt('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/ML/Drought/'+times+'/'+sector+'/s_dt_'+model+'_'+rcp+'.csv', skiprows=1, 
                    delimiter=',') 
fmodel_impact[:,2] = resultf[:,2]

model = 'mri'
resultf = np.loadtxt('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/ML/Drought/'+times+'/'+sector+'/s_dt_'+model+'_'+rcp+'.csv', skiprows=1, 
                    delimiter=',') 
fmodel_impact[:,3] = resultf[:,2]

model = 'ukesm'
resultf = np.loadtxt('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/ML/Drought/'+times+'/'+sector+'/s_dt_'+model+'_'+rcp+'.csv', skiprows=1, 
                    delimiter=',') 
fmodel_impact[:,4] = resultf[:,2]

# Removing 1 month impact
model_impact_nzer_f26 = np.zeros((len(model_impact),5))
number_dr_impact_f26 = np.zeros((5))
totdur_dr_impact_f26 = np.zeros((5))

for i in range(5):
    dummy2 = np.zeros((len(model_impact)))
    dummy = fmodel_impact[:,i]
    pp = np.where(dummy != 0)
    ppdif = np.diff(pp)    
    ppdif = np.append([1],ppdif[0,:])  # add number to have the same location after diff application
    loc1 = np.where(ppdif != 1) # location in pp
    ppp = np.array(pp)   # make array for pp=[1,xx]    
    qqq = np.array(loc1)
    qqq = np.append([0],qqq[0,:])
    count = 0 # to count event

    for k in range(len(qqq)-1):   # need to put -1 because we append qqq    
        loc2 = ppp[0,qqq[k]:qqq[k+1]]
        data = dummy[loc2]   
        if (np.sum(data)>1):
            dummy2[loc2] = dummy[loc2]
            count = count+1
    model_impact_nzer_f26[:,i] = dummy2
    number_dr_impact_f26[i] = count
    totdur_dr_impact_f26[i] = np.sum(dummy2)


mednumber_dr_impact_f26 = np.median(number_dr_impact_f26)
medtotdur_dr_impact_f26 = np.median(totdur_dr_impact_f26)
medavgdur_dr_impact_f26 = medtotdur_dr_impact_f26/mednumber_dr_impact_f26
medfreq_dr_impact_f26 = medtotdur_dr_impact_f26/62


# total impact predicted every year
fyearr = np.arange(2039,2101,1)
fdr_impact = np.zeros((len(yearr),5))

for i in range(5):
    for j in range(len(fyearr)):   
        pp = np.where(fyear==fyearr[j])
        fdr_impact[j,i] = np.sum(model_impact_nzer_f26[pp,i])

fmedian_impact = np.median(fdr_impact, axis=1)

# Duration only when impact occurred
xxx = np.where(fdr_impact != 0)     
dur_his26 = fdr_impact[xxx]


# Models Future=2039-2100
times = 'Future_85'   # Future_26, Future_85
rcp = '85'    # 26, 85

model = 'gfdl'
resultf = np.loadtxt('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/ML/Drought/'+times+'/'+sector+'/s_dt_'+model+'_'+rcp+'.csv', skiprows=1, 
                    delimiter=',') 
fyear = resultf[:,0]
fmonth = resultf[:,1]
fmodel_impact = np.zeros((len(resultf[:,0]),5))
fmodel_impact[:,0] = resultf[:,2]

model = 'ipsl'
resultf = np.loadtxt('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/ML/Drought/'+times+'/'+sector+'/s_dt_'+model+'_'+rcp+'.csv', skiprows=1, 
                    delimiter=',') 
fmodel_impact[:,1] = resultf[:,2]

model = 'mpi'
resultf = np.loadtxt('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/ML/Drought/'+times+'/'+sector+'/s_dt_'+model+'_'+rcp+'.csv', skiprows=1, 
                    delimiter=',') 
fmodel_impact[:,2] = resultf[:,2]

model = 'mri'
resultf = np.loadtxt('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/ML/Drought/'+times+'/'+sector+'/s_dt_'+model+'_'+rcp+'.csv', skiprows=1, 
                    delimiter=',') 
fmodel_impact[:,3] = resultf[:,2]

model = 'ukesm'
resultf = np.loadtxt('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/ML/Drought/'+times+'/'+sector+'/s_dt_'+model+'_'+rcp+'.csv', skiprows=1, 
                    delimiter=',') 
fmodel_impact[:,4] = resultf[:,2]

# Removing 1 month impact
model_impact_nzer_f85 = np.zeros((len(model_impact),5))
number_dr_impact_f85 = np.zeros((5))
totdur_dr_impact_f85 = np.zeros((5))

for i in range(5):
    dummy2 = np.zeros((len(model_impact)))
    dummy = fmodel_impact[:,i]
    pp = np.where(dummy != 0)
    ppdif = np.diff(pp)    
    ppdif = np.append([1],ppdif[0,:])  # add number to have the same location after diff application
    loc1 = np.where(ppdif != 1) # location in pp
    ppp = np.array(pp)   # make array for pp=[1,xx]    
    qqq = np.array(loc1)
    qqq = np.append([0],qqq[0,:])
    count = 0 # to count event

    for k in range(len(qqq)-1):   # need to put -1 because we append qqq    
        loc2 = ppp[0,qqq[k]:qqq[k+1]]
        data = dummy[loc2]   
        if (np.sum(data)>1):
            dummy2[loc2] = dummy[loc2]
            count = count+1
    model_impact_nzer_f85[:,i] = dummy2
    number_dr_impact_f85[i] = count
    totdur_dr_impact_f85[i] = np.sum(dummy2)


mednumber_dr_impact_f85 = np.median(number_dr_impact_f85)
medtotdur_dr_impact_f85 = np.median(totdur_dr_impact_f85)
medavgdur_dr_impact_f85 = medtotdur_dr_impact_f85/mednumber_dr_impact_f85
medfreq_dr_impact_f85 = medtotdur_dr_impact_f85/62


# total impact predicted every year
fyearr = np.arange(2039,2101,1)
fdr_impact85 = np.zeros((len(yearr),5))

for i in range(5):
    for j in range(len(fyearr)):   
        pp = np.where(fyear==fyearr[j])
        fdr_impact85[j,i] = np.sum(model_impact_nzer_f85[pp,i])

fmedian_impact85 = np.median(fdr_impact85, axis=1)

# Duration only when impact occurred
xxx = np.where(fdr_impact85 != 0)     
dur_his85 = fdr_impact85[xxx]

#################################################
# Box plot for past and future events
fdr_impact_bp = np.zeros((100,3))

fdr_impact_bp[:,0] = fdr_impact[0:20,:].flatten()
fdr_impact_bp[:,1] = fdr_impact[20:40,:].flatten()
fdr_impact_bp[:,2] = fdr_impact[40:60,:].flatten()

labels = ['2039-2059','2060-2080','2081-2100']


# Combine past and future
fdr_impact_bp2 = np.full((len(dur_his26),3),np.nan)
fdr_impact_bp2xx = np.full((len(dur_his85),3),np.nan)
#fdr_impact_bp2[:,0] = dr_impact.flatten()
fdr_impact_bp2[:,1] = dur_his26.flatten()
fdr_impact_bp2xx[:,2] = dur_his85.flatten()

fdr_impact_bp2x = np.full((len(dur_his),3),np.nan)

fdr_impact_bp2x[:,0] = dur_his.flatten()


labels2 = ['Reference','SSP1-2.6','SSP5-8.5']


#################################################
# Drought reported impact

resulti = np.loadtxt('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/ML/Drought/Drought_report_impacts.csv', skiprows=1, 
                    delimiter=',') 
yeari = resulti[:,0]
impact1 = resulti[:,2]
impact2 = resulti[:,4]
impact3 = resulti[:,3]

if sector == 'Economic':
    impact = impact1
if sector == 'Ecosystem':
    impact = impact2
if sector == 'Non_Economic':
    impact = impact3    


# total impact predicted every year
iyearr = np.arange(1953,2015,1)
rep_impact = np.zeros((len(iyearr)))


for j in range(len(iyearr)):   
        pp = np.where(yeari==iyearr[j])
        rep_impact[j] = np.sum(impact[pp])
        
    
"""
Plotting
"""

### Plotting historical
fig, ax = plt.subplots(figsize=(10,5))
bar_width = 0.4
opacity = 1

plt.bar(yearr+(-0.5*bar_width), dr_impact, bar_width, alpha=opacity, color='blue', label='ML model')
plt.bar(yearr+(0.5*bar_width), rep_impact, bar_width, alpha=opacity, color='red', label='Impact')

plt.title('Impact prediction for historical drought')
plt.xlabel('Year',fontsize=12)
#plt.xticks(yearr+bar_width, fontsize=12)
plt.yticks(np.arange(0, 12, 2))
#plt.yticks(fontsize=12)
plt.ylabel('Total Impact',fontsize=12)
plt.legend(fontsize=10, loc='upper left')
plt.ylim(0,12)
plt.xlim(1950,2020)

#plt.savefig('/Users/Sutanto/Documents/postdoc_WSG/D3C2_2023/ML/Figure/Drought_Impact_His_'+sector+'.jpg', dpi=300)



### Plotting historical and future
plt.figure(figsize=(7, 5), dpi=300)
plt.subplot(1,1,1)

bp0 = plt.boxplot(fdr_impact_bp2x, labels=labels2,patch_artist=True, boxprops = dict(facecolor = "yellowgreen"),medianprops = dict(color = "darkblue", linewidth = 4))
bp1 = plt.boxplot(fdr_impact_bp2, labels=labels2,patch_artist=True, boxprops = dict(facecolor = "yellow"),medianprops = dict(color = "darkblue", linewidth = 4))
bp2 = plt.boxplot(fdr_impact_bp2xx, labels=labels2,patch_artist=True, boxprops = dict(facecolor = "orangered"),medianprops = dict(color = "darkblue", linewidth = 4))

plt.title('')
plt.xlabel('Scenario')
plt.ylabel('Number of Impact')
plt.ylim(0,12)

#plt.savefig('/Users/Sutanto/Documents/postdoc_WSG/D3C2_2023/ML/Figure/Drought_Impact_combined_'+sector+'.jpg', dpi=300)

plt.show()    
    