#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Wed Nov  8 15:49:00 2023

Organising heatwave characteristics of Merve

@author: sutanto
"""

import numpy as np
import netCDF4


file2read = netCDF4.Dataset('/Users/Sutanto/Documents/postdoc_WSG/D3C2_2023/Data/Models/Historical/cwatm_gfdl-esm4_w5e5_historical_soilmoist_EU_monthly_1850_2014_regridedx.nc','r')  
lonor = file2read.variables['longitude'][:]
lator = file2read.variables['latitude'][:]  

#### get lon and lat
lonor2 = np.around(lonor, decimals=1)
lator2 = np.around(lator, decimals=1)

#### Heatwave characteristics
model = 'ukesm'


#################################################
# Past event
result = np.loadtxt('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/Data/Merve/Heatwave_char/hw_'+model+'.txt', usecols = (0,1,2,3,4,5,6),
                       skiprows=1) #85427568

lon = result[:,0]
lat = result[:,1]
totdur = result[:,2]
totevent = result[:,3]
intens = result[:,4]
avgdur = result[:,5]
frequent = result[:,6]


Hwpast = np.full((len(lonor),len(lator),5),np.nan)

# new script
for i in range(len(lon)):
    lonx = lon[i]
    latx = lat[i]
    loclon = np.where(lonx==lonor2)
    loclat = np.where(latx==lator2)
    Hwpast[loclon[0][0],loclat[0][0],0] = totdur[i]
    Hwpast[loclon[0][0],loclat[0][0],1] = totevent[i]
    Hwpast[loclon[0][0],loclat[0][0],2] = intens[i]
    Hwpast[loclon[0][0],loclat[0][0],3] = avgdur[i]
    Hwpast[loclon[0][0],loclat[0][0],4] = frequent[i]
             

#################################################
# ssp126
result = np.loadtxt('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/Data/Merve/Heatwave_char/hw_'+model+'.txt', usecols = (8,9,10,11,12),
                       skiprows=1) #85427568

totdur126 = result[:,0]
totevent126 = result[:,1]
intens126 = result[:,2]
avgdur126 = result[:,3]
frequent126 = result[:,4]


Hw126 = np.full((len(lonor),len(lator),5),np.nan)

for i in range(len(lon)):
    lonx = lon[i]
    latx = lat[i]
    loclon = np.where(lonx==lonor2)
    loclat = np.where(latx==lator2)
    Hw126[loclon[0][0],loclat[0][0],0] = totdur126[i]
    Hw126[loclon[0][0],loclat[0][0],1] = totevent126[i]
    Hw126[loclon[0][0],loclat[0][0],2] = intens126[i]
    Hw126[loclon[0][0],loclat[0][0],3] = avgdur126[i]
    Hw126[loclon[0][0],loclat[0][0],4] = frequent126[i]
             

#################################################
# ssp585
result = np.loadtxt('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/Data/Merve/Heatwave_char/hw_'+model+'.txt', usecols = (13,14,15,16,17),
                       skiprows=1) #85427568

totdur585 = result[:,0]
totevent585 = result[:,1]
intens585 = result[:,2]
avgdur585 = result[:,3]
frequent585 = result[:,4]


Hw585 = np.full((len(lonor),len(lator),5),np.nan)

for i in range(len(lon)):
    lonx = lon[i]
    latx = lat[i]
    loclon = np.where(lonx==lonor2)
    loclat = np.where(latx==lator2)
    Hw585[loclon[0][0],loclat[0][0],0] = totdur585[i]
    Hw585[loclon[0][0],loclat[0][0],1] = totevent585[i]
    Hw585[loclon[0][0],loclat[0][0],2] = intens585[i]
    Hw585[loclon[0][0],loclat[0][0],3] = avgdur585[i]
    Hw585[loclon[0][0],loclat[0][0],4] = frequent585[i]


#################################################
# Create new netCDF file to save the SPI data
file2write = netCDF4.Dataset('/Users/Sutanto/Documents/Postdoc_WSG/D3C2_2023/Data/Merve/Heatwave_char/hw_'+model+'.nc', 'w', format='NETCDF4')

# Create dimensions for the netCDF file
lon_dim = file2write.createDimension('x', len(lonor))
lat_dim = file2write.createDimension('y', len(lator))
char_dim = file2write.createDimension('char', int(5))


# Create variables for the netCDF file
lon_var = file2write.createVariable('x', 'f4', ('x',))
lat_var = file2write.createVariable('y', 'f4', ('y',))
char_var = file2write.createVariable('char', 'f4', ('char',))

hwpast = file2write.createVariable('hwpast', 'f4', ('x', 'y','char'))
hw126 = file2write.createVariable('hw126', 'f4', ('x', 'y','char'))
hw585 = file2write.createVariable('hw585', 'f4', ('x', 'y','char'))

# Add the data to the variables
lon_var[:] = lonor
lat_var[:] = lator
char_var[:] = np.arange(5)
hwpast[:,:,:] = Hwpast
hw126[:,:,:] = Hw126
hw585[:,:,:] = Hw585


# Add some attributes to the variables
lon_var.units = 'degrees_east'
lat_var.units = 'degrees_north'
char_var.units = 'total duration, total event, intensity, avg duration, frequency'

# Close the netCDF file
file2write.close()
