function [Jr,Rr,Hr,Q2] = mSMOR(J,R,H,B,a,b,N)

n = length(J)/2;
A = (J - R)*H;

% Construction of Krylov matrix

K_n_1 = 0;
K_n_2 = 0;

omega = logspace(a,b,N);    % Frequency points; s=i*omega
for j = 1:1:N
    v = inv(omega(1,j)*eye(2*n)*i - A)*B;         % v = (s*I - A)ˆ(-1)*B
    %v_H = H*inv(omega(1,j)*eye(2*n) - A)*B;    % v_H = H*(s*I - A)ˆ(-1)*B
    v_H = H*v;                                  % v_H = H*(s*I - A)ˆ(-1)*B
    if j == 1
        K_n_1 = v;
        K_n_2 = v_H;
    else
        K_n_1 = [K_n_1 v];      % [(s1*I - A)ˆ(-1)B . . . (sN*I - A)ˆ(-1)B]
        K_n_2 = [K_n_2 v_H];    % [H*(s1*I - A)ˆ(-1)B . . . H*(sN*I - A)ˆ(-1)B]
    end
end


%Spliting the Krylov matrix and contstruct the Extended Krylov Matrix
%Adjusted to include the range of B
K_n = [K_n_1 K_n_2 B];
K_nE = [K_n(1:n,:) K_n(n+1:2*n,:)];

% Constructing the Symplectic Basis
QQ = orth(K_nE);    % Orthogonalization

[row,col] = size(QQ);

if col > N
    Phi_k = QQ(:,1:N);
else
    Phi_k = QQ;
end
 
[row,col] = size(Phi_k);

Q2 = [Phi_k zeros(row,col); zeros(row,col) Phi_k]; % Q_2 = diag(Phi, Phi)
Q1 = Q2;     % Q_1ˆ(*) = Q_2ˆ(-L) = Q_2ˆ(*)

%Note, Q2 is complex valued, and so become Rr and Hr.
%
%Jr = Q2'*J*Q2; %Nonsense, you know it is the Poisson matrix, by
%construction
%
Jr = mPossionMatrix(2*N);
Rr = Q2'*R*Q2; 
Hr = Q1'*H*Q1; 
end