function [Jr,Rr,Hr,Vr,Wr] = mIRKA(J,R,H,B,a,b,N)
%The IRKA-PH algorithm as described in Algorithm 1. 
% see p. 1967 of Gugercin et al (2012)

n = length(J)/2;
A = (J - R)*H;

omega = logspace(a,b,2*N);
for j = 1:1:2*N
    V(:,j) = (1i*omega(1,j)*eye(2*n) - A)\B;
end

W = H*V*pinv(V'*H*V);

Jn = W'*J*W;
Rn = W'*R*W;
Hn = V'*H*V;
%Bn = W'*B;

for d = 1:1:20 %was 12
    An = (Jn - Rn)*Hn;
    
    S = -eig(An)';
    
    for j = 1:1:length(S)
        Vr(:,j) = (S(1,j)*eye(2*n) - A)\B;
    end
    
%     Qr = orth(Qr);
%     Pr = Qr';
    
    Wr = H*Vr*(pinv(Vr'*H*Vr));

    
    Jn = Wr'*J*Wr;
    Rn = Wr'*R*Wr;
    Hn = Vr'*H*Vr;
%    Bn = Wr'*B;
    
end

Jr = Jn;
Rr = Rn;
Hr = Hn;
end
