clear all;
clc;
%% n coupled mass-spring-damper system
n = 200;

%The same as in Gugercin et al 2012
m = 4;      % Mass (was 1)
k = 4;      % Spring_constant (was 1)
c = 1.0;    % Damping_constant (was 0.6)   


J_2n = mPossionMatrix(2*n);     % Generate Possion Structure Matrix
%R as in Gugercin et al 2012. 
R = c*[zeros(n,n) zeros(n,n); zeros(n,n) eye(n)];   
K = zeros(n,n);
K = K + diag(2*ones(1,n))+ diag(-1*ones(1,n-1),-1)+diag(-1*ones(1,n-1),1)- diag([1 zeros(1,n-1)]);
Mass = m*eye(n,n);
%Nicer system, damping between the masses.
%New R
Damp=(c/k)*K; %K and R have the same structure. 
%R = [zeros(n,n) zeros(n,n); zeros(n,n) Damp];
%end New R.
H = [K zeros(n,n); zeros(n,n) inv(Mass)];    % H = [K 0; 0 Mˆ(-1)]

A = (J_2n-R)*H;
B = [zeros(n,1);1;zeros(n-1,1)];
C = [zeros(n,1);1;zeros(n-1,1)]'*H;
D = 0;

Sys_full = ss(A,B,C,D); 

FigNum = 1;

figure(FigNum)
bode(Sys_full)
title('Bode Diagram Full Order System')
FigNum = FigNum + 1;

singHV = hankelsv(Sys_full);
singHV = log(singHV/singHV(1,1));

figure(FigNum)
%plot(linspace(1,2*n,2*n),singHV,'b','LineWidth',3);
%Zoomed in plot 
n_HZ=25;
plot(linspace(1,2*n_HZ,2*n_HZ),singHV(1:2*n_HZ),'b','LineWidth',2)
xlabel('Number','fontSize',16)
ylabel('log(\sigma/\sigma_1)','fontSize',16)
print -depsc PaperFig_SingularValueDecay.eps
FigNum = FigNum +1;


%%
%--------The approximations---------------
%
N = 10; % N = (Reduced_order / 2)
a = -3; b = 1;      % Frequency band to take interpolation data

% One step Symplectic MOR
[Jr0,Rr0,Hr0,Q20] = mSMOR(J_2n,R,H,B,a,b,N); 

Ar0 = (Jr0-Rr0)*Hr0;
Br0 = Q20'*B;
Cr0 = Br0'*Hr0;
Dr0 = 0;

%Test how exact the interpolation is
omega = logspace(a,b,N);
error = zeros(1,N);
for k=1:N 
    error(k)=Cr0*((omega(k)*1i*eye(2*N)-Ar0)\Br0)- C*((omega(k)*1i*eye(2*n)-A)\B);
end
figure(FigNum)
loglog(omega,abs(error),'+')
title('error between full order and SMOR')
FigNum=FigNum+1;

Sys_rSMOR = ss(Ar0,Br0,Cr0,Dr0);

% Symplectic MOR with H2 optimization
[Jr1,Rr1,Hr1,Q21] = mSMORH2(J_2n,R,H,B,a,b,N); 

Ar1 = (Jr1-Rr1)*Hr1;
Br1 = Q21'*B;
Cr1 = Br1'*Hr1;
Dr1 = 0;

%Test how exact the interpolation is
omega = logspace(a,b,N);
for k=1:N 
    error(k)=Cr1*((omega(k)*1i*eye(2*N)-Ar1)\Br1)- C*((omega(k)*1i*eye(2*n)-A)\B);
end
figure(FigNum)
loglog(omega,abs(error),'+')
title('error between full order and SMOR-H2')
FigNum=FigNum+1;

Sys_rSMORH2 = ss(Ar1,Br1,Cr1,Dr1);


% Iterative Symplectic RKA
% [Jr1,Rr1,Hr1,Q2] = mISRKA(J_2n,R,H,B,a,b,N); 
% 
% Ar1 = (Jr1-Rr1)*Hr1;
% Br1 = Q2'*B;
% Cr1 = Br1'*Hr1;
% Dr1 = 0;
% 
% Sys_rIRKSA = ss(Ar1,Br1,Cr1,Dr1);

% IRKA
[Jr2,Rr2,Hr2,Vr2,Wr2] = mIRKA(J_2n,R,H,B,a,b,N);    

Ar2 = (Jr2-Rr2)*Hr2;
Br2 = Wr2'*B;
Cr2 = Br2'*Hr2;
Dr2 = 0;

Sys_rIRKA = ss(Ar2,Br2,Cr2,Dr2);

%% Figures

% figure(FigNum)
% bode(Sys_full,Sys_rIRKSA)
% legend(['Full-order System(' num2str(2*n) ')'],['IRKSA(' num2str(2*N) ')'],'Location','bestoutside','Orientation','Horizontal')
% FigNum = FigNum + 1;

% figure(FigNum)
% nyquist(Sys_full,Sys_rIRKSA)
% legend(['Full-order System(' num2str(2*n) ')'],['IRKSA(' num2str(2*N) ')'],'Location','bestoutside','Orientation','Horizontal')
% FigNum = FigNum + 1;
% 
%  figure(FigNum)
%  nyquist(Sys_full,Sys_rSMOR,Sys_rSMORH2,Sys_rIRKA)
%  legend(['Full-order System(' num2str(2*n) ')'],['OneStep SMOR(' num2str(2*N) ')'],['H2-SMOR(' num2str(2*N) ')'],['IRKA(' num2str(2*N) ')'],'Location','bestoutside','Orientation','Horizontal')
% print -depsc PaperFig_Nyquist_1step_Irka.eps
%  FigNum = FigNum + 1;
% %
% figure(FigNum)
% bode(Sys_full,Sys_rSMOR,Sys_rIRKA,{1e-6,1e3})
% legend(['Full-order System(' num2str(2*n) ')'],['OneStep SMOR(' num2str(2*N) ')'],['IRKA(' num2str(2*N) ')'],'Location','bestoutside','Orientation','Horizontal')
% print -depsc PaperFig_Bode_1step_Irka.eps
% FigNum = FigNum + 1;


%%Correct Bode Plot of IRKA
numbofw=500;
w = logspace(-4,2,numbofw);
%
%initilization
%
G_FULL=zeros(1,numbofw);
G_SMOR=zeros(1,numbofw);
G_SMORH2=zeros(1,numbofw);
G_IRKA=zeros(1,numbofw);
%
for k=1:numbofw
  G_IRKA(k) = Cr2*((w(k)*eye(2*N)*1i-Ar2)\Br2);
  G_SMORH2(k) = Cr1*inv(w(k)*eye(2*N)*1i-Ar1)*Br1;
  G_SMOR(k) = Cr0*inv(w(k)*eye(2*N)*1i-Ar0)*Br0;
  x_klad=(w(k)*eye(2*n)*1i-A)\B;
  G_FULL(k) = C*x_klad;
end
for k=1:N
    x_klad=(omega(k)*eye(2*n)*1i-A)\B;
  G_points(k) = C*x_klad;
  G_points(k) = Cr0*inv(omega(k)*eye(2*N)*1i-Ar0)*Br0;
end

figure(FigNum)

plot(G_FULL,'LineWidth',1.5)

hold

plot(G_SMOR,'LineWidth',1.5)
plot(G_SMORH2,'LineWidth',1.5)
plot(G_IRKA,'LineWidth',1.5),
plot(G_points,'*','LineWidth',3)
legend(['Full-order System(' num2str(2*n) ')'],['SMOR(' num2str(2*N) ')'],['SMOR-H2(' num2str(2*N) ')'],['IRKA(' num2str(2*N) ')'],'Location','bestoutside','Orientation','Horizontal')
print -depsc AllNyquistPlots.eps
hold

FigNum = FigNum + 1;
figure(FigNum)

tiledlayout(2,1)

% Top plot
ax1 = nexttile;
loglog(ax1,w,abs(G_FULL),w,abs(G_SMOR),w,abs(G_SMORH2),w,abs(G_IRKA),'LineWidth',1.5)
title(ax1,'Bode Magitude Plot')
ylabel(ax1,'Magnitude (dB)')
yticklabels([-60,-40,-20,0])
% Bottom plot
ax2 = nexttile;
semilogx(ax2,w,(180/pi)*angle(G_FULL),w,(180/pi)*angle(G_SMOR),w,(180/pi)*angle(G_SMORH2),w,(180/pi)*angle(G_IRKA),'LineWidth',1.5)
title(ax2,'Bode Phase Plot')
ylabel(ax2,'Phase (deg)')
yticklabels([-90,-45,0,45,90])
%legend(['Full-order System(' num2str(2*n) ')'],['SMOR(' num2str(2*N) ')'],['IRKA(' num2str(2*N) ')'],'Location','bestoutside','Orientation','Horizontal')
FigNum = FigNum + 1;
print -depsc AllBodePlots.eps
%End Bode Plot of IRKA


% 
% figure(FigNum)
% bode(Sys_full,Sys_rSMOR,Sys_rIRKA,Sys_rIRKSA)
% legend(['Full-order System(' num2str(2*n) ')'],['OneStep SMOR(' num2str(2*N) ')'],['IRKA(' num2str(2*N) ')'],['IRKSA(' num2str(2*N) ')'],'Location','bestoutside','Orientation','Horizontal')
% print -depsc PaperFig_Bode_1step_Irka_Isrka.eps
% FigNum = FigNum + 1;
% 
% figure(FigNum)
% nyquist(Sys_full,Sys_rSMOR,Sys_rIRKA,Sys_rIRKSA)
% legend(['Full-order System(' num2str(2*n) ')'],['OneStep SMOR(' num2str(2*N) ')'],['IRKA(' num2str(2*N) ')'],['IRKSA(' num2str(2*N) ')'],'Location','bestoutside','Orientation','Horizontal')
% print -depsc PaperFig_Nyquist_1step_Irka_Isrka.eps
% FigNum = FigNum + 1;




%% H_2 and H_inf error

ErrMatrix = zeros(10,7);

for M = 5:14
    [Jr0m,Rr0m,Hr0m,Q20m] = mSMOR(J_2n,R,H,B,a,b,M);

    Ar0m = (Jr0m-Rr0m)*Hr0m;
    Br0m = Q20m'*B;
    Cr0m = Br0m'*Hr0m;
    Dr0m = 0;

    Sys_rSMORm = ss(Ar0m,Br0m,Cr0m,Dr0m);
    %
   [Jr1m,Rr1m,Hr1m,Q21m] = mSMORH2(J_2n,R,H,B,a,b,M);

    Ar1m = (Jr1m-Rr1m)*Hr1m;
    Br1m = Q21m'*B;
    Cr1m = Br1m'*Hr1m;
    Dr1m = 0;

    Sys_rSMORH2m = ss(Ar1m,Br1m,Cr1m,Dr1m);

%     [Jr1m,Rr1m,Hr1m,Q2m] = mISRKA(J_2n,R,H,B,a,b,M);
% 
%     Ar1m = (Jr1m-Rr1m)*Hr1m;
%     Br1m = Q2m'*B;
%     Cr1m = Br1m'*Hr1m;
%     Dr1m = 0;

%   Sys_rIRKSAm = ss(Ar1m,Br1m,Cr1m,Dr1m);

    [Jr2m,Rr2m,Hr2m,Vr2m,Wr2m] = mIRKA(J_2n,R,H,B,a,b,M);

    Ar2m = (Jr2m-Rr2m)*Hr2m;
    Br2m = Wr2m'*B;
    Cr2m = Br2m'*Hr2m;
    Dr2m = 0;

    Sys_rIRKAm = ss(Ar2m,Br2m,Cr2m,Dr2m);
    
    H2_SysNorm = norm(Sys_full,2);
    Hinf_SysNorm = norm(Sys_full,inf);
    
    ErrMatrix(M-4,1) = 2*M;
    ErrMatrix(M-4,2) = norm((Sys_full - Sys_rSMORm),2)/H2_SysNorm; %H2_Err_SMOR
    ErrMatrix(M-4,3)= norm((Sys_full - Sys_rSMORH2m),2)/H2_SysNorm; %H2_Err_SMORH2
    ErrMatrix(M-4,4)= norm((Sys_full - Sys_rIRKAm),2)/H2_SysNorm;   %H2_Err_IRKA
    
    ErrMatrix(M-4,5)= norm((Sys_full - Sys_rSMORm),inf)/Hinf_SysNorm;   %Hinf_Err_SMOR
    ErrMatrix(M-4,6)= norm((Sys_full - Sys_rSMORH2m),inf)/Hinf_SysNorm;  %Hinf_Err_SMORH2
    ErrMatrix(M-4,7)= norm((Sys_full - Sys_rIRKAm),inf)/Hinf_SysNorm;    %Hinf_Err_IRKA
end

figure(FigNum)
plot(ErrMatrix(:,1),ErrMatrix(:,2),'--ob')
hold on
plot(ErrMatrix(:,1),ErrMatrix(:,3),'--*r')
plot(ErrMatrix(:,1),ErrMatrix(:,4),'--dg')
ylabel('Relative H_2 error','fontSize',13)
xlabel('Reduced Order','fontSize',13)
legend(['OneStep SMOR(' num2str(2*N) ')'],['OneStep SMORH2(' num2str(2*N) ')'],['IRKA(' num2str(2*N) ')'],'Location','bestoutside','Orientation','Horizontal')
hold off
print -depsc PaperFig_H2RelativeError.eps
FigNum = FigNum + 1;

figure(FigNum)
plot(ErrMatrix(:,1),ErrMatrix(:,5),'--ob')
hold on
plot(ErrMatrix(:,1),ErrMatrix(:,6),'--*r')
plot(ErrMatrix(:,1),ErrMatrix(:,7),'--dg')
ylabel('Relative H_{\infty} error','fontSize',13)
xlabel('Reduced Order','fontSize',13)
legend(['OneStep SMOR(' num2str(2*N) ')'],['OneStep SMORH2(' num2str(2*N) ')'],['IRKA(' num2str(2*N) ')'],'Location','bestoutside','Orientation','Horizontal')
hold off
print -depsc PaperFig_HinfRelativeError.eps
FigNum = FigNum + 1;

%wite error matrix to file 
fileID = fopen('errorMatrix.txt','w');
fprintf(fileID,'%6s %6s %8s %8s %8s %8s %8s\n','Order','SMOR','SMOR-H2','IRKA-PH','SMOR','SMOR-H2','IRKA-PH');
fprintf(fileID,'%4.0f %8.4f %8.4f %8.4f %8.4f %8.4f %8.4f\n',ErrMatrix');
fclose(fileID);