function [Jr,Rr,Hr,Q_2] = mISRKA(J,R,H,B,a,b,N)

n = length(J)/2;
A = (J - R)*H;

% Construction of Krylov matrix

K_n_1 = 0;
K_n_2 = 0;

omega = logspace(a,b,N);    % Frequency points 
for j = 1:1:N
    v = inv(omega(1,j)*eye(2*n) - A)*B;         % v = (s*I - A)ˆ(-1)*B
    v_H = H*inv(omega(1,j)*eye(2*n) - A)*B;     % v_H = H*(s*I - A)ˆ(-1)*B
    if j == 1
        K_n_1 = v;
        K_n_2 = v_H;
    else
        K_n_1 = [K_n_1 v];      % [(s1*I - A)ˆ(-1)B . . . (sN*I - A)ˆ(-1)B]
        K_n_2 = [K_n_2 v_H];    % [H*(s1*I - A)ˆ(-1)B . . . H*(sN*I - A)ˆ(-1)B]
    end
end


%Spliting the Krylov matrix and contstruct the Extended Krylov Matrix
%K_n = [K_n_1 K_n_2];
%K_nE = [K_n(1:n,:) K_n(n+1:2*n,:)];

K_nE = [K_n_1(1:n,:) K_n_1(n+1:2*n,:) K_n_2(1:n,:) K_n_2(n+1:2*n,:)];

% Constructing the Symplectic Basis
QQ = orth(K_nE);    % Orthogonalization

[row,col] = size(QQ);

if col > N
    Phi_k = QQ(:,1:N);
else
    Phi_k = QQ;
end
 
[row,col] = size(Phi_k);

Q_2 = [Phi_k zeros(row,col); zeros(row,col) Phi_k]; % Q_2 = diag(Phi, Phi)
Q_1 = Q_2;     % Q_1ˆ(*) = Q_2ˆ(-L) = Q_2ˆ(T)


J_r = Q_2'*J*Q_2;
R_r = Q_2'*R*Q_2;
H_r = Q_1'*H*Q_1;


A_r = (J_r - R_r)*H_r;
B_r = Q_2'*B;
C_r = B_r'*H_r;
D_r = 0;

Sys_rSMOR = ss(A_r,B_r,C_r,D_r);


%% Iteration

for d = 1:1:12     % d = number of iteration
    Sys_n = ss(A_r,B_r,C_r,D_r);
    
    S = -eig(Sys_n)';
    
    p = 1;
    for i = 1:1:length(S)
        if abs(imag(S(1,i)) < 1e-10)
            S_new (1,p) = S(1,i);
            p = p + 1;
        end
    end
    
    if length(S_new) > N
        S_new = S_new(1,1:N);
    end
          
    
    for j = 1:1:length(S_new)
        if j == 1
            Kn_1 = inv(S_new(1,j)*eye(2*n) - A)*B;
            Kn_2 = H*inv(S_new(1,j)*eye(2*n) - A)*B;
        else 
            Kn_1  = [Kn_1 inv(S_new(1,j)*eye(2*n) - A)*B];
            Kn_2  = [Kn_2 H*inv(S_new(1,j)*eye(2*n) - A)*B];
        end
    end
    
%     Qr_1E = [Qr_1(1:n,:) Qr_1(n+1:2*n,:)];
%     Qr_2E = [Qr_2(1:n,:) Qr_2(n+1:2*n,:)];
%     
%     Q_rE = [Qr_1E Qr_2E];
    
    
%     Kn = [Kn_1 Kn_2];
%     Kn_E = [Kn(1:n,:) Kn(n+1:2*n,:)];
    
    Kn_E = [Kn_1(1:n,:) Kn_1(n+1:2*n,:) Kn_2(1:n,:) Kn_2(n+1:2*n,:)];
    
%     [QQr,RRr] = m_mgs(Q_rE);
    QQn = orth(Kn_E);
    [row,col] = size(QQn);
    
    if col > N
        Phi_kn = QQn(:,1:N);
    else
        Phi_kn = QQn;
    end
    
    [row,col] = size(Phi_kn);
    
    Qn_2 = [Phi_kn zeros(row,col); zeros(row,col) Phi_kn];
    
    Qn_1 = Qn_2;
    
    
    J_r = Qn_2'*J*Qn_2;
    R_r = Qn_2'*R*Qn_2;
    H_r = Qn_1'*H*Qn_1;


    A_r = (J_r - R_r)*H_r;
    B_r = Qn_2'*B;
    C_r = B_r'*H_r;
    D_r = 0;
        
end

Jr = J_r;
Rr = R_r;
Hr = H_r;
Q_2 = Qn_2;
end