% Author: Costanza Culmone
% Comparison of two cable configurations in 3D printed steerable instruments for Minimally Invasive Surgey

clear all, close all, clc

%% load data

for i=1:12
    sub_curr = ['sub_',num2str(i)];
    load (sub_curr)
end


%% categories 

for j=1:12
    current= eval(['sub_',num2str(j)]);
    mental(j,:)= current(1,:);
    physical(j,:)= current(2,:);
    temporal(j,:)= current(3,:);
    performance(j,:)= current(4,:);
    effort(j,:)= current(5,:);
    frustration(j,:)= current(6,:);
end

% mental
for z= 1:4
    mental_A(:,z)= (mental(1:2:end,z));
    mental_B(:,z)= (mental(2:2:end,z));
    physical_A(:,z)= (physical(1:2:end,z));
    physical_B(:,z)= (physical(2:2:end,z));
    temporal_A(:,z)= (temporal(1:2:end,z));
    temporal_B(:,z)= (temporal(2:2:end,z));
    performance_A(:,z)= (performance(1:2:end,z));
    performance_B(:,z)= (performance(2:2:end,z));
    effort_A(:,z)= (effort(1:2:end,z));
    effort_B(:,z)= (effort(2:2:end,z));
    frustration_A(:,z)= (frustration(1:2:end,z));
    frustration_B(:,z)= (frustration(2:2:end,z));
end

mentalP=[mental_A(:,1) mental_A(:,3); mental_B(:,2) mental_B(:,4)];
mentalM=[mental_A(:,2) mental_A(:,4); mental_B(:,1) mental_B(:,3)];
physicalP=[physical_A(:,1) physical_A(:,3); physical_B(:,2) physical_B(:,4)];
physicalM=[physical_A(:,2) physical_A(:,4); physical_B(:,1) physical_B(:,3)];
temporalP=[temporal_A(:,1) temporal_A(:,3); temporal_B(:,2) temporal_B(:,4)];
temporalM=[temporal_A(:,2) temporal_A(:,4); temporal_B(:,1) temporal_B(:,3)];
performanceP=[performance_A(:,1) performance_A(:,3); performance_B(:,2) performance_B(:,4)];
performanceM=[performance_A(:,2) performance_A(:,4); performance_B(:,1) performance_B(:,3)];
effortP=[effort_A(:,1) effort_A(:,3); effort_B(:,2) effort_B(:,4)];
effortM=[effort_A(:,2) effort_A(:,4); effort_B(:,1) effort_B(:,3)];
frustrationP=[frustration_A(:,1) frustration_A(:,3); frustration_B(:,2) frustration_B(:,4)];
frustrationM=[frustration_A(:,2) frustration_A(:,4); frustration_B(:,1) frustration_B(:,3)];

meanP=mean([mentalP physicalP temporalP performanceP effortP frustrationP]);
meanP=reshape(meanP,2,6);
stdP=std([mentalP physicalP temporalP performanceP effortP frustrationP]);
stdP=reshape(stdP,2,6);

meanM=mean([mentalM physicalM temporalM performanceM effortM frustrationM]);
meanM=reshape(meanM,2,6);
stdM=std([mentalM physicalM temporalM performanceM effortM frustrationM]);
stdM=reshape(stdM,2,6);


overallP=([mentalP; physicalP; temporalP; performanceP; effortP; frustrationP]);
overallM=([mentalM; physicalM; temporalM; performanceM; effortM; frustrationM]);


overallMeanP= mean(overallP);
overallStdP= std(overallP);
overallMeanM= mean(overallM);
overallStdM= std(overallM);

meanMM=[meanM overallMeanM'];
meanPP=[meanP overallMeanP'];
stdMM= [stdM overallStdM'];
stdPP= [stdP overallStdP'];

%% Figure 9 

cate=[1 2 3 4 5 6 8];
cate1=[ 0.85 1.85 2.85 3.85 4.85 5.85 7.85; 1.15 2.15 3.15 4.15 5.15 6.15 8.15]; 

%parallel configuration
figure, 
hb = bar(cate, meanPP)
hb(1).FaceColor = [0 0.4 0.2];
hb(2).FaceColor = [0 0.6 0.2];
set(gca, 'FontSize',12,'XTick',cate,'XTickLabel',{'Mental','Physical','Temporal', 'Performance','Effort','Frustration', 'Overall'});
hold on
e= errorbar(cate1, meanPP, stdPP,'.', 'Color','k', 'MarkerSize',10, 'LineWidth', 1);
legend('Trial 1','Trial 2')
ylabel('Precentage (%)')
ylim([0 100])

%multi-actuation configuration
figure,
hb = bar(cate, meanMM)
hb(1).FaceColor = [0.2 0.4 1];
hb(2).FaceColor = [0.2 0.6 1];
set(gca, 'FontSize',12,'XTick',cate,'XTickLabel',{'Mental','Physical','Temporal', 'Performance','Effort','Frustration', 'Overall'});
hold on
e= errorbar(cate1, meanMM, stdMM,'.', 'Color','k', 'MarkerSize',10, 'LineWidth', 1);
legend('Trial 1','Trial 2')
ylabel('Precentage (%)')
ylim([0 100])


%% Mann Whitney U test (Wilcoxon runk sum): comparison between independent groups: P1A-P1B  and M1B-M1A (first run)
% test for non-parametric data
[pAB1,hAB1,statsAB1] = ranksum(overallP(:,1), overallM(:,1), 'Alpha',0.05)
[pAB2,hAB2,statsAB2] = ranksum(overallP(:,2), overallM(:,2), 'Alpha',0.05) 

%% Wilcoxon signed rank test for paired groups: comparison between P1-P2 and M1-M2
% test for non-parametric data

[p12P,h12P,stats12P] = signrank(overallP(:,1),overallP(:,2), 'Alpha',0.05) 
[p12M,h12M,stats12M] = signrank(overallM(:,1),overallM(:,2), 'Alpha',0.05)

