%{
Created in 2021
@author: Konstantina Kolovou Kouri
%}

%% different pulse amplitudes

Oscidata_ramp = figure('Name','combined plots');

data = csvread('allmA-el8-511Ohm_1.csv');
time = data(:,1);
voltage = data(:,2); 
data1 = csvread('allmA-el8-511Ohm_2.csv');
time1 = data1(:,1);
voltage1 = data1(:,2); 
time_all = vertcat(time,time1) + 0.09;
voltage_all = vertcat(voltage,voltage1);
current_all = voltage_all/511;
a = plot(time*1000,voltage,time1*1000,voltage1,'LineWidth',2.7);
set(a,'Color',[0, 0.4470, 0.7410]);

%% skipped pulse

data_skip = csvread('6mA-el8-skip-511Ohm_1.csv');
time_skip = data_skip(:,1);
voltage_skip = data_skip(:,2); 
data_skip1 = csvread('6mA-el8-skip-511Ohm_2.csv');
time_skip1 = data_skip1(:,1);
voltage_skip1 = data_skip1(:,2);
time_all_skip = vertcat(time_skip,time_skip1);
voltage_all_skip = vertcat(voltage_skip,voltage_skip1);
current_all_skip = voltage_all_skip/511;
b = plot(time_skip*1000,voltage_skip,time_skip1*1000,voltage_skip1,'LineWidth',2.7);
set(b,'Color',[0, 0.4470, 0.7410]);

%% ramped pulse

data_ramp = csvread('6mA-el8-ramp-511Ohm_1.csv');
time_ramp = data_ramp(:,1);
voltage_ramp = data_ramp(:,2);
data_ramp1 = csvread('6mA-el8-ramp-511Ohm_2.csv');
time_ramp1 = data_ramp1(:,1);
voltage_ramp1 = data_ramp1(:,2); 
time_all_ramp = vertcat(time_ramp,time_ramp1) + 1.312;
voltage_all_ramp = vertcat(voltage_ramp,voltage_ramp1);
current_all_ramp = voltage_all_ramp/511;
c = plot(time_ramp1*1000,voltage_ramp1,'LineWidth',2.7);
set(c,'Color',[0, 0.4470, 0.7410]);

all_voltage = [voltage_all voltage_all_skip voltage_all_ramp];
all_current = [current_all current_all_skip current_all_ramp];

ylabels = {'','Current (mA)',''};
s = stackedplot(time_all_ramp,all_current*1000,'DisplayLabels',ylabels);
s.LineWidth = 2.7;
ax = findobj(s.NodeChildren, 'Type','Axes');
set([ax.YLabel],'Rotation',90,'HorizontalAlignment', 'Center', 'VerticalAlignment', 'Bottom')
s.XLabel = 'Time (ms)';

set(gca,'FontName','Times New Roman','FontSize',30);
grid on;
