%{
Created in 2021
@author: Konstantina Kolovou Kouri
%}

%% Measurements at 48Hz, 200us, 6mA & 25mA
% el8 sink, el12 source

Oscidata = figure('Name','biphasic pulse');

data_6mA = csvread('6mA-single-2el.csv');
time_6mA = data_6mA(:,1) + 0.00042;
voltage_6mA = data_6mA(:,2); 

yMedFilt = medfilt1(voltage_6mA,10,'truncate');
plot(time_6mA*1000,yMedFilt,'LineWidth',2.7)
xlim([0 0.8]);

ylabel('Voltage (V)','FontName','Latin Modern Roman');
xlabel('Time (ms)','FontName','Latin Modern Roman');
set(gca,'FontName','Times New Roman','FontSize',30);
grid on;