README
======

Dataset title:  
    **Data accompanying the article "Atmospheric-river-induced foehn events drain glaciers on Novaya Zemlya"**

Files:

- `NovayaZemlya_surface_mass_flux_timeseries.csv`
    Daily time series as spreadsheet of surface mass flux time series
    between 1980 and 2022 from MAR.
- `NovayaZemlya_moisture_transport_timeseries.csv`
    Daily time series as spreadsheet of the average integrated water vapor
    transport from MERRA2 and atmospheric river classification form \[1\]
    between 1980 and 2022.
- `NovayaZemlya_altimetry_mass_change_CryoSat-2_timeseries.csv`
    Monthly time series as spreadsheet of glacier mass changes between 2010
    and 2022 from CryoSat-2 data.
- `NovayaZemlya_altimetry_mass_change_ICESat-1_timeseries.csv`
    Monthly time series as spreadsheet of glacier mass changes between 2004
    and 2009 from ICESat-1 data.
- `NovayaZemlya_gravimetry_mass_change_GRACE_GRACE-FO_timeseries.csv`
    Monthly time series as spreadsheet of glacier mass changes between 2002
    and 2022 from GRACE/GRACE-FO data.
- `NovayaZemlya_GlacierSurfaceElevationChangeRate_2011-2022.nc` (netCDF-4)
    Gridded (500x500 m) average surface elevation change rates and their
    uncertainties between 2011 and 2022.

License: CC-BY-4.0

Contact: <j.m.haacker@tudelft.nl>

Summary
-------

The glacier volume of the High Russian Arctic ice cap on Novaya Zemlya
has been declining since the Little Ice Age. However, in the recent
period, the loss of glacial ice has accelerated. We studied the glacier
mass loss drivers by comparing the output of the regional atmospheric
model MAR with observations from CryoSat-2, GRACE/GRACE-FO, and ICESat,
and reanalysis results from ERA5 and MERRA2. We found that additional
moisture import marjorly drives the mass loss increase; with foehn winds
steering the transported energy to the lee-slope glacier surface. Here,
we publish time series of modeled surface mass fluxes and moisture
transport from reanalysis from 1980 to 2022, glacier mass change time
series from observational data for different periods between 2002 and
2022, and the CryoSat-2 derived glacier surface elevation trends from
2011 to 2022 at a 500-by-500 m resolution. This dataset contributes to
the reproducibility of the results, and can be compared to future
datasets or used for further research.

Method
------

Please refer to the associated article.

Data
----

### `NovayaZemlya_surface_mass_flux_timeseries.csv`

Columns:

- `time`: UTC date
- `SMB`: Surface mass balance in Gt/d
- `ME`: Surface melt water production in Gt/d
- `RF`: Rainfall in Gt/d
- `RU`: Melt water and rain runoff in Gt/d

`SMB`, `ME`, `RF`,  and `RU` are spatially aggregated model output from
the regional atmospheric model MAR v3.14.

### `NovayaZemlya_moisture_transport_timeseries.csv`

Columns:

- `time`: UTC date
- `IVT`: Integrated water vapor transport in kg/m/s
- `AR`: Presence of an atmospheric river as boolean value ("True"/"False")

`IVT` and `AR` are spatially averaged versions of data kindly provided
by Kyle Mattingly (cmp. \[1\]).

### `NovayaZemlya_<method>_mass_change_<sensor>_timeseries.csv`

Glacier mass changes in Gt relative to arbitrary reference observed
using altimetry or gravimetry by CryoSat-2, ICESat-1, or GRACE/GRACE-FO.

### `NovayaZemlya_GlacierSurfaceElevationChangeRate_2011-2022.nc`

NetCDF-4 file of surface elevation change rates from CryoSat-2 swath
data with coordinates `x` and `y`, and variables `trend` and
`trend_95CI`.

Coordinates:

- `x`: "Easting" component in the spatial reference system `EPSG:3413`
    in the unit meter.
- `y`: As `x`, but "Northing" component.

Variables:

- `trend`: Trend component of the fit results in meter per year.
- `trend_uncertainty`: full width of the 95 % confidence interval of the
    trend considering all point data in the grid cell, treating them as
    statistically independent.

No data value: NaN

References
----------

\[1\] K. S. Mattingly et al. "Increasing Extreme Melt in Northeast
    Greenland Linked to Foehn Winds and Atmospheric Rivers". In: Nature
    Communications 14.1 (1 Mar. 29, 2023), p. 1743. issn: 2041-1723.
    doi: 10.1038/s41467-023-37434-8.
