---
author: Lukas Armborst, University of Twente
date: 19 Jan 2021
---


These files allow the verification of a red-black tree implementation using the verifier VerCors.
The files are as follows:
- Node.java:                represents a single node in the red-black tree
- Tree.java:                contains functionality related to valid red-black trees, e.g. proper insert
- NodeList.java:            represents linked list of Node objects
- NodeListIterator.java:    contains functionality to iterate over a NodeList
- ListList.java:            represents a linked list of NodeList objects
- ListListQueue.java:       implements a FIFO queue of Node objects around a ListList. 
                                Allows multi-threading via a producer-consumer pattern
- Merger.java:              implements a parallel algorithm to merge an array of red-black trees using the 
                                ListListQueue as intermediate representation
- Util.java:                implements functionality used by multiple of the files above, e.g. sortedness of sequences

The files were successfully verified using VerCors (pre-release version 1.3.0, see https://github.com/utwente-fmt/vercors/tree/5a1224e ).

