/**
 * Single node in a red-black tree
 * @author Lukas Armborst, University of Twente
 * @year 2021
 */

final class Node {
	/// key according to which nodes are sorted, and in this case also only data stored in the node
    int key;
    
	Node left;
	Node right;
    
    /// true is red, false is black (mnemonic: vowels match)
	boolean color; 
    /// node being double-black (intermediate state during delete operation)
	boolean dblack;
    /// "null" is black, but cannot be double-black. So a dummy node with this flag is used
    boolean dblackNull;

	
    /*@
    /// grouping access permissions to the node's fields for convenience
    public static inline resource node_perm(Node node, frac p) 
        = Perm(node.key, p) 
          ** Perm(node.left, p) ** Perm(node.right, p) 
          ** Perm(node.color, p) ** Perm(node.dblack, p) ** Perm(node.dblackNull, p)
          ** Perm(Integer.MIN_VALUE, read) ** Integer.MIN_VALUE <= node.key;
    @*/
        
    
    /// constructor for a node storing the given value as key. Red by default.
    /*@ 
        requires Perm(Integer.MIN_VALUE, read);
        requires Integer.MIN_VALUE <= item;
        ensures node_perm(this, write);
        ensures key == item 
                ** left == null ** right == null 
                ** color == true ** dblack == false ** dblackNull == false;
    @*/
	Node(int item)
    {
		key = item;
		left = null;
		right = null;
		color = true;
		dblack = false;
        dblackNull = false;
	}
        
}
