function [eqdata]= ...
fig5Dcompsqeq(Kcg1, Kcg2, Kng1, Kng2, Klg2, Kcr, Knr, Klr, Ksti, Casum, Ndsum, Lasum, Tgsum, Trsum, STIsum)

sqe = @(x) [
Casum - x(1) - Kcg1*x(1)*x(4) - Kcg1*Kcg2*x(1)*x(1)*x(4) - 2*Kcg1*Kng2*x(1)*x(2)*x(4) - Kcg1*Klg2*x(1)*x(3)*x(4) - Kcg2*x(1)*x(4) - Kng1*Kcg2*x(1)*x(2)*x(4) - Kcr*x(1)*x(5);
Ndsum - x(2) - Kng1*x(2)*x(4) - 2*Kng1*Kng2*x(2)*x(2)*x(4) - Kng1*Kcg2*x(1)*x(2)*x(4) - Kng1*Klg2*x(2)*x(3)*x(4) - Kng2*x(2)*x(4) - Kcg1*Kng2*x(1)*x(2)*x(4) - Knr*x(2)*x(5);
Lasum - x(3) - Kng1*Klg2*x(2)*x(3)*x(4) - Kcg1*Klg2*x(1)*x(3)*x(4) - Klg2*x(3)*x(4) - Klr*x(3)*x(5);
Tgsum - x(4) - Kcg1*x(1)*x(4) - Kcg2*x(1)*x(4) - Kng1*x(2)*x(4) - Kng2*x(2)*x(4) - Klg2*x(3)*x(4)...
 - Kcg1*Kcg2*x(1)*x(1)*x(4) - Kcg1*Kng2*x(1)*x(2)*x(4) - Kcg1*Klg2*x(1)*x(3)*x(4)...
 - Kng1*Kng2*x(2)*x(2)*x(4) - Kng1*Kcg2*x(1)*x(2)*x(4) - Kng1*Klg2*x(2)*x(3)*x(4);
Trsum - x(5) - Kcr*x(1)*x(5) - Knr*x(2)*x(5) - Klr*x(3)*x(5) - Ksti*x(5)*x(6);
STIsum - x(6) - Ksti*x(5)*x(6)
];

x0 = [Casum Ndsum Lasum Tgsum Trsum STIsum];
opt1 = optimoptions('fsolve', 'Display', 'none');
opt2 = optimoptions('fsolve', 'OptimalityTolerance', 1e-12);
options = opt1;
options.OptimalityTolerance = opt2.OptimalityTolerance;

sol = fsolve(sqe, x0, options); 

Caf = sol(1); Ndf = sol(2); Laf = sol(3); Tgf = sol(4); Trf = sol(5); STIf=sol(6);
CaTg = Kcg1*sol(1)*sol(4); TgCa = Kcg2*sol(1)*sol(4);
CaTgCa = Kcg1*Kcg2*sol(1)*sol(1)*sol(4);
CaTgNd = Kcg1*Kng2*sol(1)*sol(2)*sol(4);
CaTgLa = Kcg1*Klg2*sol(1)*sol(3)*sol(4);
NdTgCa = Kng1*Kcg2*sol(1)*sol(2)*sol(4);
TrCa = Kcr*sol(1)*sol(5);
NdTg = Kng1*sol(2)*sol(4); TgNd = Kng2*sol(2)*sol(4);
NdTgNd = Kng1*Kng2*sol(2)*sol(2)*sol(4);
NdTgLa = Kng1*Klg2*sol(2)*sol(3)*sol(4);
TrNd = Knr*sol(2)*sol(5);
TgLa = Klg2*sol(3)*sol(4);
TrLa = Klr*sol(3)*sol(5);
TrSTI = Ksti*sol(5)*sol(6);

eqdata = [Caf; Ndf; Laf; Trf; Tgf; STIf; CaTg; TgCa; CaTgCa; CaTgNd; CaTgLa;
        NdTgCa; TrCa; NdTg; TgNd; NdTgNd; NdTgLa; TrNd; TgLa; TrLa; TrSTI;
        Casum; Ndsum; Lasum; Tgsum; Trsum; STIsum];
end