function [A, data]=SupplementaryFig12Bcomp(Time,rt,Ca0,Nd0,La0,Tg0,Tr0,STI0,Cain,Ndin,Lain,STIin)
% This function takes initial conditions from the "masterscript.m"
% This function  glues "compsqeq.m" and "compdeq.m"
% that simulate equilibrium binding and kinetic time series respectively

    Kcg1=40; %Tg + Ca = CaTg
    Kcg2=6300; %Tg + Ca = TgCa
    Kng1=8000; %Tg + Nd = NdTg
    Kng2=110000; %Tg + Nd = TgNd
    Klg2=750000; %Tg + La = TgLa
    Kcr=120; %Tr + Ca = TrCa
    Knr=12000; %Tr + Nd = TrNd
    Klr=750; %Tr + La = TrLa
    Ksti=10^9; %Tr + STI = TrSTI
    %L/mol
% These are the equilibrium constants for complexation of species (see S.Table 1)

    kc=20; % _Tg_ + TrCa = _Tg_ + TrCa
    kn=180; % _Tg_ + TrNd = _Tg_ + TrNd
    kl=400; % _Tg_ + TrLa = _Tg_ + TrLa
    %(L/(mol*s))
% These are the kinetic constants for the rate of reactions (see S.Table 1)

    Ca0=Ca0/1000;
    Nd0=Nd0/1000;
    La0=La0/1000;
    Tg0=Tg0/1000;
    Tr0=Tr0/1000;
    STI0=STI0/1000;
    %mol/L
% Here we transform mM into M to meet the metric system convention

    rowsA=Time;
    columnsA=27*length(rt)*length(Nd0);
    A=zeros(rowsA,columnsA);
    data=zeros(rowsA,columnsA/27);
    c=0;

    for j=1:length(rt)
        flowrate=60./(rt(j).*3600);
        Casum=Ca0;
        Ndsum=Nd0;
        Lasum=La0;
        Tgsum=Tg0;
        Trsum=Tr0;
        STIsum=STI0;

        c=c+1;

        for a=1:rowsA
% This cycle allows for sequential computation of concentrations 
% of complexes and their development according to reaction course

        [eqdata]=SupplementaryFig12Bcompsqeq(Kcg1,Kcg2,Kng1,Kng2,Klg2,Kcr,Knr,Klr,Ksti,Casum,Ndsum,Lasum,Tgsum,Trsum,STIsum);
        
        col_range = (j - 1) * length(Nd0) * 27 + (j - 1) * 27 + (1:27);
        A(a, col_range) = eqdata';
        
        Tgpas=eqdata(12)+eqdata(14)+eqdata(16)+eqdata(17);
        Trpas=eqdata(4)+eqdata(21);
        Tgact=Tgsum-Tgpas;
% Here we calculate the distribution of ions between Tr and Tg

        [Casum,Ndsum,Lasum,STIsum,Tgpas,Trpas,Tgact,TrCa,TrNd,TrLa]=...
            SupplementaryFig12Bcompdeq(flowrate,kc,kn,kl,Casum,Ndsum,Lasum,STIsum,Tgpas,Trpas,Tgact,eqdata(13),eqdata(18),eqdata(20),Cain(a),Ndin(a),Lain(a),Tg0,Tr0,STIin(a));

        Tgsum=Tgact+Tgpas;
        Trsum=Trpas+TrCa+TrNd+TrLa;
% Here we simulate reaction for 1 second by a set of ODE's  

        end
        datacolumn = (j - 1) * length(Nd0) * 27 + (j - 1) * 27+26;        
        data(:,c) = A(:,datacolumn);
        
    end
end