clear, clc
% This is a masterscript for phaseplot of logic gates
% It starts the computation from input of several parameters
% It assembles the input for the "comp4C.m" which is a core of the model

rt=6; %min
% Residence time (rt) determines an average time of the reaction in CSTR
% Choose one value

Time_min=60; %min
% Time determines how long does one single step of Nd feed to CSTR take
Time=Time_min*60; %sec

Ndin=0:0.01:1; %mM
% Ndin determines input concentration of Nd in CSTR

Lain=0:0.2:1; %mM
% Ndin determines input concentration of Nd in CSTR

Cain=0:10:50; %mM
% Ndin determines input concentration of Nd in CSTR

Ca0=0; %mM
Nd0=0; %mM
La0=0; %mM
Tg0=0.1; %mM
Tr0=0.001; %mM
STI0=0; %mM
% These are the initial concentrations of species in CSTR
% For everything besided Nd these concetrations are also the feeding concentrations

[A, data, phaseplot]=SupplementaryFig8comp(Time,rt,Ca0,Nd0,La0,Tg0,Tr0,STI0,Ndin,Lain,Cain);
% "compS5.m" performes the simulation
% "A" output contains all the generated time series
% "data" output contains only Tr concentrations
% "phaseplot" output contains only last points of "data" (steady states values)