clear, clc
% This is a masterscript for a flowrate variation
% It starts the computation from input of several parameters
% It assembles the input for the "comp.m" which is a core of the model

rt=2:0.2:12; %min
% rt -- residence time. put a value or a range of values here. 

eventNdL=30; %min
% eventNdL -- time in minutes for a step
% It determines how long does one single step of Nd feed to CSTR take

eventNdC=[0 1 0 1 0]; %mM
% eventNdC -- determines the number of steps 
% and concentration of Nd reactor feed (mM) in steps

eventCaL=150; %min
eventCaC=0; %Cain concentation events, mM

eventLaL=150; %min
eventLaC=0; %Lain concentation events, mM

eventSTIL=150; %min
eventSTIC=0;

Time=eventNdL*length(eventNdC)*60; %sec
% The simulation time is determined by sumarized duration of Nd steps

Ca0=0; %mM
Nd0=0; %mM
La0=0; %mM
Tg0=0.1; %mM
Tr0=0.005; %mM
STI0=0;
% These are the initial concentrations of species in CSTR
% For Tr and Tg these concetrations are also the feeding concentrations
% For the rest (Nd, Ca, La, STI) feeding concentrations are taken 
% from the "eventsbuilder.m"

[Ndin, Cain, Lain, STIin]=SupplementaryFig12Beventsbuilder(eventNdL,eventNdC,eventCaL,eventCaC,eventLaL,eventLaC,eventSTIL,eventSTIC);
% "eventsbuilder.m" helps to create input for "compS9B.m"

[A, data]=SupplementaryFig12Bcomp(Time,rt,Ca0,Nd0,La0,Tg0,Tr0,STI0,Cain,Ndin,Lain,STIin);
% "comp.m" performes the simulation
% "data" output contains all the generated time series
% "A" output contains last data points for different conditions

[Y_values_col1, Y_values_col2]=SupplementaryFig12Baandb(data);
% This function is made for analysis of the derivatives

% Create two separate plots
figure;

% Plot for the first column of differences_matrix (a)
subplot(2, 1, 1);
plot(rt, Y_values_col1, 'o-');
xlabel('Residence time, min');
ylabel('a, sec');
title('a=f(rt)');

% Plot for the second column of differences_matrix (b)
subplot(2, 1, 2);
plot(rt, Y_values_col2, 'o-');
xlabel('Residence time, min');
ylabel('b, M');
title('b=f(rt)');

figure;
plot(data)