function [Y_values_col1, Y_values_col2]=SupplementaryFig12Baandb(data)

% This script is made for analysis of the derivatives

% Calculate derivatives of each column
derivatives = diff(data) ./ diff(1:size(data, 1)).'; % Transpose to get derivatives as columns

% Find the indices where derivatives cross Y=0 for each column
num_columns = size(data, 2);
crossing_points_above = cell(1, num_columns);
crossing_values_above = cell(1, num_columns);
crossing_points_below = cell(1, num_columns);
crossing_values_below = cell(1, num_columns);
crossing_point_differences = cell(1, num_columns);
crossing_value_differences = cell(1, num_columns);

for col_index = 1:num_columns
    derivative_data = derivatives(:, col_index); % Extract the derivative column
    % Find indices where derivative changes sign from negative to positive (crossing from below)
    crossing_indices_above = find(diff(sign(derivative_data)) > 0) + 1;
    %crossing_indices_above = [1;crossing_indices_above];
    % Find indices where derivative changes sign from positive to negative (crossing from above)
    crossing_indices_below = find(diff(sign(derivative_data)) < 0) + 1;
    %crossing_indices_below = [1;crossing_indices_below];

    %Make the sizes of crossing_indices_above and crossing_indices_below equal
    min_size = min(length(crossing_indices_above), length(crossing_indices_below));
    crossing_indices_above = crossing_indices_above(1:min_size);
    crossing_indices_below = crossing_indices_below(1:min_size);
    
    % Get crossing indices and corresponding values for both above and below crossings
    if ~isempty(crossing_indices_above)
        crossing_points_above{col_index} = crossing_indices_above;
        crossing_values_above{col_index} = data(crossing_indices_above, col_index);
    end
    
    if ~isempty(crossing_indices_below)
        crossing_points_below{col_index} = crossing_indices_below;
        crossing_values_below{col_index} = data(crossing_indices_below, col_index);
    end
    %crossing_indices_above = [1; crossing_indices_above];
    %crossing_values_above{col_index} = [1;crossing_values_above{col_index}]
    % Calculate differences between below and above crossings
    if ~isempty(crossing_indices_above) && ~isempty(crossing_indices_below)
        crossing_point_differences{col_index} = crossing_indices_below - crossing_indices_above;
        crossing_value_differences{col_index} = crossing_values_below{col_index} - crossing_values_above{col_index};
    end
end

% Create a table with crossing values, crossing points, and differences for each column
valid_indices_above = ~cellfun(@isempty, crossing_points_above);
valid_indices_below = ~cellfun(@isempty, crossing_points_below);
valid_differences = ~cellfun(@isempty, crossing_point_differences);
crossing_table = table(...
    crossing_points_above(valid_indices_above)', crossing_values_above(valid_indices_above)',...
    crossing_points_below(valid_indices_below)', crossing_values_below(valid_indices_below)',...
    crossing_point_differences(valid_differences)', crossing_value_differences(valid_differences)',...
    'VariableNames', {'CrossingPointsAbove', 'CrossingValuesAbove', 'CrossingPointsBelow', 'CrossingValuesBelow', 'CrossingPointDifferences', 'CrossingValueDifferences'});

% Extract (last - 1) value from 'CrossingPointDifferences' and 'CrossingValueDifferences' rows
num_rows = size(crossing_table, 1);
differences_matrix = zeros(num_rows, 2); % Initialize matrix to store differences

for row = 1:num_rows
    % Extract 'CrossingPointDifferences' and 'CrossingValueDifferences' values for the current row
    cp_diff_row = crossing_table.CrossingPointDifferences{row};
    cv_diff_row = crossing_table.CrossingValueDifferences{row};
    
    % Check if there are at least 2 values in the differences arrays
    if numel(cp_diff_row) >= 2 && numel(cv_diff_row) >= 2
        % Extract (last - 1) value from 'CrossingPointDifferences' and 'CrossingValueDifferences'
        second_last_cp_diff = cp_diff_row(end - 1);
        second_last_cv_diff = cv_diff_row(end - 1);
        
        % Store (last - 1) values in the differences matrix
        differences_matrix(row, 1) = second_last_cp_diff;
        differences_matrix(row, 2) = second_last_cv_diff;
    else
        % If there are fewer than 2 values, set the matrix entry to NaN
        differences_matrix(row, 1) = NaN;
        differences_matrix(row, 2) = NaN;
    end
end

% Display the differences matrix
disp('Last - 1 Values from CrossingPointDifferences and CrossingValueDifferences:');
disp(differences_matrix);

% Extract Y values from differences_matrix
Y_values_col1 = differences_matrix(:, 1);
Y_values_col2 = differences_matrix(:, 2);
