import numpy as np
from scipy.stats import truncnorm
from matplotlib import pyplot as plt


#----------------------- Useful functions -----------------------#
def R_2parallel(R1, R2):
    R_par = R1*R2/(R1+R2)
    return R_par

def R_3parallel(R1, R2, R3):
    R_par = R1*R2*R3/(R1*R2+R2*R3+R1*R3)
    return R_par

def save_as_csv(filename,data):
    np.savetxt(filename,data,delimiter=',',fmt="%f")
#---------------------------------------------------------------#


#---------------------- Parameters setup -----------------------#
# Voltage input.
v = 0.9

# Rp and Rap in Kilo-Ohms.
Rp_mean = 90
Rap_mean = 160
Dummy_mean = 100
Dummy_var_percent=10
Rp_var_percent = 5
Rap_var_percent = 10

# How many times the reference will be computed with different Rap's and Rp's.
# Similar to monte-carlo.
# The higher the better. But the system may get bogged down for 1 million.
no_of_trials = 10000

# How many bins in the histogram to plot each reference, changes look of the plot.
hist_bins=100

# How many bins in the histogram to plot all references on same plot, changes look of the plot.
hist_bins_all=500

# Disable/enable eval for a certain reference by seting it to True or False.
# Note that the plots and csv files containing the references will be overwritten for each run.
eval_in_0 = True
eval_in_1 = True
eval_ref_read = True
eval_in_00 = True
eval_in_01 = True
eval_in_11 = True
eval_ref_or = True
eval_ref_and = True
eval_in_000 = True
eval_in_001 = True
eval_in_011 = True
eval_in_111 = True
eval_ref_maj = True
#---------------------------------------------------------------#


#------------------------ Actual program -----------------------#
Rp_var = (Rp_mean*Rp_var_percent/100)/3
Rap_var = (Rap_mean*Rap_var_percent/100)/3
Dummy_var = (Dummy_mean*Dummy_var_percent/100)/3

mode = "eval"

# mode = "sanity_check"
if mode == "sanity_check":
    # Sanity Check to see of the distribution works correct
    tn1_dummy = truncnorm(-3, 3, loc=Rp_mean, scale=Rp_var)
    theta1_dummy = tn1_dummy.rvs(size=1000000)
    Rp = np.around(theta1_dummy,1)
    tn2_dummy = truncnorm(-3, 3, loc=Rap_mean, scale=Rap_var)
    theta2_dummy = tn2_dummy.rvs(size=1000000)
    Rap = np.around(theta2_dummy,1)

    plt.plot(Rp)
    plt.show()
    plt.plot(Rap)
    plt.show()
    input("Press enter if correct....")

# Rough For in_0
# if eval_VBL_0 == True:
#     VBL_0_array = np.zeros(no_of_trials)
#     for i in range(no_of_trials):
#         tn2 = truncnorm(-3, 3, loc=Rap_mean, scale=Rap_var)
#         theta2 = tn2.rvs(size=1)
#         Rap = np.around(theta2,1)
#
#         Req_0 = Rap[0]
#         in_0 = v/Req_0
#         VBL_0= 0.9 - in_0*t_0
#         VBL_0_array[i] = VBL_0
#
#     plt.hist(VBL_0_array,bins=hist_bins)
#     plt.savefig("VBL_0.png")
#     plt.show()
#     save_as_csv("VBL_0.csv",VBL_0_array)

###################
# For in_0
if eval_in_0 == True:
    in_0_array = np.zeros(no_of_trials)
    for i in range(no_of_trials):
        tn2 = truncnorm(-3, 3, loc=Rap_mean, scale=Rap_var)
        theta2 = tn2.rvs(size=1)
        Rap = np.around(theta2,1)

        Req_0 = Rap[0]
        in_0 = v/Req_0
        in_0_array[i] = in_0

    plt.hist(in_0_array,bins=hist_bins)
#     plt.savefig("in_0.png")
#     plt.show()
#     save_as_csv("in_0.csv",in_0_array)

# For in_1
if eval_in_1 == True:
    in_1_array = np.zeros(no_of_trials)
    for i in range(no_of_trials):
        tn2 = truncnorm(-3, 3, loc=Rp_mean, scale=Rp_var)
        theta2 = tn2.rvs(size=1)
        Rp = np.around(theta2,1)

        Req_1 = Rp[0]
        in_1 = v/Req_1
        in_1_array[i] = in_1

    plt.hist(in_1_array,bins=hist_bins)
#     plt.savefig("in_1.png")
#     plt.show()
#     save_as_csv("in_1.csv",in_1_array)


# For in_00
if eval_in_00 == True:
    in_00_array = np.zeros(no_of_trials)
    for i in range(no_of_trials):
        tn2 = truncnorm(-3, 3, loc=Rap_mean, scale=Rap_var)
        theta2 = tn2.rvs(size=2)
        Rap = np.around(theta2,1)

        Req_00 = R_2parallel(Rap[0], Rap[1])
        in_00 = v/Req_00
        in_00_array[i] = in_00

    plt.hist(in_00_array,bins=hist_bins)
#     plt.savefig("in_00.png")
#     plt.show()
#     save_as_csv("in_00.csv",in_00_array)

# For in_01
if eval_in_01 == True:
    in_01_array = np.zeros(no_of_trials)
    for i in range(no_of_trials):
        tn1 = truncnorm(-3, 3, loc=Rp_mean, scale=Rp_var)
        theta1 = tn1.rvs(size=1)
        Rp = np.around(theta1,1)
        tn2 = truncnorm(-3, 3, loc=Rap_mean, scale=Rap_var)
        theta2 = tn2.rvs(size=1)
        Rap = np.around(theta2,1)

        Req_01 = R_2parallel(Rap, Rp)
        in_01 = v/Req_01
        in_01_array[i] = in_01

    plt.hist(in_01_array,bins=hist_bins)
#     plt.savefig("in_01.png")
#     plt.show()
#     save_as_csv("in_01.csv",in_01_array)

# For in_11
if eval_in_11 == True:
    in_11_array = np.zeros(no_of_trials)
    for i in range(no_of_trials):
        tn1 = truncnorm(-3, 3, loc=Rp_mean, scale=Rp_var)
        theta1 = tn1.rvs(size=2)
        Rp = np.around(theta1,1)

        Req_11 = R_2parallel(Rp[0], Rp[1])
        in_11 = v/Req_11
        in_11_array[i] = in_11

    plt.hist(in_11_array,bins=hist_bins)
#     plt.savefig("in_11.png")
#     plt.show()
#     save_as_csv("in_11.csv",in_11_array)

# For in_000
if eval_in_000 == True:
    in_000_array = np.zeros(no_of_trials)
    for i in range(no_of_trials):
        tn2 = truncnorm(-3, 3, loc=Rap_mean, scale=Rap_var)
        theta2 = tn2.rvs(size=3)
        Rap = np.around(theta2,1)

        Req_000 = R_3parallel(Rap[0], Rap[1], Rap[2])
        in_000 = v/Req_000
        in_000_array[i] = in_000

    plt.hist(in_000_array,bins=hist_bins)
#     plt.savefig("in_000.png")
#     plt.show()
#     save_as_csv("in_000.csv",in_000_array)

# For in_001
if eval_in_001 == True:
    in_001_array = np.zeros(no_of_trials)
    for i in range(no_of_trials):
        tn1 = truncnorm(-3, 3, loc=Rp_mean, scale=Rp_var)
        theta1 = tn1.rvs(size=1)
        Rp = np.around(theta1,1)
        tn2 = truncnorm(-3, 3, loc=Rap_mean, scale=Rap_var)
        theta2 = tn2.rvs(size=2)
        Rap = np.around(theta2,1)

        Req_001 = R_3parallel(Rap[0], Rap[1], Rp[0])
        in_001 = v/Req_001
        in_001_array[i] = in_001


    plt.hist(in_001_array,bins=hist_bins)
#     plt.savefig("in_001.png")
#     plt.show()
#     save_as_csv("in_001.csv",in_001_array)

# For in_011
if eval_in_011 == True:
    in_011_array = np.zeros(no_of_trials)
    for i in range(no_of_trials):
        tn1 = truncnorm(-3, 3, loc=Rp_mean, scale=Rp_var)
        theta1 = tn1.rvs(size=2)
        Rp = np.around(theta1,1)
        tn2 = truncnorm(-3, 3, loc=Rap_mean, scale=Rap_var)
        theta2 = tn2.rvs(size=1)
        Rap = np.around(theta2,1)

        Req_011 = R_3parallel(Rap[0], Rp[0], Rp[1])
        in_011 = v/Req_011
        in_011_array[i] = in_011


    plt.hist(in_011_array,bins=hist_bins)
#     plt.savefig("in_011.png")
#     plt.show()
#     save_as_csv("in_011.csv",in_011_array)

# For in_111
if eval_in_111 == True:
    in_111_array = np.zeros(no_of_trials)
    for i in range(no_of_trials):
        tn1 = truncnorm(-3, 3, loc=Rp_mean, scale=Rp_var)
        theta1 = tn1.rvs(size=3)
        Rp = np.around(theta1,1)

        Req_111 = R_3parallel(Rp[0], Rp[1], Rp[2])
        in_111 = v/Req_111
        in_111_array[i] = in_111


    plt.hist(in_111_array,bins=hist_bins)
#     plt.savefig("in_111.png")
#     plt.show()
#     save_as_csv("in_111.csv",in_111_array)


# For ref_read
if eval_ref_read == True:
    ref_read_array = np.zeros(no_of_trials)
    for i in range(no_of_trials):
        tn1 = truncnorm(-3, 3, loc=Rp_mean, scale=Rp_var)
        theta1 = tn1.rvs(size=1)
        Rp = np.around(theta1,1)
        tn2 = truncnorm(-3, 3, loc=Rap_mean, scale=Rap_var)
        theta2 = tn2.rvs(size=1)
        Rap = np.around(theta2,1)

        Req_read = (Rp + Rap)/2
        ref_read = v/Req_read
        ref_read_array[i] = ref_read

    plt.hist(ref_read_array,bins=hist_bins)
#     plt.savefig("ref_read.png")
#     plt.show()
#     save_as_csv("ref_read.csv",ref_read_array)


# For ref_or
if eval_ref_or == True:
    ref_or_array = np.zeros(no_of_trials)
    for i in range(no_of_trials):
        tn1 = truncnorm(-3, 3, loc=Rp_mean, scale=Rp_var)
        theta1 = tn1.rvs(size=1)
        Rp = np.around(theta1,1)
        tn2 = truncnorm(-3, 3, loc=Rap_mean, scale=Rap_var)
        theta2 = tn2.rvs(size=3)
        Rap = np.around(theta2,1)

        Req_or = (R_2parallel(Rap[0], Rap[1]) + R_2parallel(Rap[2], Rp))/2
        ref_or = v/Req_or
        ref_or_array[i] = ref_or

    plt.hist(ref_or_array,bins=hist_bins)
#     plt.savefig("ref_or.png")
#     plt.show()
#     save_as_csv("ref_or.csv",ref_or_array)


# For ref_and
if eval_ref_and == True:
    ref_and_array = np.zeros(no_of_trials)
    for i in range(no_of_trials):
        tn1 = truncnorm(-3, 3, loc=Rp_mean, scale=Rp_var)
        theta1 = tn1.rvs(size=3)
        Rp = np.around(theta1,1)
        tn2 = truncnorm(-3, 3, loc=Rap_mean, scale=Rap_var)
        theta2 = tn2.rvs(size=1)
        Rap = np.around(theta2,1)

        Req_and = (R_2parallel(Rap, Rp[0]) + R_2parallel(Rp[1], Rp[2]))/2
        ref_and = v/Req_and
        ref_and_array[i] = ref_and

    plt.hist(ref_and_array,bins=hist_bins)
#     plt.savefig("ref_and.png")
#     plt.show()
#     save_as_csv("ref_and.csv",ref_and_array)


# For ref_maj
if eval_ref_maj == True:
    ref_maj_array = np.zeros(no_of_trials)
    for i in range(no_of_trials):
        tn1 = truncnorm(-3, 3, loc=Rp_mean, scale=Rp_var)
        theta1 = tn1.rvs(size=3)
        Rp = np.around(theta1,1)
        tn2 = truncnorm(-3, 3, loc=Rap_mean, scale=Rap_var)
        theta2 = tn2.rvs(size=3)
        Rap = np.around(theta2,1)

        Req_maj = (R_3parallel(Rap[0], Rap[1], Rp[0]) + R_3parallel(Rap[2], Rp[1], Rp[2]))/2
        ref_maj = v/Req_maj
        ref_maj_array[i] = ref_maj

    plt.hist(ref_maj_array,bins=hist_bins)
#     plt.savefig("ref_maj.png")
#     plt.show()
#     save_as_csv("ref_maj.csv",ref_maj_array)

# All references in one graph
ref_all_array = np.zeros(3*no_of_trials)
ref_all_array[0:no_of_trials] = in_0_array
ref_all_array[no_of_trials:2*no_of_trials]= in_1_array
ref_all_array[2*no_of_trials:3*no_of_trials] = ref_read_array
# ref_all_array[0:1*no_of_trials] = in_00_array
# ref_all_array[1*no_of_trials:2*no_of_trials] = in_01_array
# ref_all_array[2*no_of_trials:3*no_of_trials] = in_11_array
# ref_all_array[3*no_of_trials:4*no_of_trials] = ref_or_array
# ref_all_array[4*no_of_trials:5*no_of_trials] = ref_and_array
# ref_all_array[0:1*no_of_trials] = in_000_array
# ref_all_array[1*no_of_trials:2*no_of_trials] = in_001_array
# ref_all_array[2*no_of_trials:3*no_of_trials] = in_011_array
# ref_all_array[3*no_of_trials:4*no_of_trials] = in_111_array
# ref_all_array[4*no_of_trials:5*no_of_trials] = ref_maj_array
plt.hist(ref_all_array, bins=hist_bins_all,edgecolor='b',color='b')
plt.savefig("ref_all.png")
plt.show()
save_as_csv("ref_all.csv",ref_all_array)
#---------------------------------------------------------------#
