# -*- coding: utf-8 -*-
"""
Created on Thu Aug 11 15:55:46 2022

@author: jinglaaynes
"""
import numpy as np
import matplotlib.pyplot as plt
font = {'family' : 'DejaVu Sans',
        'weight' : 'normal',
        'size'   : '15'}
plt.rc('font', **font)
filename = 'M02_I_18to03_1uA_V28to17_10x.dat'
data = np.loadtxt(filename, skiprows=14)
Vbg, Vx, Vy, T = data.T
Vdiff = Vx
L = 2E-6
W = 7.21E-6
I = 1E-6

fig, ax1 = plt.subplots()
Rsq = W*Vdiff/(L*I)
Indmin = np.argmin(Rsq)
Rmin = Rsq[Indmin]
ax1.plot(Vbg, Rsq*1E-3, 'k')
ax2 = ax1.twinx()
ax2.plot(Vbg, 1E3/Rsq, c='r')
ax2.set_ylim([0, 0.07])
ax1.tick_params(direction='in',top=True)
ax2.tick_params(direction='in')
ax2.set_yticks(np.arange(0,70,20))
ax1.set_xlabel('$V_\mathrm{bg}$ (V)', fontsize=20)
ax1.set_ylabel('$R_\mathrm{sq}$ (k$\\Omega$)', fontsize=20)
ax2.set_ylabel('$\sigma$ (ms)', fontsize=20, color='r')
plt.savefig('RsqAndSigmavsVbg.pdf')
plt.show()


Cond = L*I/(W*Vdiff)
el = 1.602E-19
n = 0.001445*(Vbg-0.02)/el
mob = np.abs(Cond/(n*el))
fig, ax1 = plt.subplots()
ax1.plot(Vbg, mob,'k')
ax1.set_ylim([5, 25])
me = 9.109E-31
m = 0.034 * me
tp = m * mob / el
ax2 = ax1.twinx()
ax2.plot(Vbg, tp*1E12, 'r')
ax2.set_ylim([1, 6])
ax1.tick_params(direction='in',top=True)
ax2.tick_params(direction='in')
ax1.set_xlabel('$V_\mathrm{bg}$ (V)', fontsize=20)
ax1.set_ylabel('$\mu$ (m$^2$/(Vs))', fontsize=20)
ax2.set_ylabel('$\\tau_p$ (ps)', fontsize=20, color='r')
plt.savefig('MobilityAndTauPvsVbg.pdf')
#plt.tight_layout()
#plt.tick_params()
