# -*- coding: utf-8 -*-
"""
Created on Tue Jan 31 10:26:08 2023

@author: jinglaaynes
"""
import numpy as np
import matplotlib.pyplot as plt
import scipy.constants as c
import os
from matplotlib.ticker import AutoMinorLocator

font = {'family' : 'DejaVu Sans',
        'weight' : 'normal',
        'size'   : '15'}
plt.rc('font', **font)
def RmaxMRminvsVbgPlot(filename, Vbgrange, ylimit=0, gridOn=True):
    global Rmax, Rmin, Vbgs
    data=np.loadtxt(filename, skiprows = 18)
    Vbg, Vtg, Vdiff, *other = data.T
    R0 = 25812/4 #Ohms
    Vbgs = np.sort(np.unique(Vbg))
    Vtgmax = []
    Rmax = []
    Rmin = []
    if Vbgrange != 0:
        filt_Vbgs = np.multiply(Vbgs>min(Vbgrange), Vbgs<max(Vbgrange))
        Vbgs = Vbgs[filt_Vbgs]
    for Vb in Vbgs:
        filt = Vbg == Vb
        Vtgfilt = Vtg[filt]
        Vdifffilt = Vdiff[filt]
        imax = np.argmax(Vdifffilt)
        Vtgmax.append(Vtgfilt[imax])
        Rmax.append(Vdifffilt[imax] * 1E8)
        imin = np.argmin(Vdifffilt)
        Rmin.append(Vdifffilt[imin] * 1E8)
    Rcont = np.array(Rmax)-np.array(Rmin)
    #plt.plot(Vbgs, Rcont)
    CondCont = R0/Rcont
    plt.figure()
    plt.plot(Vbgs, CondCont)
    plt.xlabel('$V_\mathrm{bg}$ (V)', fontsize=20)
    plt.ylabel('$G$ ($4e^2/h$)', fontsize=20)
    plt.tick_params(direction='in', top=True, right=True)
    plt.tick_params(which='minor', direction='in', bottom=False, right=True)
    plt.gca().yaxis.set_minor_locator(AutoMinorLocator(n=2))
    if gridOn:
        plt.grid(b=True, which='both', axis='y')
    if ylimit != 0:
        plt.ylim([min(ylimit), max(ylimit)])
    print(filename[:19])
    return Vbgs, CondCont


def find_Rmax(Vbg, Vtg, R):
    Vbgu = np.sort(np.unique(Vbg))
    Rmax = []
    Vtgmax = []
    for Vbu in Vbgu:
        filt_Vbg = Vbg==Vbu
        Vtgr = Vtg[filt_Vbg]
        Rr = R[filt_Vbg]
        imax = np.argmax(Rr)
        Rmax.append(Rr[imax])
        Vtgmax.append(Vtgr[imax])
    return Vbgu, Vtgmax, Rmax
def find_Condmin(Vbg, Vtg, Cond):
    Vbgu = np.sort(np.unique(Vbg))
    Condmin = []
    Vtgmin = []
    for Vbu in Vbgu:
        filt_Vbg = Vbg==Vbu
        Vtgr = Vtg[filt_Vbg]
        Condr = Cond[filt_Vbg]
        imin = np.argmin(Condr)
        Condmin.append(Condr[imin])
        Vtgmin.append(Vtgr[imin])
    return Vbgu, Vtgmin, Condmin
#%% M04 color plot
fname='M04_BLGhBN09_I22Ato24B_10nA_V22Ato24B_1x.txt'
data1=np.loadtxt(fname, skiprows=1)
Vbg1, Vtg1, LI1x, LI1y=data1.T
Vbgu = np.unique(Vbg1)
Vtgu = np.unique(Vtg1)
x,y = np.meshgrid(Vbgu,Vtgu)
R=np.reshape(LI1x*1E8/1E3, (101,201)).T
plt.contourf(x,y,R,levels=200)
zmax = np.floor(np.max(R))
zmin = np.floor(np.min(R))
ticks = np.linspace(zmin, zmax, 5)
t = [round(ti) for ti in ticks]
plt.colorbar(ticks=t)
plt.title('$R_{2p}$ (k$\Omega$)', fontsize=20)
plt.xlabel('$V_\mathrm{bg}$ (V)', fontsize=20)
plt.ylabel('$V_\mathrm{tg}$ (V)', fontsize=20)
plt.tick_params(direction='in', top=True,right=True)
plt.savefig('M04Colormap.jpg')
plt.show()
#%% Conductance vs Vbg of both QPCs
fname='M04_BLGhBN09_I22Ato24B_10nA_V22Ato24B_1x.txt'
Vbgs, CondCont=RmaxMRminvsVbgPlot(fname,Vbgrange=[-10,10],ylimit=[0,10])
fname='M07_BLGhBN09_I22Ato06A_10nA_V22Ato06A_1x.txt'
Vbgs2, CondCont2=RmaxMRminvsVbgPlot(fname,Vbgrange=[-10,10],ylimit=[0,10])
plt.show()
plt.plot(Vbgs, CondCont, label='Left')
plt.plot(Vbgs2, CondCont2, label='Right')
plt.legend()
plt.ylim([0,10])
plt.tick_params(direction='in',top=True,right=True)

plt.ylabel('$G$ (4$e^2/h$)', fontsize=20)
plt.xlabel('$V_\mathrm{bg}$ (V)', fontsize=20)
plt.savefig('ConductanceCorrectedM04andM07.pdf')
plt.show()
#%% Colormap Rnl
fname='M61_BLGhBN09_I22Ato24B_V09Ato06A_100x.txt'
data1=np.loadtxt(fname, skiprows=1)
B, Vbg1, Vtg1, LI1x, LI1y=data1.T
Vbg1_filt=Vbg1<7
Vbg1=Vbg1[Vbg1_filt]
B=B[Vbg1_filt]
LI1x=LI1x[Vbg1_filt]
Vbg1=np.unique(Vbg1)
B=np.unique(B)
x,y=np.meshgrid(Vbg1,B)
LI1x = LI1x.reshape(np.size(Vbg1),np.size(B)).T
Rmeas1=LI1x*1E7
plt.contourf(x,y,Rmeas1,levels=np.linspace(-20,150,18))
t=np.linspace(150,-50,6)
plt.colorbar(ticks=t,label='$R_\mathrm{nl}$ ($\\Omega$)')
plt.title('M61 I(22A to 24B) V(09A to 06A)',fontsize=20)
plt.tick_params(top=True,right=True,direction='in')
plt.xlabel('$V_\\mathrm{bg}$ (V)', fontsize=20)
plt.ylabel('$B$ (T)', fontsize=20)
plt.savefig('ColormapFocusingElectrons.jpg')
plt.show()
#%% M65 Focusing holes at 650 mK
fname='M65_BLGhBN09_I22Ato24B_100nA_V09Ato06A_100x.txt'
data2=np.loadtxt(fname, skiprows=1)
B, Vbg1, Vtg1, LI1x, LI1y=data2.T
Vtgu=np.sort(list(set(Vtg1)))
#mpl.rcParams['axes.prop_cycle']='mpl.inferno'
for Vtg in Vtgu:
    filt_Vtg = Vtg1 == Vtg
    Br = B[filt_Vtg]
    Rxr = LI1x[filt_Vtg]*1E7
    plt.plot(Br, Rxr,'-',linewidth=3,label=('$V_\mathrm{}$={} V'.format('{tg}',round(Vtg,2))))
    plt.tick_params(direction='in',top=True,right=True)
plt.xlim([-0.5,0.5])
plt.ylim([-2,80])
plt.legend(loc='upper left')
plt.xlabel('$B$ (T)', fontsize=20)
plt.ylabel('$R_\mathrm{nl}$ ($\Omega$)', fontsize=20)
plt.title('$V_\mathrm{bg}=-6$ V', fontsize=20)
plt.savefig('FocusingHolesDifVtg.pdf')
#%% Reciprocity 2.4K
fname='M114_BLGhBN09_I22Ato24B_100nA_V09Ato06A_100x.txt'
data2=np.loadtxt(fname, skiprows=1)
B, Vbg1, Vtg1, LI1x, LI1y=data2.T
fname='M115_BLGhBN09_I09Ato06A_100nA_V22Ato24B_100x.txt'
data3=np.loadtxt(fname, skiprows=1)
B3, Vbg3, Vtg3, LI3x, LI3y=data3.T
Vgu = np.sort(np.unique(Vbg3))
for i, Vgel in enumerate(Vgu):
    filt_Vg = Vbg3==Vgel
    Br = B[filt_Vg]
    Rr = LI1x[filt_Vg]*1E7 
    B3r = B3[filt_Vg]
    R3r = LI3x[filt_Vg]*1E7
    plt.plot(Br, Rr,'C{}'.format(i),
             label='$V_\mathrm{}={}$ V I(22A to 24B) V(09A to 06A)'.format('{bg}',round(Vgel,0)))
    plt.plot(B3r, R3r,'C{}--'.format(i),
             label='$V_\mathrm{}={}$ V I(09A to 06A) V(22A to 24B)'.format('{bg}',round(Vgel,0)))
plt.legend(bbox_to_anchor=(0,1.5), loc="upper left")
plt.tick_params(direction='in',top=True,right=True)
plt.xlabel('$B$ (T)', fontsize=20)
plt.ylabel('$R_\mathrm{nl}$ ($\Omega$)', fontsize=20)
plt.savefig('PlotM114and115Reciprocity.pdf')
#%% Analysis peak positions
nAFM = lambda V: c.epsilon_0*3.75*(V+4)/(c.e*47E-9)
BpeakExp = lambda n, L: 2*c.hbar*np.sqrt(np.abs(n)*np.pi)/(c.e*L)
L = 4E-6
Bpeakm6 = [0.078, 0.186, 0.3, 0.402]
Bpeakm5 = [0.096, 0.156, 0.222, 0.306, 0.36, 0.432]
pm6 = [1, 2, 4, 5]
pm5 = [1, 2, 3, 4, 5, 6]
polm6 = np.polyfit(pm6, Bpeakm6, 1)
polym6 = np.poly1d(polm6)
polm5 = np.polyfit(pm5, Bpeakm5, 1)
polym5 = np.poly1d(polm5)
plt.figure(figsize=[2,1.4])
plt.plot(pm6, Bpeakm6, 'o',c='C0', label='$V_\mathrm{bg}=-6$ V', alpha=0.7)
#plt.plot(pm6, polym6(pm6),c='C0')
plt.plot(pm6, np.array(pm6)*0.0802,'-',c='C0')
plt.plot(pm5, Bpeakm5, 'o',c='C1', label='$V_\mathrm{bg}=-5$ V', alpha=0.7)
#plt.plot(pm5, polym5(pm5),c='C1')
plt.plot(pm5, np.array(pm5)*0.0718,'-',c='C1')
plt.tick_params(direction='in', top=True, right=True)
plt.xlabel('$p$', fontsize=20)
plt.xticks([1,3,5])
plt.ylabel('$B$ (T)', fontsize=20)
#plt.legend()
plt.savefig('BfocusVSp.pdf')