# -*- coding: utf-8 -*-
"""
Created on Thu Aug 11 18:24:34 2022

@author: jinglaaynes
"""
import numpy as np
import matplotlib.pyplot as plt
from scipy.signal import savgol_filter
font = {'family' : 'DejaVu Sans',
        'weight' : 'normal',
        'size'   : '15'}
plt.rc('font', **font)
#%% Here I load the data
filename = 'M10_I_32to18_100nA_V02to30_100x.dat'
data1m3 = np.loadtxt(filename, skiprows=14)
B1m3, Vbg1m3, Vtg1m3, Vx1m3, Vy, time, T = data1m3.T
filename = 'M12_I_02to30_100nA_V32to18_100x.dat'
data2m3 = np.loadtxt(filename, skiprows=14)
B2m3, Vbg2m3, Vtg2m3, Vx2m3, Vy, time, T = data2m3.T
filename = 'M13_I_02to30_100nA_V32to18_100x.dat'
data2p3 = np.loadtxt(filename, skiprows=14)
B2p3, Vbg2p3, Vtg2p3, Vx2p3, Vy, time, T = data2p3.T
filename = 'M14_I_32to18_100nA_V02to30_100x.dat'
data1p3 = np.loadtxt(filename, skiprows=14)
B0 = -0.055
B1p3, Vbg1p3, Vtg1p3, Vx1p3, Vy, time, T = data1p3.T
#%% Here I create the plot at Vbg= -3 V
plt.plot(B1m3+B0, Vx1m3*1E7, label='$R_\mathrm{nl}^\mathrm{C1}(B)$')# {32,18,02,30}
plt.plot(-(B2m3+B0), Vx2m3*1E7, label='$R_\mathrm{nl}^\mathrm{C1R}(-B)$ ')
plt.tick_params(direction='in', top=True, right=True)
plt.legend()
plt.xlabel('B (T)', fontsize=20)
plt.ylabel('$R_\mathrm{nl}$ ($\Omega$)', fontsize=20)
plt.title('$V_\mathrm{bg}=-3$ V')
#plt.xlim([0,0.5])
plt.savefig('ReciprocityVbgm3V.pdf')
plt.show()
#%% Here I create the plot at Vbg= +3 V
plt.plot(B1p3+B0, Vx1p3*1E7, label='$R_\mathrm{nl}^\mathrm{C1}(B)$')
plt.plot(-(B2p3+B0), Vx2p3*1E7, label='$R_\mathrm{nl}^\mathrm{C1R}(-B)$ ')
plt.tick_params(direction='in', top=True, right=True)
plt.legend()
plt.xlabel('B (T)', fontsize=20)
plt.ylabel('$R_\mathrm{nl}$ ($\Omega$)', fontsize=20)
plt.title('$V_\mathrm{bg}=+3$ V')
#plt.xlim([0,0.5])
plt.savefig('ReciprocityVbgp3V.pdf')
plt.show()