# -*- coding: utf-8 -*-
"""
Created on Wed Oct 12 17:50:49 2022

@author: jinglaaynes
"""
import numpy as np
import matplotlib.pyplot as plt
font = {'family' : 'DejaVu Sans',
        'weight' : 'normal',
        'size'   : '15'}
plt.rc('font', **font)
def focus_fun(filename_list, Vbgrange=[]):
    B_tot = []
    Vbg_tot = []
    Vdiff_tot = []
    Vbg_clean = np.array([])
    B_clean = np.array([])
    R_clean = np.array([])
    for f in filename_list:
        data = np.loadtxt(f, skiprows=18)
        B, Vbg, Vtg, V_diff, *other = data.T
        B_tot = np.append(B_tot, B)
        Vbg_tot = np.append(Vbg_tot, Vbg)
        Vdiff_tot = np.append(Vdiff_tot, V_diff)
        
    Bdiff = np.append(np.diff(B_tot), 0)
    Vbgs = np.sort(np.unique(Vbg_tot))
    if Vbgrange!=[]:
        filt = np.multiply(Vbgs < max(Vbgrange),Vbgs>min(Vbgrange))
        Vbgs = Vbgs[filt] 
    for i, Vb in enumerate(Vbgs):
        #filt = Vbg_tot==Vb
        filt = np.multiply(Vbg_tot==Vb, Bdiff>0)
        plt.plot(B_tot[filt], Vdiff_tot[filt]*1E7+i*DR, label='$V_\mathrm{}={}$ V'.format('{bg}',round(Vb,2)))
        Vbg_clean = np.append(Vbg_clean, Vbg_tot[filt])
        B_clean = np.append(B_clean, B_tot[filt])
        R_clean = np.append(R_clean, Vdiff_tot[filt]*1E7)
    plt.legend()
    plt.tick_params(direction='in',top=True,right=True)
    plt.xlabel('$B$ (T)', fontsize=20)
    plt.ylabel('$R_\mathrm{nl}$ ($\Omega$)', fontsize=20)
    plt.tight_layout()
    return
#%% M16
DR = 0
fname = '_BLGhBN14_I32to18_100nA_V02to30_100x.dat'
filename_list = ['M14'+fname, 'M16'+fname]
focus_fun(filename_list, Vbgrange=[-0.1,0.51])
plt.savefig('M14andM16CNPFocusingVbg0and0p5V.pdf')
plt.show()
focus_fun(filename_list, Vbgrange=[-0.51,-0.1])
plt.savefig('M14andM16CNPFocusingVbgm0p5V.pdf')
plt.show()
#%% Panel c Figure S10
filename = 'M15_BLGhBN14_I32to18_100nA_V02to30_100x.dat'
data=np.loadtxt(filename, skiprows = 18)
B, Vbg, Vtg, Vdiff, *other = data.T
Vbgs = np.sort(np.unique(Vbg))
Vtgs2=[]
Vbgs2=[]
for Vb in Vbgs:
    filt = Vbg == Vb
    Vt = np.unique(Vtg[filt])
    for V in Vt:
        Vtgs2.append(V)
        Vbgs2.append(Vb)
Vtgs = np.sort(np.unique(Vtg))
Vbgrange= [-5,5]
Vtgrange= [-5,5]
filt_range = np.multiply(Vbgs<max(Vbgrange),Vbgs>min(Vbgrange))
Vbgs = Vbgs[filt_range]
for Vb, Vt in zip(Vbgs2, Vtgs2):
    print(Vb, Vt)
    filt1 = Vbg == Vb
    filt2 = Vtg == Vt
    fprod=np.multiply(filt1,filt2)
    Bfilt = B[fprod]
    Vdifffilt = Vdiff[fprod]
    imax = int(len(Bfilt)/2)
    plt.plot(Bfilt[imax:], Vdifffilt[imax:]*1E7, label='{}, {}'.format(round(Vb,2),round(Vt,2)))#$V_\mathrm{}={}$ V
    #plt.plot(Vbgs, R0/np.array(Rmax), 'o')
plt.legend(title='\t$V_\mathrm{bg}$ $V_\mathrm{tg}$')#loc='upper left'
#plt.ylim([-50,1500])
#plt.xlim([-0.5,0.5])
plt.xlabel('$B$ (T)', fontsize=20)
plt.ylabel('$R_\mathrm{nl}$ ($\Omega$)', fontsize=20)
plt.tick_params(direction='in', top=True, right=True)
#plt.savefig(filename[:19]+'.jpg')
plt.savefig('FocusingCNP_M15.pdf')
plt.show()