# -*- coding: utf-8 -*-
"""
Created on Wed Jan 25 15:27:03 2023

@author: jinglaaynes
"""
import matplotlib.pyplot as plt
import numpy as np
import scipy.signal as sp
from scipy import fftpack, fft
from scipy.signal import argrelextrema


font = {'family' : 'DejaVu Sans',
        'weight' : 'normal',
        'size'   : '15'}
plt.rc('font', **font)

def default_color_cycle_C0Blue():
    # Back to default color cycle
    new_colors = ['b', '#ff7f0e', '#2ca02c', '#d62728',
                  '#9467bd', '#8c564b', '#e377c2', '#7f7f7f',
                  '#bcbd22', '#17becf']
    plt.rcParams['axes.prop_cycle'] = plt.cycler(color=new_colors)
    return

def default_color_cycle():
    # Back to default color cycle
    new_colors = ['#1f77b4', '#ff7f0e', '#2ca02c', '#d62728',
                  '#9467bd', '#8c564b', '#e377c2', '#7f7f7f',
                  '#bcbd22', '#17becf']
    plt.rcParams['axes.prop_cycle'] = plt.cycler(color=new_colors)
    return

def find_peak_area(xdata, ydata, ind_i, ind_f, dist = 7, prom=20, color=[]):
    '''
    This function is used to find the area under a peak using the trapz function
    of the numpy package and the baseline function from peakutils
    Packages needed:
    matplotlib.pyplot
    numpy
    peakutils
    '''
    if np.sum(np.diff(xdata))<0:
        xdata = xdata[::-1]
        ydata = ydata[::-1]
    # Here we create the baseline by linear interpolation between the minima
    # detected before and given by ind_i and ind_f
    xbase = [xdata[ind_i], xdata[ind_f]]
    ybase = [ydata[ind_i], ydata[ind_f]]
    baseline_values = np.interp(xdata, xbase, ybase)
    x_peak = xdata[ind_i:ind_f]
    y_peak = ydata[ind_i:ind_f]
    b_peak = baseline_values[ind_i:ind_f]
    A1 = np.trapz(y_peak, x_peak) 
    A2 = np.trapz(b_peak, x_peak)
    area_under_peak = A1 - A2
    colormap = plt.cm.get_cmap('jet')
    plt.rcParams['axes.prop_cycle'] = plt.cycler(color=[colormap(k) for k in np.linspace(0, 1, 10)])
    if color == []:
        plt.plot(x_peak, y_peak, '-o')
        plt.plot(x_peak, b_peak, '-')
        plt.fill_between(x_peak, y_peak, b_peak, alpha=0.5)
    else:
        plt.plot(x_peak, y_peak, '-o', c=color)
        plt.plot(x_peak, b_peak, '-', c=color)
        plt.fill_between(x_peak, y_peak, b_peak, color=color, alpha=0.5)
        
    xmean = (xdata[0]+xdata[-1])/2
    #default_color_cycle()
    return xmean, area_under_peak


#%% Obtain areas for Fig. 2c paper
# NOTE THAT THE DIRECTORY HAS TO BE CHANGED TO FIND M20 of Round 2
data = np.loadtxt('M14M16M17M28_OverviewC1.txt', skiprows=0)
B, Vbg, Vtg, Vdiff, *other = data.T
Vbgs = np.sort(np.unique(Vbg))
direct='.\\ContactResistance'
fname='M20_I_32to30_100nA_V32to30_10x_DetRes1p8to100K.dat'
filename = direct+"\\"+fname
# Rc from round 2
dataRc = np.loadtxt(filename, skiprows=27)
BRc, VbgRc, VtgRc, V2px, LIyRc, tRc, TempRc = dataRc.T 
filt_T = np.round(TempRc,0) == 10
BT = BRc[filt_T]
V2pT = V2px[filt_T]
VbgRcT = VbgRc[filt_T]

for Vb in [-3, 3]:
    filt_Vbg = np.round(Vbg,1) == Vb
    Bbg = B[filt_Vbg]
    Rbg = Vdiff[filt_Vbg] * 1E7
    print('length Rbg={}'.format(len(Rbg)))
    filt_RcVg = np.round(VbgRcT) == Vb
    BRcT = BT[filt_RcVg]
    Rc = V2pT[filt_RcVg] * 1E7
    Rca = np.interp(Bbg,BRcT[:-2],Rc[:-2])
    Rbg = Rbg*1000/Rca
    plt.plot(Bbg, Rbg, 'k')
    if Vb>0:
        filt_lowB = np.abs(Bbg)<1
        Bbg_lowB = Bbg[filt_lowB]
        Bi = Bbg_lowB[np.argmax(Rbg[filt_lowB])]
        dB1 = 0.21896897
        dB2 = 0.17517518
        plt.vlines(Bi -dB1*np.arange(0,9,1), -50, 200, colors='blue', linestyles='dashed')
        plt.vlines(Bi -dB2*np.arange(0,11,1), -50, 200, colors='red', linestyles='dashed')
        min_ind2 = sp.find_peaks(-sp.savgol_filter(Rbg,5,1), distance=1, prominence=2)
        min_ind2 = min_ind2[0]
        if 185 in min_ind2:
            min_ind2 = np.delete(min_ind2, -5) # .remove(185)
    else:
        min_ind2 = sp.find_peaks(-sp.savgol_filter(Rbg,5,1), distance=1, prominence=5)
        min_ind2 = min_ind2[0]
        
    ind_i_list = min_ind2[:-1]
    ind_f_list = min_ind2[1:]
    area_peaks = []
    B_average = []
    i=0
    for ind_i, ind_f in zip(ind_i_list, ind_f_list):
        Bmean, area_peak = find_peak_area(Bbg, Rbg, ind_i, ind_f,color = 'C{}'.format(i))
        #print(Bmean)
        area_peaks.append(area_peak)
        B_average.append(np.mean(Bbg[ind_i:ind_f]))
        plt.title('$V_\mathrm{}$={} V'.format('{bg}',np.round(Vb,1)))
        if i<9:
            i += 1
        else:
            i=0
        #plt.xlim([0, 2])
    if Vb>0:
        plt.xlim([-2.5, 0])
        plt.ylim([-50, 200])
    else:
        plt.xlim([0,2.5])
    plt.tick_params(direction='in', top=True, right=True)
    plt.xlabel('$B$ (T)', fontsize=20)
    plt.ylabel('$R_\mathrm{nl}/R_c$ ($\\times 10^3$)', fontsize=20)
    plt.savefig('AreaUnderPeaksVbg={}V.pdf'.format(Vb))
    plt.show()
    plt.plot(B_average, np.abs(area_peaks), 'o')
    data = np.vstack((B_average, np.abs(area_peaks))).T
    np.savetxt('AreaUnderPeaksFig2MainRcNormalizedVbg={}.dat'.format(round(Vb)), data)
    plt.title('Vbg={} V'.format(np.round(Vb,1)))
    plt.show()
    
#%% Fourier transform
filt_Vbg = np.round(Vbg, 2) == 3
Bs1 = -B[filt_Vbg]
Bs = Bs1[Bs1>0]
Vs = Vdiff[filt_Vbg]
Vs = Vs[Bs1>0] * 1E7
plt.plot(Bs, Vs)
plt.show()
# Generate evenly distributed set of B-field points
B_even = np.linspace(0, 3, 250)
# Interpolate the voltages
V_even = np.interp(B_even, Bs[::-1], Vs[::-1])
plt.plot(B_even, V_even)
plt.show()
# Number of sample points
N = len(B_even)
# Sample spacing
T = np.diff(B_even)[0]
xf = fftpack.fftfreq(N, T)[:N//2]
VTrans = fft(V_even-np.mean(V_even))[:N//2]
offset = np.fft.fftshift(V_even-np.mean(V_even))
plt.figure(figsize=(1.5, 0.8))
plt.plot(xf, np.abs(VTrans), '-')
plt.xlim([0, 7])
#plt.ylim([0, 0.5])

# Find local maxima
idx = argrelextrema(np.abs(VTrans), np.greater)

first_peaks = (1/xf[idx])
# Identify FFT peaks with period smaller than 0.25T
idx2 = first_peaks < 0.25
first_peaks2 = first_peaks[idx2]
plt.plot(xf[idx][2:4], np.abs(VTrans[idx][2:4]), 'xr')
plt.tick_params(direction='in',top=True, right=True)
plt.xlabel('Freq (1/T)', fontsize=20)
plt.ylabel('abs(FFT)', fontsize=20)
plt.savefig('FourierTransform.pdf')
plt.show()
#%% Use the created .dat files to make the plot in Fig. 2c
default_color_cycle_C0Blue()
datam3 = np.loadtxt('AreaUnderPeaksFig2MainRcNormalizedVbg=-3.dat')
Bm3, Am3 = datam3.T
pm3 = [1, 2, 3, 4, 5, 6]
datap3= np.loadtxt('AreaUnderPeaksFig2MainRcNormalizedVbg=3.dat')
Bp3, Ap3 = datap3.T
Ap3=Ap3[::-1]
pp3 = [1, 2, 3, 4, 5, 6, 7, 8]

plt.figure(figsize=[2,1.2])
plt.plot(pm3, Am3[:6]/Am3[0], 'oC7')
popt = np.polyfit(pm3[1:], Am3[1:6]/Am3[0],1)
pol = np.poly1d(popt)
plt.plot(pm3, pol(pm3),'C7')
plt.plot(pp3, Ap3[:8]/Ap3[0], 'oC0')
popt = np.polyfit(pp3[1:], Ap3[1:8]/Ap3[0],1)
pol = np.poly1d(popt)
plt.plot(pp3, pol(pp3),'C0')
plt.plot([1], [1], 'ok')
plt.xticks([1,3,5,7,9])
plt.yticks([0,1,2])
plt.tick_params(direction='in', top=True, right=True)
plt.ylabel('$A_p/A_1$', fontsize=20)
plt.xlabel('p', fontsize=20)
plt.savefig('RcNormalizedAreaUnderPeaksVbgpm3V.pdf')
plt.show()
#%% Obtain areas C2 main
data = np.loadtxt('M30_BLGhBN14_I12to28_100nA_V14to17_100x.dat', skiprows=26)
data1 = np.loadtxt('M31_BLGhBN14_I12to28_100nA_V14to17_100x.dat', skiprows=26)
data = np.vstack((data, data1))
B, Vbg, Vtg, Vdiff, *other = data.T
Vbgs = np.unique(Vbg)
# Now I plot the area under peaks normalized by the contact resistance
direct='.\\ContactResistance'
fname='M20_I_32to30_100nA_V32to30_10x_DetRes1p8to100K.dat'
filename = direct+"\\"+fname
# Rc from round 2
dataRc = np.loadtxt(filename, skiprows=27)
BRc, VbgRc, VtgRc, V2px, LIyRc, tRc, TempRc = dataRc.T 
filt_T = np.round(TempRc, 0) == 10
BT = BRc[filt_T]
V2pT = V2px[filt_T]
VbgRcT = VbgRc[filt_T]

for Vb in Vbgs[[1,-1]]:
    filt_Vbg = np.round(Vbg, 1) == np.round(Vb,1)
    Bbg = B[filt_Vbg][int(np.sum(filt_Vbg) / 2):]
    Rbg = Vdiff[filt_Vbg][int(np.sum(filt_Vbg) / 2):] * 1E7
    print('length Rbg={}'.format(len(Rbg)))
    filt_RcVg = np.round(VbgRcT,1) == np.round(Vb,1)
    BRcT = BT[filt_RcVg]
    Rc = V2pT[filt_RcVg] * 1E7
    Rca = np.interp(Bbg, BRcT[:-2], Rc[:-2])
    Rbg = Rbg * 1000 / Rca #/ np.interp(Bbg,BRcT,Rc)
    plt.plot(Bbg, Rbg, 'k')
    min_ind2 = sp.find_peaks(-sp.savgol_filter(Rbg,5,1), distance=1, prominence=3)
    min_ind2 = min_ind2[0]
    print(Bbg[min_ind2])   
    ind_i_list = min_ind2[:-1]
    ind_f_list = min_ind2[1:]
    area_peaks = []
    B_average = []
    i=0
    for ind_i, ind_f in zip(ind_i_list, ind_f_list):
        Bmean, area_peak = find_peak_area(Bbg, Rbg, ind_i, ind_f,color = 'C{}'.format(i))
        area_peaks.append(area_peak)
        B_average.append(np.mean(Bbg[ind_i:ind_f]))
        plt.title('$V_\mathrm{}$={} V'.format('{bg}',np.round(Vb,1)))
        if i<9:
            i += 1
        else:
            i=0
        
    if Vb<0:
        plt.xlim([-2.5, 0])
        plt.ylim([-50, 200])
    else:
        plt.xlim([0,2.5])
        plt.ylim([-50, 200])
    plt.tick_params(direction='in', top=True, right=True)
    plt.xlabel('$B$ (T)', fontsize=20)
    plt.ylabel('$R_\mathrm{nl}/R_c$ ($\\times 10^3$)', fontsize=20)
    plt.savefig('AreaUnderPeaksGeom2Vbg={}V.pdf'.format(Vb))
    plt.show()
    plt.plot(B_average, np.abs(area_peaks), 'o')
    data = np.vstack((B_average, np.abs(area_peaks))).T
    np.savetxt('AreaUnderPeaksGeom2MainRcNormalizedVbg={}.dat'.format(round(Vb)), data)
    plt.title('Vbg={} V'.format(np.round(Vb,1)))
    plt.show()
#%% Use the created .dat files to make the plot in Fig. 3b, inset
default_color_cycle_C0Blue()
datam3 = np.loadtxt('AreaUnderPeaksGeom2MainRcNormalizedVbg=-3.0.dat')
Bm3, Am3 = datam3.T
Am3=Am3[::-1]
pm3 = [1, 2, 3, 4, 5]
datap3= np.loadtxt('AreaUnderPeaksGeom2MainRcNormalizedVbg=3.0.dat')
Bp3, Ap3 = datap3.T

pp3 = [1, 2, 3, 4, 5, 6, 7, 8]

plt.figure(figsize=[2,1.2])
plt.plot(pm3, Am3[:5]/Am3[0], 'o--C7')
popt = np.polyfit(pm3[1:], Am3[1:5]/Am3[0],1)
pol = np.poly1d(popt)
plt.plot(pm3, pol(pm3),'C7')
plt.plot(pp3, Ap3[:8]/Ap3[0], 'o--C0')
popt = np.polyfit(pp3[1:], Ap3[1:8]/Ap3[0],1)
pol = np.poly1d(popt)
plt.plot(pp3, pol(pp3),'C0')

plt.plot([1], [1], 'ok')
plt.xticks([1,3,5,7,9])
plt.yticks([1,3])
plt.tick_params(direction='in', top=True, right=True)
plt.ylabel('$A_p/A_1$', fontsize=20)
plt.xlabel('p', fontsize=20)
plt.savefig('Geom2RcNormalizedAreaUnderPeaksVbgpm3V.pdf')
plt.show()
#%% C3 main manuscript
data = np.loadtxt('M32_BLGhBN14_I03to06_100nA_V02to32_100x.dat', skiprows=26)
B, Vbg, Vtg, Vdiff, *other = data.T
Vbgs = np.unique(Vbg)
# Now I plot the area under peaks normalized by the contact resistance
direct='.\\ContactResistance'
fname='M20_I_32to30_100nA_V32to30_10x_DetRes1p8to100K.dat'
filename = direct+"\\"+fname
# Rc from round 2
dataRc = np.loadtxt(filename, skiprows=27)
BRc, VbgRc, VtgRc, V2px, LIyRc, tRc, TempRc = dataRc.T 
filt_T = np.round(TempRc, 0) == 10
BT = BRc[filt_T]
V2pT = V2px[filt_T]
VbgRcT = VbgRc[filt_T]

for Vb in Vbgs[[1,-1]]:
    filt_Vbg = np.round(Vbg, 1) == np.round(Vb,1)
    Bbg = B[filt_Vbg][int(np.sum(filt_Vbg) / 2):]
    Rbg = Vdiff[filt_Vbg][int(np.sum(filt_Vbg) / 2):] * 1E7
    print('length Rbg={}'.format(len(Rbg)))
    filt_RcVg = np.round(VbgRcT,1) == np.round(Vb,1)
    BRcT = BT[filt_RcVg]
    Rc = V2pT[filt_RcVg] * 1E7
    Rca = np.interp(Bbg, BRcT[:-2], Rc[:-2])
    Rbg = Rbg * 1000 / Rca #/ np.interp(Bbg,BRcT,Rc)
    plt.plot(Bbg, Rbg, 'k')
    min_ind2 = sp.find_peaks(-sp.savgol_filter(Rbg,5,1), distance=1, prominence=3)
    min_ind2 = min_ind2[0]
    print(Bbg[min_ind2])   
    ind_i_list = min_ind2[:-1]
    ind_f_list = min_ind2[1:]
    area_peaks = []
    B_average = []
    i=0
    for ind_i, ind_f in zip(ind_i_list, ind_f_list):
        Bmean, area_peak = find_peak_area(Bbg, Rbg, ind_i, ind_f,color = 'C{}'.format(i))
        area_peaks.append(area_peak)
        B_average.append(np.mean(Bbg[ind_i:ind_f]))
        plt.title('$V_\mathrm{}$={} V'.format('{bg}',np.round(Vb,1)))
        if i<9:
            i += 1
        else:
            i=0
        
    if Vb<0:
        plt.xlim([-2.5, 0])
        plt.ylim([-50, 150])
    else:
        plt.xlim([0,2.5])
        plt.ylim([-50, 150])
    plt.tick_params(direction='in', top=True, right=True)
    plt.xlabel('$B$ (T)', fontsize=20)
    plt.ylabel('$R_\mathrm{nl}/R_c$ ($\\times 10^3$)', fontsize=20)
    plt.savefig('AreaUnderPeaksM32Vbg={}V.pdf'.format(Vb))
    plt.show()
    plt.plot(B_average, np.abs(area_peaks), 'o')
    data = np.vstack((B_average, np.abs(area_peaks))).T
    np.savetxt('AreaUnderPeaksM32MainRcNormalizedVbg={}.dat'.format(round(Vb)), data)
    plt.title('Vbg={} V'.format(np.round(Vb,1)))
    plt.show()
#%% Use the created .dat files to make the plot in Fig. 3c, inset
default_color_cycle_C0Blue()
datam3 = np.loadtxt('AreaUnderPeaksM32MainRcNormalizedVbg=-3.0.dat')
Bm3, Am3 = datam3.T
Am3=Am3[::-1]
pm3 = [1, 2, 3, 4, 5]
datap3= np.loadtxt('AreaUnderPeaksM32MainRcNormalizedVbg=3.0.dat')
Bp3, Ap3 = datap3.T

pp3 = [1, 2, 3, 4, 5, 6]

plt.figure(figsize=[1.5,0.8])
plt.plot(pm3, Am3[:5]/Am3[0], 'oC7')
popt = np.polyfit(pm3[1:], Am3[1:5]/Am3[0],1)
pol = np.poly1d(popt)
plt.plot(pm3, pol(pm3),'C7')
plt.plot(pp3, Ap3[:6]/Ap3[0], 'oC0')
popt = np.polyfit(pp3[1:], Ap3[1:6]/Ap3[0],1)
pol = np.poly1d(popt)
plt.plot(pp3, pol(pp3),'C0')

plt.plot([1], [1], 'ok')
plt.xticks([1,3,5,7])
plt.yticks([0,1,2])
plt.tick_params(direction='in', top=True, right=True)
plt.ylabel('$A_p/A_1$', fontsize=20)
plt.xlabel('p', fontsize=20)
plt.savefig('Geom3RcNormalizedAreaUnderPeaksVbgpm3V.pdf')
plt.show()
#%% C4 geometry focusing
data = np.loadtxt('M42_BLGhBN14_I32to27_100nA_V02to31_100x.dat', skiprows=26)
B, Vbg, Vtg, Vdiff, *other = data.T
Vbgs = np.unique(Vbg)
# Now I plot the area under peaks normalized by the contact resistance
direct='.\\ContactResistance'
fname='M20_I_32to30_100nA_V32to30_10x_DetRes1p8to100K.dat'
filename = direct+"\\"+fname
# Rc from round 2
dataRc = np.loadtxt(filename, skiprows=27)
BRc, VbgRc, VtgRc, V2px, LIyRc, tRc, TempRc = dataRc.T 
filt_T = np.round(TempRc, 0) == 10
BT = BRc[filt_T]
V2pT = V2px[filt_T]
VbgRcT = VbgRc[filt_T]

for Vb in Vbgs[[1,-1]]:
    filt_Vbg = np.round(Vbg, 1) == np.round(Vb,1)
    Bbg = B[filt_Vbg][int(np.sum(filt_Vbg) / 2):]
    Rbg = Vdiff[filt_Vbg][int(np.sum(filt_Vbg) / 2):] * 1E7
    print('length Rbg={}'.format(len(Rbg)))
    filt_RcVg = np.round(VbgRcT,1) == np.round(Vb,1)
    BRcT = BT[filt_RcVg]
    Rc = V2pT[filt_RcVg] * 1E7
    Rca = np.interp(Bbg, BRcT[:-2], Rc[:-2])
    Rbg = Rbg * 1000 / Rca #/ np.interp(Bbg,BRcT,Rc)
    plt.plot(Bbg, Rbg, 'k')
    min_ind2 = sp.find_peaks(-sp.savgol_filter(Rbg,5,1), distance=1, prominence=3)
    min_ind2 = min_ind2[0]
    print(Bbg[min_ind2])   
    ind_i_list = min_ind2[:-1]
    ind_f_list = min_ind2[1:]
    area_peaks = []
    B_average = []
    i=0
    for ind_i, ind_f in zip(ind_i_list, ind_f_list):
        Bmean, area_peak = find_peak_area(Bbg, Rbg, ind_i, ind_f,color = 'C{}'.format(i))
        area_peaks.append(area_peak)
        B_average.append(np.mean(Bbg[ind_i:ind_f]))
        plt.title('$V_\mathrm{}$={} V'.format('{bg}',np.round(Vb,1)))
        if i<9:
            i += 1
        else:
            i=0
        
    if Vb<0:
        plt.xlim([-2.5, 0])
        plt.ylim([-50, 100])
    else:
        plt.xlim([0,2.5])
        plt.ylim([-50, 100])
    plt.tick_params(direction='in', top=True, right=True)
    plt.xlabel('$B$ (T)', fontsize=20)
    plt.ylabel('$R_\mathrm{nl}/R_c$ ($\\times 10^3$)', fontsize=20)
    plt.savefig('AreaUnderPeaksM42Vbg={}V.pdf'.format(Vb))
    plt.show()
    plt.plot(B_average, np.abs(area_peaks), 'o')
    data = np.vstack((B_average, np.abs(area_peaks))).T
    np.savetxt('AreaUnderPeaksM42MainRcNormalizedVbg={}.dat'.format(round(Vb)), data)
    plt.title('Vbg={} V'.format(np.round(Vb,1)))
    plt.show()
#%% Use the created .dat files to make the plot in Fig. 3d, inset
default_color_cycle_C0Blue()
datam3 = np.loadtxt('AreaUnderPeaksM42MainRcNormalizedVbg=-3.0.dat')
Bm3, Am3 = datam3.T
Am3=Am3[::-1]
pm3 = [1, 2, 3, 4, 5]
datap3= np.loadtxt('AreaUnderPeaksM42MainRcNormalizedVbg=3.0.dat')
Bp3, Ap3 = datap3.T

pp3 = [1, 2, 3, 4, 5, 6]

plt.figure(figsize=[1.5,0.8])
plt.plot(pm3, Am3[:5]/Am3[0], 'oC7')
popt = np.polyfit(pm3[1:], Am3[1:5]/Am3[0],1)
pol = np.poly1d(popt)
plt.plot(pm3, pol(pm3),'C7')
plt.plot(pp3, Ap3[:6]/Ap3[0], 'oC0')
popt = np.polyfit(pp3[1:], Ap3[1:6]/Ap3[0],1)
pol = np.poly1d(popt)
plt.plot(pp3, pol(pp3),'C0')

plt.plot([1], [1], 'ok')
plt.xticks([1,3,5,7])
plt.yticks([0,1,2])
plt.tick_params(direction='in', top=True, right=True)
plt.ylabel('$A_p/A_1$', fontsize=20)
plt.xlabel('p', fontsize=20)
plt.savefig('Geom4RcNormalizedAreaUnderPeaksVbgpm3V.pdf')