# -*- coding: utf-8 -*-
"""
Created on Sat Jan 28 11:03:47 2023
Peak position analysis done by hand
@author: jinglaaynes
"""
from scipy.optimize import curve_fit
import matplotlib.pyplot as plt
import numpy as np
font = {'family' : 'DejaVu Sans',
        'weight' : 'normal',
        'size'   : '15'}
plt.rc('font', **font)
####### Input parameters device
Vcnp = 0# 0.15
L = 2.186E-6
Cbg = 0.001445

def linfun(x, a):
    return a*x

def linfun2(x, a, b):
    return a*np.array(x) + b

def focusFieldCalc(L, Vbgarr, err=False, dnr=0.14, dLr=0.1):
    el = 1.602E-19
    hbar = 1.05457182E-34
    n = Cbg*(np.array(Vbgarr)+Vcnp)/el #4/3.5*
    dn = n*dnr
    dL=L*dLr
    Bparr = 2*hbar*np.sqrt(np.abs(n)*np.pi)/(el*L)
    if err:    
        Bperr = Bparr * np.sqrt((dn/(2*np.abs(n)))**2+(dL/L)**2)
        return Bparr, Bperr
    else:
        return Bparr
    
def linFitAndPlotErrorBar(Vbg, Barr, Vcnp, filename='', plotBvsP=True):
    dB = 0.012
    #global slope, origin, sloperr, fit2, pcov
    slope = []
    origin = []
    fiterr = []
    sloperr = []
    for Vg, B in zip(Vbg, Barr):
        Order = []
        for i, V in enumerate(B):
            Order.append(i+1)
        Bcor = np.array(B) - 0.075
        
        
        popt, pcov = curve_fit(linfun2, Order, Bcor, sigma = [dB]*len(Bcor))
        err = np.sqrt(np.diag(pcov))
        #fitlist.append(fit)
        fiterr.append(pcov)
        
        slope.append(popt[0])
        if err[0]<1:
            sloperr.append(err[0])
        else:
            sloperr.append(np.sqrt(2)*dB)
        origin.append(popt[1])
        if plotBvsP:
            plt.errorbar(Order, Bcor, 0.013*np.ones(len(Bcor)), fmt='o',label='${}$ V'.format(Vg))
            plt.plot(Order, linfun2(Order, *popt), 'k--')
    if plotBvsP:
        plt.tick_params(direction='in', top=True, right=True)
        plt.ylabel('$B$ (T)', fontsize=20)
        plt.xlabel('$p$', fontsize=20)
        if filename != '':
            plt.savefig(filename+'.pdf')
        plt.show()
    return slope, origin, sloperr


def plotVbgDepErr(Vbg, slope, error, title='', filename=''):
    Vbgarr = np.linspace(-4.5, 3.5,200)
    Bparr, Bperr = focusFieldCalc(L, Vbgarr, err=True, dnr=0.14, dLr=0.1)
    
    Bpmin = Bparr - Bperr
    Bpmax = Bparr + Bperr
    plt.fill_between(Vbgarr, Bpmax, Bpmin,color='gray',alpha=0.5)
    plt.plot(Vbgarr, Bparr, 'k-', label='$2\hbar\sqrt{n\pi}/(eL)$')
    plt.errorbar(Vbg, np.abs(slope), yerr=error, xerr=[0.1]*len(error), fmt='o',capsize=2, label='$|dB/dp|$')
    #plt.plot(Vbg, np.abs(fit2list), 'o', label='fit origin 0')
    
    plt.xlabel('$V_\mathrm{bg}$ (V)', fontsize=20)
    plt.ylabel('$|dB/dp|$ (T)', fontsize=20)
    plt.tick_params(direction='in', top=True, right=True)
    plt.title(title)
    plt.xlim([-4.2,3.2])
    plt.legend()
    if filename != '':
        plt.savefig(filename+'.pdf')
    #plt.show()
    return

#%% M14 M16 Focus
Vbg=-4
Bm4=[0.314, 0.565, 0.795, 1.011] # , 1.290, 1.590
Rmaxm4=[175, 110.3, 68.8, 53.1, 58.4, 64.7]

Vbg=-3.5
Bm3p5=[0.29, 0.54, 0.7465, 0.952] # , 1.133, 1.228, 1.397
Rmaxm3p5=[174, 119, 52.8, 69.2, 31.8, 66.8, 46.9]

Vbg=-3
Bm3=np.array([0.277, 0.505, 0.700, 0.891]) # , 1.095, 1.119, 1.156, 1.179, 1.31
Rmaxm3=[182, 110, 56.6, 48.0, 45.9, 47.6,58.5, 58.2, 58.3]

Vbg=-2.5
Bm2p5=np.array([0.265, 0.446, 0.640, 0.794]) # , 1.01, 1.119, 1.18, 1.253
Rmaxm2p5=[145, 98.6, 54.0, 60.7, 41.9, 43.7, 60.7, 62.5]

Vbg=-2
Bm2=np.array([0.242, 0.41,0.578, 0.728]) # , 0.898, 0.972, 1.03, 1.08, 1.25, 1.298
Rmaxm2=[138, 104, 67.8, 83.7, 54.9, 88.2, 78.1, 76.0, 106.5, 119]

Vbg=-1.5
Bm1p5=np.array([0.205, 0.362, 0.506, 0.64]) # , 0.77, 0.855, 0.928
Rmaxm1p5=[71.7, 80.9, 50.9, 53.0, 52.4, 57.4, 78.4]

Vbg=-1
Bm1=[0.197, 0.277]
Rmaxm1=[180, 115.9]

# Vbg=-0.5
# Bm0p5=[0.158, 0.264, 0.315, 0.399, 0.469, 0.518, 0.602, 0.639]
# Rmaxm0p5=[109.7, 80.1, 71.8, 61.4, 51.0, 51.3, 41.1, ]
Vbg=1.5
B1p5=[-0.11, -0.265] # , -0.4227, -0.4819, -0.6998, -0.975
Rmax1p5=[652, 570, 201, 247, 469, 320]

Vbg=2
B2=[-0.132, -0.318, -0.482] # , -0.741, -0.813, -0.948, -1.19
Rmax2=[551.8, 315.4, 188.7, 48.9, 402, 111, 241]

Vbg=2.5
B2p5=[-0.146, -0.350, -0.529]
Rmax2p5=[339.5, 283.9, 232.3]

Vbg=3
B3=[-0.171, -0.375, -0.590] # , -0.9283, -1.024
Rmax3=[383.2, 268.5, 148.8, 228.9, 247.3]
Barr = [Bm4, Bm3p5,Bm3,Bm2p5,Bm2,Bm1p5, Bm1, B1p5, B2, B2p5, B3]
Vbg = [-4, -3.5, -3, -2.5, -2, -1.5, -1, 1.5, 2, 2.5, 3] 
####### Input parameters device
Vcnp = 0# 0.15
L = 2.186E-6
Cbg = 0.001445
####### Analysis with uncertainties
Vbgarr = np.linspace(-4, 3)
Bparr = focusFieldCalc(L, Vbgarr)
slope, origin, sloperr = linFitAndPlotErrorBar(Vbg, Barr, Vcnp, filename='BpeakvspM14toM16ErrBars')
fname='dBdpvsVbgM14toM16ErrBars'
plotVbgDepErr(Vbg, slope, sloperr, title='M14 M16', filename=fname)
plt.show()
#%% M30 and 31 Focus 
Vbg= -4
Bm4 = [-0.205, -0.48]
Rmaxm4 = [170, 80]
Bm4m = [-0.205, -0.399]

Vbg = -3
Bm3 = [-0.171, -0.423]
Rmaxm3 = [159, 82]
Bm3m = [-0.171, -0.338]

Vbg = -2
Bm2 = [-0.135, -0.35]
Rmaxm2 = [141, 56] 

Vbg = 3
B3 = [0.278, 0.505, 0.735, 0.952]
Rmax3 = [274, 142, 177, 143]    

Barr = [Bm4, Bm3,Bm2, B3]
Vbg = [-4, -3, -2, 3] 
####### Input parameters device
Vcnp = 0#-0.15
L = 2.072E-6
Cbg = 0.001445
####### Analysis  with uncertainties  
Vbgarr = np.linspace(-4, 3)
Bparr = focusFieldCalc(L, Vbgarr)
slope, origin, sloperr = linFitAndPlotErrorBar(Vbg, Barr, Vcnp, filename='BpeakvspM30toM31ErrBars')
fname='dBdpvsVbgM30toM31ErrBars'
plotVbgDepErr(Vbg, slope, sloperr, title='M30 and M31 2nd closed contacts',
              filename=fname)
Barr = [Bm4m, Bm3m]
slope, origin, sloperr = linFitAndPlotErrorBar(Vbg, Barr, Vcnp,
                                               filename='BpeakvspM30toM31ErrBars',
                                               plotBvsP=False)
plt.errorbar([-4, -3], np.abs(slope), yerr=sloperr, xerr=[0.1]*len(sloperr),
             fmt='o',capsize=2, label='$|dB/dp|$')
#plt.legend()
plt.savefig(fname+'.pdf')
plt.show()
#%% M32 Focus open point contacts
Vbg = -4
Bm4 = [-0.205, -0.446, -0.70, -0.928]
Rmaxm4 = [107, 78, 21, 58]

Vbg = -3
Bm3 = [-0.171, -0.386, -0.614, -0.80]
Rmaxm3 = [105, 76, 22, 60]

Vbg = -2
Bm2 = [-0.135, -0.314, -0.459, -0.650]
Rmaxm2 = [94, 64, 30, 47]

Vbg = 2
B2 = [0.235, 0.399, 0.555, 0.735]
Rmax2 = [215, 119, 49, 74]

Vbg = 3
B3 = [0.278, 0.495, 0.687, 0.88]
Rmax3 = [175, 118, 74, 66] 

Barr = [Bm4, Bm3,Bm2, B2, B3]
Vbg = [-4, -3, -2, 2, 3] 
####### Input parameters device
Vcnp = 0#-0.15
L = 2.12E-6
Cbg = 0.001445
####### Analysis with uncertainties  
Vbgarr = np.linspace(-4, 3)
Bparr = focusFieldCalc(L, Vbgarr)
slope, origin, sloperr = linFitAndPlotErrorBar(Vbg, Barr, Vcnp, filename='BpeakvspM32ErrBars')
plotVbgDepErr(Vbg, slope, sloperr, title='M32 Open point contacts 1', filename='dBdpvsVbgM32ErrBars')
plt.show()
#%% Open point contacts 2 M42 increasing B:
Vbg= -4
Bm4 = [-0.205,-0.445,-0.700]
Rmaxm4 = [90.9,78.4, 35.4]
Vbg= -3
Bm3 = [-0.171,-0.386,-0.601]
Rmaxm3 = [94.6,74.4,36]
Vbg= -2
Bm2 = [-0.135,-0.301,-0.469]
Rmaxm2 = [98.2, 60.3, 33.2]
Vbg= -1
Bm1 = [-0.084,-0.205,-0.325]
Rmaxm1 = [47,31,26.7]
Vbg= 1
B1 = [0.181,0.315, (0.422+0.469)/2]
Rmax1 = [47.5, 118, (57.7+84.6)/2]
Vbg= 2
B2 = [0.235,0.409,0.579,0.736]
Rmax2 = [134.5,119.5,105,26.3]
Vbg= 3
B3 = [0.277,0.482,0.699,0.905]
Rmax3 = [117,124,87.1,20]

Barr = [Bm4, Bm3, Bm2, B1, B2, B3]
Vbg = [-4, -3, -2, 1, 2, 3] 
####### Input parameters device
Vcnp = 0
L = 2.12E-6
Cbg = 0.001445
####### Analysis with uncertainties

Vbgarr = np.linspace(-4, 3)
Bparr = focusFieldCalc(L, Vbgarr)
slope, origin, sloperr = linFitAndPlotErrorBar(Vbg, Barr, Vcnp, filename='BpeakvspM42ErrBars')
plotVbgDepErr(Vbg, slope, sloperr, title='M42 Open point contacts 2', filename='dBdpvsVbgM42ErrBars')
plt.show()
#%%  Long distance focusing 28 to 14 M43
Vbg= -4
Bm4 = [-0.084,-0.205, -0.339,-0.469]
Rmaxm4 = [46, 64, 61, 30]
Vbg= -3
Bm3 = [-0.06,-0.172, -0.301,-0.409]
Rmaxm3 = [50, 61, 50, 35]
Vbg= -2
Bm2 = [-0.05,-0.135, -0.241,-0.338]
Rmaxm2 = [52, 53, 38, 17]
Vbg= -1
Bm1 = [-0.024, -0.837]
Rmaxm1 = [26, 20]
Vbg= 2
B2 = [0.15, 0.236, 0.325, 0.435, 0.518]
Rmax2 = [22, 100, 95, 45]
Vbg= 3
B3 = [0.171, 0.278, 0.386, 0.506, 0.602, 0.771]
Rmax3 = [112, 106, 104, 49, 86, 30]
Barr = [Bm4, Bm3,Bm2, B2, B3]
Vbg = [-4, -3, -2, 2, 3] 
####### Input parameters device
Vcnp = 0#-0.15
L = 4.21E-6
Cbg = 0.001445
####### Analysis with uncertainties 
Vbgarr = np.linspace(-4, 3)
Bparr = focusFieldCalc(L, Vbgarr)
slope, origin, sloperr = linFitAndPlotErrorBar(Vbg, Barr, Vcnp, filename='BpeakvspM43LongDistErrBars')
plotVbgDepErr(Vbg, slope, sloperr, title='M43 Long distance 1', filename='dBdpvsVbgM43LongDistErrBars')
plt.show()