# -*- coding: utf-8 -*-
"""
Created on Wed Jan 25 15:20:35 2023

@author: jinglaaynes
"""
import numpy as np
from matplotlib.ticker import AutoMinorLocator
import matplotlib.pyplot as plt
import matplotlib.cm as cm
def My_color_plot(x,y,z, xran=[], yran=[], zlim=[], n_ticks=5,tick_vals=[]):
    '''
    Version 1.0
    Function created 22nd Sept 2022 to create color plots. 
    To be as versatile as possible, the function does not have a plt.show()
    as this allows the axes labels to be defined apart.
    As usual, the font is DejaVu Sans and the size 15.
    '''
    font = {'family' : 'DejaVu Sans',
        'weight' : 'normal',
        'size'   : '15'}
    plt.rc('font', **font)
    if xran != [] and yran != []:
        xmin, xmax = min(xran), max(xran)
        ymin, ymax = min(yran), max(yran)
        filt_x = np.multiply(x<xmax,x>xmin)
        filt_y = np.multiply(y<ymax,y>ymin)
        filt = np.multiply(filt_x, filt_y)
        x = x[filt]
        y = y[filt]
        z = z[filt]
    
    x_uni = np.sort(np.unique(x))
    if x[0]>x[-1]:
        x_uni = x_uni[::-1]
    y_uni = np.sort(np.unique(y))
    if y[0]>y[-1]:
        y_uni = y_uni[::-1]
    x_grid, y_grid = np.meshgrid(x_uni, y_uni)
    z_grid = np.reshape(z, np.shape(x_grid)[::-1]).T
    #plt.contourf(Vbg, Vtg, Vdiff*1E-3,levels=50)
    origin = 'lower'
    if zlim == []:
        plt.contourf(x_grid, y_grid, z_grid,levels=200,vmin=0, cmap=cm.bwr,
                     origin = 0)
    else:
        plt.contourf(x_grid, y_grid, z_grid,levels=200,vmin=min(zlim),
                     vmax=max(zlim), cmap=cm.bwr,
                     origin = origin)
    plt.tick_params(direction='in', top=True, right=True)
    if tick_vals == []:
        zmax = np.floor(np.max(z_grid))
        zmin = np.floor(np.min(z_grid))
        ticks = np.linspace(zmin, zmax, n_ticks)
        t = [round(ti) for ti in ticks]
    else:
        t = tick_vals
    plt.colorbar(ticks=t)


def RmaxRminvsVbgPlot(filename, skiprows=18, Vbgran=[]):
    #global Rmax, Rmin, DRtg, Vbgs, Vtgmax
    data=np.loadtxt(filename, skiprows = skiprows)
    Vbg, Vtg, Vdiff, *other = data.T
    R0 = 25812 #Ohms
    Vbgs = np.sort(np.unique(Vbg))
    if Vbgran != []:
        filt_Vbgs = np.multiply(Vbgs>min(Vbgran), Vbgs<max(Vbgran))
        Vbgs = Vbgs[filt_Vbgs]
    Vtgmax = []
    Rmax = []
    Rmin = []
    for Vb in Vbgs:
        filt = Vbg == Vb
        Vtgfilt = Vtg[filt]
        Vdifffilt = Vdiff[filt]
        imax = np.argmax(Vdifffilt)
        imin = np.argmin(Vdifffilt)
        Vtgmax.append(Vtgfilt[imax])
        Rmax.append(Vdifffilt[imax]*1E7)
        Rmin.append(Vdifffilt[imin]*1E7)
    plt.plot(Vbgs, R0/np.array(Rmax), 'o')
    plt.xlabel('$V_\mathrm{bg}$ (V)', fontsize=20)
    plt.ylabel('$\sigma$ ($2e^2/h$)', fontsize=20)
    plt.tick_params(direction='in', top=True, right=True)
    plt.ylim([1,10])
    plt.grid()
    print(min(R0/np.array(Rmax)))
    np.savetxt(filename[:19]+'.dat', np.vstack((Vbgs, np.array(Vtgmax))).T)
    plt.savefig(filename[:19]+'.jpg')
    plt.show()
    DRtg = np.array(Rmax)-np.array(Rmin)
    G = R0/DRtg
    plt.plot(Vbgs, DRtg)
    plt.ylabel('Rmax-Rmin')
    plt.xlabel('Vbg (V)')
    print(min(np.array(Rmax[:-20])-np.array(Rmin[:-20])))
    print(filename[:19])
    return Vbgs, G
filename = 'M08_IV_32to18_100nA_1x.dat'
data = np.loadtxt(filename, skiprows=24)
Vbg, Vtg, Vx, Vy, time, Temp = data.T
My_color_plot(Vbg,Vtg,Vx*1E7*1E-3, zlim=[-1,8.6],n_ticks=5,
              tick_vals =np.linspace(1,7,4))
plt.xlabel('$V_\mathrm{bg}$ (V)', fontsize=20)
plt.ylabel('$V_\mathrm{tg}$ (V)', fontsize=20)
plt.savefig('ColormapM08Rc_18.pdf')
plt.savefig('ColormapM08Rc_18.jpg')
plt.show()
Vbgs, G = RmaxRminvsVbgPlot(filename, skiprows=24,Vbgran=[-4,3])

plt.show()
plt.figure(figsize=[4.5, 3])
plt.plot(Vbgs, G/4, linewidth=3)
plt.xlabel('$V_\mathrm{bg}$ (V)', fontsize=20)
plt.ylabel('$G$ ($4e^2/h$)', fontsize=20)
plt.ylim([0,10])
plt.gca().yaxis.set_minor_locator(AutoMinorLocator(n=2))
plt.tick_params(which='minor', direction='in', bottom=False, right=True)
plt.tick_params(direction='in', top=True, right=True)
plt.grid(axis='y', which='both')
plt.savefig('M08_GvsVbg_Cont18.pdf')