## Specular electron focusing between gate-defined quantum point contacts in bilayer graphene

By Josep Ingla-Ayns, Antonio L. R. Manesco, Talieh S. Ghiasi, Serhii
Volosheniuk, Kenji Watanabe, Takashi Taniguchi, and Herre S. J. van der Zant

### Folders

#### `theoretical_calculations`

* Subfolders:
  + `data`: data obtained from the simulations
  + `images`: images used in the manuscript
  + `modules`: python modules to perform the calculations
* Files
  + `angle_distribution.py`: compute angle distribution of injected states using a `kwant` tight-binding model.
  + `fermi_surface.py`: computes spectral density at the Fermi energy for experimental parameters to extract Fermi surface.
  + `semiclassical_focusing.py`: computes collected current for focusing setup.
  

#### `experimental_data`
* Subfolders
  +`BaseTColorMapAndG` : measured data and python code required to obtain the Resistance vs backgate and topgate voltage 
   plot (Fig. 1b) and obtain the corrected conductance of the quantum point contact (Fig. 1c). 
  + `FocusingBaseT` : measured data and python codes required to plot the focusing spectra in Figs. 2, 3, S7 and S8.
  Since the analysis requires the contact resistance, there is a subfolder called ContactResistance with the measured contact resistance.
  + `Reciprocity` : measured data used to show that the measured spectra follow reciprocity and the code required to reproduce Fig. S9.
  + `ShubnikovDeHaas` : measured data and python code used to determine the carrier density using the Shubnikov de Haas oscillations. 
  + `Tdependence` : measured data and python code required to plot the temperature dependence of the focusing signal and its associated
  analysis. It also includes the full plot of the contact magneto resistance at different temperatures.
  + `VbgdependenceRsq` : measured data and python code to obtain the channel square resistance vs backgate voltage traces required to
  reproduce Figs. S3b and S3c.
  + `Sample2` : measured data and python code to obtain the focusing spectra and quantum point contact resistances required to reproduce
  Fig. S11.
* Files
  +  `MapContactNumbers.png` : optical microscope image of the whole device 1 with the contact numbering used in the file naming system.
  +  `MapContactNumbersSample2.png` : optical microscope image of the whole device 2 with the contact numbering used in the file naming system.
* Measurement file naming conventions:
The filenames have the following structure:
M[XX]_[SampleName(optional)]_I[I+]to[I-]_[AppliedCurrent]_V[V+]to[V-]_[Vamplification]_[AdditionalComment(optional)].dat
where [XX] is the measurement number, [SampleName(optional)] is BLGhBN14 for sample 1 or BLGhBN09 for sample 2.
If it is missing, it implies sample 1.
[I+(-)] the contact number connected to the I+(-) terminal of the current source, [V+(-)] the contact
number connected to the V+(-) terminalof the voltage preamplifier, [Vamplification] is the amplification of the preamplifier,
 which has been already corrected while measuring so there is no need for further conversion.
The contact numbers are defined according to MapContactNumbers.png for sample 1
and MapContactNumbersSample2.png for sample 2.  
### Installation

Install [miniconda](http://conda.pydata.org/miniconda.html) and then the Python environment that contains all dependencies with:
```
conda env create -f environment.yml
```
then activate it with
```
source activate electron_focusing_blg
```

Finally, run the command `jupyter lab` to run the notebooks.

The plots require LaTeX installed. In Debian/Ubuntu, run:

```
sudo apt-get install texlive-full
```
or comment the custom `matplotlib` `rcParams`.
