# Description of Dataset.

This dataset belongs to simulations of different non-reflecting boundary conditions (NRBCs) in the framework of a two-dimensional 7th-order nodal discontinuous Galerkin solver. The equations governing the fluid flow are the non-linear Euler equations. Consequently, four types of benchmark problems are included:
1. [Isentropic Vortex](#isentropic-vortex)
2. [Pressure Pulse](#pressure-pulse)
3. [Periodic Pulse](#periodic-pulse)
4. [Vortex Shedding](#vortex-shedding)

Up to a total of 8 different NRBCs are considered, while a reference solution is included as well. These correspond to:

1. _Navier-Stokes Characteristic Boundary Condition: 1D_
2. _Navier-Stokes Characteristic Boundary Condition: 3D_
3. _Riemann Extrapolation_
4. _Perfectly Matching Layer_
5. _Sponge Layer_
6. _Extended Riemann Extrapolation Layer_
7. _Supersonic Layer_
8. _Supersonic Sponge Layer_
9. _Reference Solution_

Note, the reference solution is obtained from an extended numerical simulation with relatively far boundary conditions. The boundaries are distanced such that throughout the simulation, the data never reaches or interacts with them. Moreover, the same spatial and temporal discretization is retained as that utilized in the NRBCs.

In each of the benchmark folders, three data files can be found:

- `paramDict.cfg`
- `postprocessed.csv`
- `profile_0.dat`

The first (`paramDict.cfg`) corresponds to the configuration file used to generate the dataset using the in-house solver [ASC2D](https://github.com/inquisitor101/ASC2D.git). The second (`postprocessed.csv`), contains the normalized `L1`, `L2` and `Linf` norms of the difference between the NRBC simulation and the corresponding reference simulation, as a function of time. In the third (`profile_0.dat`), the simulation time as well as the reflection coefficient are provided. Note, the reflection coefficient is defined differently in each of the benchmark problems:

1. For the [Isentropic Vortex](#isentropic-vortex), the reflection coefficient is defined as:
    - `max( p/pinf ) / max( M/Minf )`


2. For the [Pressure Pulse](#pressure-pulse), the reflection coefficient is defined as:
    - `max( |p-pinf| / pinf )`


3. For the [Periodic Pulse](#periodic-pulse), the reflection coefficient is defined as:
    - `max( |p-pinf| / pinf )`


4. For the [Vortex Shedding](#vortex-shedding), no reflection coefficient is defined, rather the pressure and v-velocity is sampled from four different locations. The probe locations are:
    - `(-0.80, +0.25)`
    - `(-0.80, -0.25)`
    - `(+8.75, +0.45)`
    - `(+8.75, -0.45)`

In the above, `pinf` and `Minf` correspond to the time-independant background values of the pressure and Mach number, respectively.

---

## Isentropic Vortex

This example is based on a weak Mach number of `M = 0.0075`, with three separate angle-of-attacks (with respect to the x-axis): `0 [deg]`, `45 [deg]` and `60 [deg]`. These folders can be found in

- [`00 degrees`](./isentropic_vortex/Mach00075_alpha0)
- [`45 degrees`](./isentropic_vortex/Mach00075_alpha45)
- [`60 degrees`](./isentropic_vortex/Mach00075_alpha60)

## Pressure Pulse

This [example](./pressure_pulse/Mach0) is based on a quiescent flow `M = 0`, with all boundaries specified as outlets.

## Periodic Pulse

In this [example](./periodic_pulse/Mach0025_alpha45), a time-dependant Gaussian periodic pulse is introduced to excite the flow in a `M = 0.25` and a `45 [deg]` angle-of-attack.

## Vortex Shedding

In this final [example](./vortex_rollup/Mach_vary), a Kelvin-Helmholtz shear-flow instability is considered. The instability is introduced via a sinusoidal time-dependant source term added to the energy equation.

