

# jEULYNX prototype framework

## How to install
Both developers *and* end users (e.g. modelers) of our software must install it in the same way, namely by (i) downloading and (ii) importing the Java code in a Java-supporting IDE of their choice. Common Java IDEs are Eclipse and IntelliJ:
* https://www.eclipse.org/downloads/
* https://www.jetbrains.com/idea/download/

A Java SDK must be installed on your system. Some IDEs come with a Java JDK in their installation. The minimum JDK compliance level is 1.8, because we use
* type parameters, which were introduced in version 1.5;
* switch statements over strings, which is only permitted since version 1.7;
* and default methods in interfaces, which were introduced in version 1.8.
We used JDK 14 ourselves; the most recent version is JDK 15 (https://www.oracle.com/java/technologies/javase-jdk15-downloads.html).

We have worked with Eclipse for Java developers, and so we can describe in a little more detail how to get started. Once Eclipse is installed, do the following:
1. Download the source code.
2. In Eclipse, go to File -> New -> Java Project. Choose a name for your project, and click 'Finish'.
3. When Eclipse asks you to create a module-info.java file, click 'Don't Create'.
4. Go to File -> Import -> General -> File System and click 'Next'.
3. Click the 'Browse' button of the 'From directory' field and navigate to + click on the downloaded 'src' directory. Click 'Select Folder'.
4. Checkmark the 'src' directory in the overview of the resource tree; this automatically checkmarks all underlying resources.
5. Click the 'Browse' button of the 'Into folder' field and navigate to the 'src' directory of your newly created project.
6. Click 'Finish'.

## How to model
EULYNX models are captured in Java/jEULYNX in separate packages. Currently, our software provides the following example code:
* 'example.pdi' and the classes within; these define the generic part of EULYNX.
* 'example.point' and the classes within; these define the SCI_P interface specification of EULYNX (which depends on the generic part).

## How to run
In order to process the jEULYNX code of an interface specification, we must execute certain Java code. An example of this is the 'TranslatePoint' class in the 'main' package, which translates the SCI_P interface to mCRL2 (https://mcrl2.org/web/user_manual/index.html). The output is a file named 'model.mcrl2', which is created in the Eclipse project directory.



