package main;

import example.testing.*;
import lib.asal.parsing.ASALException;
import lib.blocks.models.*;
import lib.blocks.printing.*;
import lib.utils.ReflectionException;

public class TranslateTestSystem {
	public static void main(String[] args) throws ASALException, ReflectionException {
		ModelLib lib = new ModelLib();
		lib.add(System_IBD2.class);
		lib.add(Main.class);
		lib.add(Worker.class);
		lib.process();
		
		System.out.println("Instantiating model...");
		
		//Instantiate model:
		Model m = new Model(lib);
		m.add("system", System_IBD2.class);
		m.finish();
		
		m.get("main").setStateMachine(Main_STM.class);
		m.get("worker1").setStateMachine(Worker_STM.class);
		m.get("worker2").setStateMachine(Worker_STM.class);
		
		new GraphVizUBlockPrinter(new UnifyingBlock(m)).add("debug/ublock.gv").printAndPop();
		new GraphVizModelPrinter(m).add("debug/conformance.block.model.gv").printAndPop();
		new GraphVizModelPrinter2(m).add("debug/conformance2.block.model.gv").printAndPop();
		
		m.checkConformance();
		
		//Unifying block:
		UnifyingBlock ub = new UnifyingBlock(m);
		
		try {
			new MCRL2Printer(ub).add("model.mcrl2").printAndPop();
		} catch (ASALException e) {
			e.printStackTrace();
		}
	}
}
