package main;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import example.pdi.*;
import example.point.*;
import example.testing.Main_STM;
import lib.asal.parsing.ASALException;
import lib.asal.parsing.api.ASALLiteral;
import lib.blocks.models.*;
import lib.blocks.printing.*;
import lib.sim.JavaSimPrinter;
import lib.utils.ReflectionException;

public class TranslatePoint {
	public static void main(String[] args) throws ReflectionException, ASALException {
		ModelLib lib = new ModelLib();
		
		//Add generic:
//		lib.add(EfeS_BDD_1.class);
//		lib.add(EfeS_SCI_XX_BDD_1.class);
		lib.add(EfeS_SCI_XX_Functional_Connection_Domain_Context.class);
//		lib.add(EfeS_SCI_XX_PDI_BDD_1.class);
		lib.add(EfeS_SCI_XX_PDI_SR.class);
		lib.add(EfeS_SCI_XX_Protocol_Stack_SR.class);
		//lib.add(EfeS_SCI_XX_PS_BDD_1.class);
		lib.add(EULYNX_Field_Element_Subsystem_SR.class);
//		lib.add(F_EST_EfeS_BDD_1.class);
		lib.add(F_EST_EfeS_SR.class);
		lib.add(F_EST_EfeS.class);
		lib.add(F_SCI_EfeS_Sec_SR.class);
		lib.add(F_SCI_SCP_Sec_SR.class);
		lib.add(F_SMI_EfeS_SR.class);
		lib.add(S_SCI_EfeS_Prim_SR.class);
		lib.add(S_SCI_SCP_Prim_SR.class);
		lib.add(SCP.class);
		lib.add(Subsystem_Electronic_Interlocking_SR.class);
		
		//Add point:
		lib.add(F_P3_SR.class);
		lib.add(F_SCI_P_SR.class);
		lib.add(S_SCI_P_SR.class);
		lib.add(SCI_P_PDI_BDD_1.class);
		lib.add(SCI_P_PDI_SR.class);
		lib.add(SubS_P_BDD_2.class);
		lib.add(SubS_P_SR.class);
		
		//Done with declarations:
		lib.process();
		
		System.out.println("Instantiating model...");
		
		//Instantiate model:
		Model m = new Model(lib);
		m.add("pdi", SCI_P_PDI_SR.class); //Must match name in EfeS_SCI_XX_Protocol_Stack_SR!
		m.add("ps", EfeS_SCI_XX_Protocol_Stack_SR.class); //Any name is fine.
		m.add("fe", SubS_P_SR.class); //Must match name in EfeS_SCI_XX_Functional_Connection_Domain_Context!
		//m.add("fe", EULYNX_Field_Element_Subsystem_SR.class);
		m.add("ctx", EfeS_SCI_XX_Functional_Connection_Domain_Context.class); //Any name is fine.
		m.finish();
		
		m.get("sp").setStateMachine(SCI_P_STD_1.class);
		m.get("fp").setStateMachine(SCI_P_STD_2.class);
		m.get("prim").setStateMachine(SCI_EfeS_Prim_STD_1.class);
		m.get("sec").setStateMachine(SCI_EfeS_Sec_STD_1.class);
		m.get("scpPrim").setStateMachine(SCI_SCP_Prim_STD_1.class);
		m.get("scpSec").setStateMachine(SCI_SCP_Sec_STD_1.class);
		m.get("p3").setStateMachine(F_P3_SR_STD_1.class);
		m.get("est").setStateMachine(EST_EfeS_STD_2.class);
		
		new GraphVizUBlockPrinter(new UnifyingBlock(m)).add("debug/ublock.gv").printAndPop();
		new GraphVizModelPrinter(m).add("debug/conformance.block.model.gv").printAndPop();
		new GraphVizModelPrinter2(m).add("debug/conformance2.block.model.gv").printAndPop();
		new GraphVizModelPrinter3(m).add("debug/conformance3.block.model.gv").printAndPop();
		new GraphVizModelPrinter4(m).add("debug/conformance4.block.model.gv").printAndPop();
		
		m.checkConformance();
		
		//Unifying block:
		UnifyingBlock ub = new UnifyingBlock(m);
		
		Map<IBDInstances.IBD1Port, List<ASALLiteral>> EnvRestrictions;
		EnvRestrictions = new HashMap<IBDInstances.IBD1Port, List<ASALLiteral>>();
		EnvRestrictions.put(m.get("p3").getPortPerName().get("D37_Con_008400"), new ArrayList<ASALLiteral>());
		List<ASALLiteral> posOptions = new ArrayList<ASALLiteral>();
		posOptions.add(new ASALLiteral("\"LEFT\""));
		posOptions.add(new ASALLiteral("\"RIGHT\""));
		posOptions.add(new ASALLiteral("\"NO_END_POSITION\""));
		EnvRestrictions.put(m.get("p3").getPortPerName().get("D21_PM1_Position"), posOptions);
		ub.setEnvRestrictions(EnvRestrictions);
		
		Map<IBDInstances.IBD1Port, ASALLiteral> EnvPortsInitValues;
		EnvPortsInitValues = new HashMap<IBDInstances.IBD1Port, ASALLiteral>();
		EnvPortsInitValues.put(m.get("p3").getPortPerName().get("D37_Con_008400"), new ASALLiteral(true));
		ub.setInitialValuesEnvPorts(EnvPortsInitValues);
		
		new JavaSimPrinter(ub).add("src/lib/sim/JavaSimClass.java").printAndPop();
		
		try {
			new MCRL2Printer(ub).add("model.mcrl2").printAndPop();
		} catch (ASALException e) {
			e.printStackTrace();
		}
	}
}
