package main;

import example.pdi.*;
import example.point.*;
import example.testing.*;
import lib.asal.parsing.ASALException;
import lib.blocks.models.*;
import lib.blocks.printing.*;
import lib.utils.ReflectionException;

public class Program {
	public static void main(String[] args) throws ASALException, ReflectionException {
		ModelLib lib = new ModelLib();
		
		//Add generic:
//		lib.add(EfeS_BDD_1.class);
//		lib.add(EfeS_SCI_XX_BDD_1.class);
//		lib.add(EfeS_SCI_XX_Functional_Connection_Domain_Context.class);
//		lib.add(EfeS_SCI_XX_PDI_BDD_1.class);
//		lib.add(EfeS_SCI_XX_PDI_SR.class);
//		lib.add(EfeS_SCI_XX_Protocol_Stack_SR.class);
//		lib.add(EfeS_SCI_XX_PS_BDD_1.class);
//		lib.add(EULYNX_Field_Element_Subsystem_SR.class);
//		lib.add(F_EST_EfeS_BDD_1.class);
//		lib.add(F_EST_EfeS_SR.class);
//		lib.add(F_EST_EfeS.class);
//		lib.add(F_SCI_EfeS_Sec_SR.class);
//		lib.add(F_SCI_SCP_Sec_SR.class);
//		lib.add(F_SMI_EfeS_SR.class);
//		lib.add(S_SCI_EfeS_Prim_SR.class);
//		lib.add(S_SCI_SCP_Prim_SR.class);
//		lib.add(SCP.class);
//		lib.add(Subsystem_Electronic_Interlocking_SR.class);
		
		//Add point:
//		lib.add(F_P3_SR.class);
//		lib.add(F_SCI_P_SR.class);
//		lib.add(S_SCI_P_SR.class);
//		lib.add(SCI_P_PDI_BDD_1.class);
//		lib.add(SCI_P_PDI_SR.class);
//		lib.add(SubS_P_BDD_2.class);
//		lib.add(SubS_P_SR.class);
		
		lib.add(System_IBD2.class);
		lib.add(Main.class);
		lib.add(Worker.class);
		
		lib.process();
		
		System.out.println("Instantiating model...");
		
		//Instantiate model:
		Model m = new Model(lib);
		
		
		
		
		m.add("system", System_IBD2.class);
		
		
		
		
		//m.add("xxx", SCI_P_PDI_SR.class, new ParsedRenamingScheme());
		//m.add("yyy", SubS_P_SR.class, new ParsedRenamingScheme());
		//m.add("pstack", EfeS_SCI_XX_Protocol_Stack_SR.class, new ParsedRenamingScheme("pdi->xxx", "fe->yyy"));
		
		
//		m.add("yyy", SubS_P_SR.class, new ParsedRenamingScheme("fp->fp2", "prim->prim2", "sec->sec2"));
//		m.add("yyy", EULYNX_Field_Element_Subsystem_SR.class, new ParsedRenamingScheme("prim->prim2", "sec->sec2"));
		
		
//		m.add(EfeS_SCI_XX_Protocol_Stack_SR.class, new ParsedRenamingScheme("fe->xxx"));
		
		//m.add(EfeS_SCI_XX_PDI_SR.class, RenamingScheme.SINGLETONS);
		
//		m.add(EfeS_SCI_XX_Protocol_Stack_SR.class, RenamingScheme.SINGLETONS);
//		m.add(SCP.class, RenamingScheme.SINGLETONS);
//		m.add(Subsystem_Electronic_Interlocking_SR.class, RenamingScheme.SINGLETONS);
//		m.add(EULYNX_Field_Element_Subsystem_SR.class, RenamingScheme.SINGLETONS);
//		m.add(EfeS_SCI_XX_Functional_Connection_Domain_Context.class, RenamingScheme.SINGLETONS);
//		m.add(SCP.class, RenamingScheme.SINGLETONS);
		
		
		
		
		m.finish();
		
		m.get("main").setStateMachine(Main_STM.class);
		m.get("worker1").setStateMachine(Worker_STM.class);
		m.get("worker2").setStateMachine(Worker_STM.class);
		
		new GraphVizUBlockPrinter(new UnifyingBlock(m)).add("debug/ublock.gv").printAndPop();
		new GraphVizModelPrinter(m).add("debug/conformance.block.model.gv").printAndPop();
		new GraphVizModelPrinter2(m).add("debug/conformance2.block.model.gv").printAndPop();
		
		m.checkConformance();
		
		//Unifying block:
		UnifyingBlock ub = new UnifyingBlock(m);
		
		try {
			new MCRL2Printer(ub).add("model.mcrl2").printAndPop();
		} catch (ASALException e) {
			e.printStackTrace();
		}
	}
}
