package lib.utils;

import java.util.*;

public interface Textifiable {
	public String textify(LOD lod);
	
	default public String abbreviate(String text) {
		return abbreviate(text, "_");
	}
	
	default public String abbreviate(String text, String cutOff) {
		int index = text.indexOf(cutOff);
		
		if (index > 0) {
			return text.substring(0, index);
		}
		
		return text;
	}
	
	public static String textify(Collection<? extends Textifiable> source, LOD lod) {
		return textify(source, ", ", lod);
	}
	
	public static String textify(Collection<? extends Textifiable> source, String separator, LOD lod) {
		if (source.size() > 0) {
			Iterator<? extends Textifiable> q = source.iterator();
			String result = q.next().textify(lod);
			
			while (q.hasNext()) {
				result += separator + q.next().textify(lod);
			}
			
			return result;
		}
		
		return "";
	}
	
	public static String textifyUnique(Collection<? extends Textifiable> source, LOD lod) {
		return textify(source, ", ", lod);
	}
	
	public static String textifyUnique(Collection<? extends Textifiable> source, String separator, LOD lod) {
		if (source.size() > 0) {
			Set<String> texts = new HashSet<String>();
			
			for (Textifiable element : source) {
				texts.add(element.textify(lod));
			}
			
			Iterator<String> q = texts.iterator();
			String result = q.next();
			
			while (q.hasNext()) {
				result += separator + q.next();
			}
			
			return result;
		}
		
		return "";
	}
}
