package lib.utils;

import java.lang.reflect.Field;
import java.util.*;

import lib.blocks.models.SourceType;

public class Sources {
	private Set<Class<?>> clzs;
	private Set<Field> fields;
	
	public Sources() {
		clzs = new HashSet<Class<?>>();
		fields = new HashSet<Field>();
	}
	
	public Sources(Sources source) {
		clzs = new HashSet<Class<?>>(source.clzs);
		fields = new HashSet<Field>(source.fields);
	}
	
	public Sources(Sources source1, Sources source2) {
		this(source1);
		
		add(source2);
	}
	
	public boolean isEmpty() {
		return fields.isEmpty();
	}
	
	public void add(Class<?> addition) {
		if (addition != null) {
			clzs.add(addition);
		}
	}
	
	public void add(Field addition) {
		if (addition != null) {
			fields.add(addition);
			add(addition.getDeclaringClass());
		}
	}
	
	public void add(Sources other) {
		clzs.addAll(other.clzs);
		fields.addAll(other.fields);
	}
	
	public Set<Class<?>> getClzs() {
		return Collections.unmodifiableSet(clzs);
	}
	
	public Set<Field> getFields() {
		return Collections.unmodifiableSet(fields);
	}
	
	public String toString(String indent, String header) {
		String result = indent + header;
		
		if (fields.size() > 0) {
			for (Field f : fields) {
				Class<?> srcClz = f.getDeclaringClass();
				result += "\n" + indent + "\tfrom field " + f.getName() + " of " + SourceType.get(srcClz).prettyName + " \"" + srcClz.getCanonicalName() + "\"";
			}
		} else {
			if (clzs.size() > 0) {
				for (Class<?> c : clzs) {
					result += "\n" + indent + "\tfrom  " + SourceType.get(c).prettyName + " \"" + c.getCanonicalName() + "\"";
				}
			} else {
				result += "\n" + indent + "\t<no sources found>";
			}
		}
		
		return result;
	}
}
